#include "iplistviewitem.h"

IpListViewItem::IpListViewItem ( QListView * parent ) : QListViewItem( parent)
{
   Online = FALSE;
}

IpListViewItem::IpListViewItem ( QListViewItem * parent ): QListViewItem( parent)
{
   Online = FALSE;
}

IpListViewItem::IpListViewItem ( QListView * parent, QListViewItem * after ): QListViewItem( parent, after )
{
   Online = FALSE;
}

IpListViewItem::IpListViewItem ( QListViewItem * parent, QListViewItem * after )
: QListViewItem( parent, after )
{
   Online = FALSE;
}

IpListViewItem::IpListViewItem ( QListView * parent, QString label )
: QListViewItem( parent, label )
{
   Online = FALSE;
}
IpListViewItem::IpListViewItem ( QListViewItem * parent, QString label )
: QListViewItem( parent, label )
{
   Online = FALSE;
}


// Returns < 0 if this item is less than i,
// 0 if they are equal and > 0 if this item is greater than i.
//
// default: return key( col, ascending ).compare( i->key( col, ascending) );
int IpListViewItem::compare( QListViewItem * i, int col, bool asc ) const
{
   //   qDebug("in COMPARE");
   if ( col == 0 )
   {
      unsigned int x1=0,x2=0,x3=0,x4=0, y1=0,y2=0,y3=0,y4=0;
      bool Result = FALSE;
      QString ipOwn = text( col );
      QString ipI = i->text( col );
      //qDebug( ipOwn.section('.',0,0) + " | " + ipOwn.section('.',1,1) + " | " + ipOwn.section('.',2,2) + " | " +  ipOwn.section('.',3,3) );
      
      x1 = ipOwn.section('.',0,0).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      x2 = ipOwn.section('.',1,1).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      x3 = ipOwn.section('.',2,2).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      x4 = ipOwn.section('.',3,3).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      
      y1 = ipI.section('.',0,0).toUInt( &Result ) ;
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      y2 = ipI.section('.',1,1).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      y3 = ipI.section('.',2,2).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
      y4 = ipI.section('.',3,3).toUInt( &Result );
      if ( ! Result ) { qDebug("conversation QString ip to uint fails"); return 0; }
   
      if ( x1 < y1 ) return -1;
      else if ( x1 > y1 ) return 1;
      else // x1=y1
      {
	 if ( x2 < y2 ) return -2;
	 else if ( x2 > y2 ) return 2;
	 else // x2=y2
	 {
	    if ( x3 < y3 ) return -3;
	    else if ( x3 > y3 ) return 3;
	    else // x3=y3
	    {
	       if ( x4 < y4 ) return -4;
	       else if ( x4 > y4 ) return 4;
	       else // x4=y4
	       {
		  return 0;
	       }
	    }
	 }
      }
   }
   else return QListViewItem::compare( i, col, asc );
}



