/*
Copyright (C) 2005  Oleg Grigoriev

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "iprangelister.h"

//#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>



int ipRangeLister::setRange(const QString range)
{
#ifdef IPRANGELISTER_DEBUG
   qDebug(QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + "setRange(const QString range) range = " + range  );
#endif
   
   QString wasrange = QString(firstAddress) + QString("-") + QString(lastAddress);
   if ( range == wasrange ) return 0;
   
   QString c1,c2;
   c1 = range.section("-", 0,0).stripWhiteSpace();
   c2 = range.section("-", 1,1).stripWhiteSpace();
   if ( c1.isEmpty() || c2.isEmpty() ) 
   { 
      qWarning(QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + "Wrong range: " + range );
      return  SET_RANGE_ERROR;
   }
   
   in_addr addres;
   
   int res = inet_aton( c1.local8Bit(), &addres );
   if ( res == (int)INADDR_NONE )
   {
      qWarning(QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + "Wrong address1: " + c1 );
      return  SET_RANGE_ERROR;
   }
   fAddr = __bswap_32(addres.s_addr);
   
   res = inet_aton( c2.local8Bit(), &addres );
   if ( res == (int)INADDR_NONE )
   {
      qWarning(QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + "Wrong address2: " + c2 );
      return  SET_RANGE_ERROR;
   }
   lAddr = __bswap_32(addres.s_addr);
   
   if ( fAddr > lAddr )
   {
      qWarning(QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + "address1 > address2!");
      return  SET_RANGE_ERROR;
   }
   
   firstAddress = c1.local8Bit();
   lastAddress = c2.local8Bit();   
   changed = TRUE;
#ifdef IPRANGELISTER_DEBUG
   qDebug( QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + QString("setRange() firstAddress= ") 
           + QString(firstAddress) 
           + QString(" lastAddress= ") + QString(lastAddress) 
           + QString("  [  %1 - %2  ]").arg(fAddr,0,16).arg(lAddr,0,16) );
#endif   
   return 0;
}


QStringList ipRangeLister::getIpList()
{
   if (changed) makeList();
   return (const QStringList) iplist;
}

void ipRangeLister::makeList()
{
   QCString nowaddr = "";
   QString toAdd;
   in_addr addres;
   iplist.clear();
   for (unsigned long int i = fAddr; i<=lAddr; i++ )
   {
      addres.s_addr = __bswap_32(i);
      nowaddr = inet_ntoa( addres );
      toAdd = QString(nowaddr);
      if ( toAdd.section(".",3,3) != QString("0") && toAdd.section(".",3,3) != QString("255") )
      iplist.append( toAdd ); 
      
   }
   iplist.append( "" ); 
   
#ifdef IPRANGELISTER_DEBUG
qDebug( QString("%1:%2\t").arg(__FILE__).arg(__LINE__) + QString("makeList() count=")
        + QString::number( iplist.count() ) );
#endif   
   
   changed = FALSE;
}
