/*
Copyright (C) 2005  Oleg Grigoriev

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include "../sharescanner/sharescanner.h"
//#include "../iplistviewitem/iplistviewitem.h"
#include "configuredlg.h"


#include <qmessagebox.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qspinbox.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfiledialog.h>
#include <qstatusbar.h> 
#include <qapplication.h> 
#include <qdatetime.h> 
#include <qlineedit.h> 
#include <qpopupmenu.h> 
#include <qptrlist.h> 
#include <qinputdialog.h> 
#include <qprogressbar.h>
#include <qsettings.h>

#define  ConfigFileName "linscope"
#define  DefaultFileName   "range.xml"
#define  FavoritesFileName   "favorite.xml"
#define  CaptionName   "LinScope v.0.3.2"
#define  RelativePath  "/linscope/"

#define  ID_ADDFAVOR 1
#define  ID_SCAN     2
#define  ID_COMMENT  3
#define  ID_REMOVE   4

QStringList rangeList;
QStringList ipList;
QString currentRange;
unsigned int HostsUp, TotalHosts, DoneHosts, RangeTotalHosts, RangeDoneHosts;
QTime spendTime;

ConfigureDlg *confdlg;

QProgressBar *progress;
QSettings settings;

QString  smb_user_cmd;
QString  http_user_cmd;
QString  ftp_user_cmd;

bool	smb_use_user_cmd;
bool	ftp_use_user_cmd;
bool	http_use_user_cmd;

QListViewItemIterator itFind;
QString textFind;

void Form1::init()
{
   TotalHosts = 0;
   HostsUp = 0;
   DoneHosts = 0;
   RangeTotalHosts = 0;
   RangeDoneHosts = 0;
   
   listView1->setSorting(0);

   listView1->setResizeMode( QListView::AllColumns );
   listView2->setResizeMode( QListView::AllColumns );
   
   setCaption(CaptionName);
   xmlFiler = new Xmller();
   QString lpath = QDir::homeDirPath() + QString(RelativePath);
   QDir sdir(lpath);
   if ( !sdir.exists() ) sdir.mkdir(lpath);
   QString fn = lpath + QString(DefaultFileName);
   xmlFiler->loadFromXmlFile( listView1, fn );
   fn = lpath + QString(FavoritesFileName);
   xmlFiler->loadFromXmlFile( listView2, fn );


   currentRange ="";
   
   progress = new QProgressBar(this);
   progress->setMaximumWidth(200);
   
   this->statusBar()->addWidget( progress, 0, TRUE );
   
   showStat();
   
   menuIpList1 = new QPopupMenu(this);
   menuIpList1->insertItem( QPixmap::fromMimeSource("bookmark.png"), QString( tr("Add to favorites") ), ID_ADDFAVOR );
   menuIpList1->insertItem( QPixmap::fromMimeSource("stock_refresh.png"), QString( tr("Scan") ), ID_SCAN );
   menuIpList1->insertItem( QPixmap::fromMimeSource("pencil.png"), QString( tr("Add comment") ), ID_COMMENT );
   
   menuRangeList1 = new QPopupMenu(this);
   menuRangeList1->insertItem( QPixmap::fromMimeSource("stock_refresh.png"), QString( tr("Scan") ), ID_SCAN  );
   menuRangeList1->insertItem( QPixmap::fromMimeSource("pencil.png"), QString( tr("Add comment") ), ID_COMMENT );
   
   menuIpList2 = new QPopupMenu(this);
   menuIpList2->insertItem( QPixmap::fromMimeSource("editcut.png"), QString( tr("Remove") ), ID_REMOVE );
   menuIpList2->insertItem( QPixmap::fromMimeSource("pencil.png"), QString( tr("Add comment") ), ID_COMMENT );
   
   connect(&shscan, SIGNAL( findShare( QString * , QStringList * )  ), this, SLOT( onFindShare( QString * , QStringList * )  ) );      
   connect(&shscan, SIGNAL( scanDone()  ), this, SLOT( onScanDone()  ) );      
   connect(&shscan, SIGNAL( scanNowIp( QString * )  ), this, SLOT( onScanIpNow(QString * )  ) );
   
   connect(menuIpList1, SIGNAL( activated ( int )  ), this, SLOT( onMenuIpList1( int )  ) );
   connect(menuRangeList1, SIGNAL( activated ( int )  ), this, SLOT( onMenuRangeList1( int )  ) );
   
   connect(menuIpList2, SIGNAL( activated ( int )  ), this, SLOT( onMenuIpList2( int )  ) );

   QString key = QString(ConfigFileName) + QString("/TimeOuts/connect_to");
   spinBox9_4->setValue( settings.readNumEntry( key, 5000 ) );

   key = QString(ConfigFileName) + QString("/TimeOuts/rpcclient_to");
   spinBox9->setValue( settings.readNumEntry( key, 25000 ) );

   key = QString(ConfigFileName) + QString("/TimeOuts/mainloop_to");
   spinBox9_3->setValue( settings.readNumEntry( key, 1500 ) );

   key = QString(ConfigFileName) + QString("/ProcessCount/proc_count");
   spinBox9_2->setValue( settings.readNumEntry( key, 60 ) );

   key = QString(ConfigFileName) + QString("/Services/http_check");
   checkBox1_2->setChecked( settings.readBoolEntry( key, TRUE ) );

   key = QString(ConfigFileName) + QString("/Services/ftp_check");
   checkBox1->setChecked( settings.readBoolEntry( key, TRUE ) );
   //------------
   key = QString(ConfigFileName) + QString("/Services/smb_user_cmd");
   smb_user_cmd = settings.readEntry( key, "" );

   key = QString(ConfigFileName) + QString("/Services/http_user_cmd");
   http_user_cmd = settings.readEntry( key, "mozilla $I" );
   
   key = QString(ConfigFileName) + QString("/Services/ftp_user_cmd");
   ftp_user_cmd = settings.readEntry( key, "mozilla $I" );

   key = QString(ConfigFileName) + QString("/Services/smb_use_user_cmd");
   smb_use_user_cmd = settings.readBoolEntry( key, FALSE );
   
   key = QString(ConfigFileName) + QString("/Services/ftp_use_user_cmd");
   ftp_use_user_cmd = settings.readBoolEntry( key, FALSE );

   key = QString(ConfigFileName) + QString("/Services/http_use_user_cmd");
   http_use_user_cmd = settings.readBoolEntry( key, FALSE );

   confdlg = new ConfigureDlg( this );
}


void Form1::fileNew()
{
   listView1->clear();
   activeFile = "";
   showOnOnly->setOn(FALSE);
}


void Form1::fileOpen()
{
   QString lpath = QDir::homeDirPath() + QString(RelativePath);
   QString fn = QFileDialog::getOpenFileName(  lpath,
                                               "XML (*.xml)",
                                               this,
                                               tr("open file dialog"),
                                               tr("Choose a file to open") );
   if ( !fn.isEmpty() )
   {
      showOnOnly->setOn(FALSE);
      listView1->clear();
      xmlFiler->loadFromXmlFile( listView1, fn ); 
      activeFile = fn;
      statusBar()->message( QString(tr("Loaded file ")) + activeFile, 3000 );
      setCaption(CaptionName + QString("   ")+ activeFile);
   }
   else statusBar()->message( tr("Loading aborted"), 3000 );
   
}


void Form1::fileSave()
{
   if ( activeFile.isEmpty() )
   {
      fileSaveAs();
   }
   else
   {
      xmlFiler->saveToXmlFile( listView1, activeFile );
   }
}


void Form1::fileSaveAs()
{
   QString lpath = QDir::homeDirPath() + QString(RelativePath);
   QString fn = QFileDialog::getSaveFileName(
                                             lpath,
                                             "XML (*.xml)",
                                             this,
                                              tr("save file dialog"),
                                              tr("Choose a filename to save under") );
   if ( !fn.isEmpty() )
   {
      if ( fn.section('.',-1,-1) != "xml" ) fn.append( QString(".xml") );
      xmlFiler->saveToXmlFile( listView1, fn ); 
      activeFile = fn;
      setCaption(CaptionName + QString("   ")+ activeFile);
   }
   else statusBar()->message( tr("Saving aborted"), 2000 );
   
}

void Form1::deInit()
{
   QString fn;
   QString lpath = QDir::homeDirPath() + QString(RelativePath);
   if ( activeFile.isEmpty() )
   {   
      fn = lpath + QString(DefaultFileName);
   }
   else
   {
      fn = activeFile;
   }
   xmlFiler->saveToXmlFile( listView1, fn );
   fn = lpath + QString(FavoritesFileName);
   xmlFiler->saveToXmlFile( listView2, fn );
   //qDebug("EXITING");
   delete xmlFiler;

   //settings.writeEntry(
   QString key = QString(ConfigFileName) + QString("/TimeOuts/connect_to");
   settings.writeEntry( key , spinBox9_4->value() );
   
   key = QString(ConfigFileName) + QString("/TimeOuts/rpcclient_to");
   settings.writeEntry( key , spinBox9->value() );
   
   key = QString(ConfigFileName) + QString("/TimeOuts/mainloop_to");
   settings.writeEntry( key , spinBox9_3->value() );
   
   key = QString(ConfigFileName) + QString("/ProcessCount/proc_count");
   settings.writeEntry( key , spinBox9_2->value() );

   key = QString(ConfigFileName) + QString("/Services/http_check");
   settings.writeEntry( key , checkBox1_2->isChecked() );
   
   key = QString(ConfigFileName) + QString("/Services/ftp_check");
   settings.writeEntry( key , checkBox1->isChecked() );
   //------------
   key = QString(ConfigFileName) + QString("/Services/smb_user_cmd");
   settings.writeEntry( key, smb_user_cmd );
   
   key = QString(ConfigFileName) + QString("/Services/http_user_cmd");
   settings.writeEntry( key, http_user_cmd );
   
   key = QString(ConfigFileName) + QString("/Services/ftp_user_cmd");
   settings.writeEntry( key, ftp_user_cmd );
   
   key = QString(ConfigFileName) + QString("/Services/smb_use_user_cmd");
   settings.writeEntry( key, smb_use_user_cmd );
   
   key = QString(ConfigFileName) + QString("/Services/ftp_use_user_cmd");
   settings.writeEntry( key, ftp_use_user_cmd );
   
   key = QString(ConfigFileName) + QString("/Services/http_use_user_cmd");
   settings.writeEntry( key, http_use_user_cmd );

}

void Form1::fileExit()
{
   close();
}

void Form1::closeEvent( QCloseEvent *e )
{
   deInit();
   e->accept();
}

void Form1::editCut()
{
//
}


void Form1::editCopy()
{
//
}


void Form1::editPaste()
{
//
}


void Form1::editFind()
{
   bool ok;
   QString text = QInputDialog::getText(
                                         tr("Find"), tr("search:"), QLineEdit::Normal,
                                         QString::null, &ok, this );
   if ( ok )
   {
      
      textFind = text;
      
      itFind = QListViewItemIterator( listView1 );
      
      while ( itFind.current() )
      {
	 QListViewItem *item = itFind.current();
         if ( item->text(0).contains( textFind, FALSE ) || item->text(1).contains( textFind, FALSE ) )
	 {
	    listView1->setCurrentItem( item );
	    listView1->ensureItemVisible(item);
	    return;
	 }
	 ++itFind;
      }
   }
   
}


void Form1::editFindNext()
{
   ++itFind;
   while ( itFind.current() )
   {
      QListViewItem *item = itFind.current();
      if ( item->text(0).contains( textFind, FALSE ) || item->text(1).contains( textFind, FALSE ) )
      {
         listView1->setCurrentItem( item );
         listView1->ensureItemVisible(item);
         return;
      }
      ++itFind;
   }
}

void Form1::helpAbout()
{  
   QString info = tr("\t\tGNU GPL Linscope\n\n \
        This  is  just  test  version, so any bugs comments, patches,\n \
      future request and so on you can send  to  afrit[at}rambler.ru\n \
      Samba's  'rpcclient' is   needed  for  enumerating  smb  shares\n \
      If you have problems with proper codepage, check yours smb.conf\n \
      for    options:  dos charset;  unix  charset;  display  charset\n \
      Copyright (C) 2005  O. Grigoriev\n  ");
   QMessageBox::information( this, tr("About"), info );
}


void Form1::btnAddRange_clicked()
{
}


void Form1::btnAddRange_pressed()
{
   if ( spinBox1->value() > spinBox1_5->value()  )  return;
   
   QString range = spinBox1->text() + QString(".") + spinBox1_2->text()
      + QString(".") + spinBox1_3->text() + QString(".") + spinBox1_4->text()
      + QString("-") + spinBox1_5->text() + QString(".") + spinBox1_2_2->text()
      + QString(".") + spinBox1_3_2->text() + QString(".") + spinBox1_4_2->text();
   
 
   
   QListViewItem *mainitem;
   
   if ( listView1->findItem(range,0) == 0 )
   {
   
      mainitem = new QListViewItem( listView1, range );
      listView1->insertItem( mainitem  );
      mainitem->setPixmap ( 0, QPixmap::fromMimeSource( "many-comp.png"  ) );
      mainitem->setOpen(TRUE);
   }
   
}


void Form1::btnRemoveRange_clicked()
{
      
   QString range = spinBox1->text() + QString(".") + spinBox1_2->text()
      + QString(".") + spinBox1_3->text() + QString(".") + spinBox1_4->text()
      + QString("-") + spinBox1_5->text() + QString(".") + spinBox1_2_2->text()
      + QString(".") + spinBox1_3_2->text() + QString(".") + spinBox1_4_2->text();
     
   QListViewItem *mainitem = listView1->findItem(range,0);
   
   if ( mainitem != 0 )
   {
      listView1->removeItem( mainitem );
   }
}


void Form1::listView1_clicked( QListViewItem *item )
{
   if ( item != 0 ) if ( item->depth() == 0 )
   {
      QString range = item->text(0);
      QString left = range.section('-',0,0);
      QString right = range.section('-',1,1);
      
      spinBox1->setValue( left.section('.',0,0).toInt() );
      spinBox1_2->setValue( left.section('.',1,1).toInt() );
      spinBox1_3->setValue( left.section('.',2,2).toInt() );
      spinBox1_4->setValue( left.section('.',3,3).toInt() );
      
      spinBox1_5->setValue( right.section('.',0,0).toInt() );
      spinBox1_2_2->setValue( right.section('.',1,1).toInt() );
      spinBox1_3_2->setValue( right.section('.',2,2).toInt() );
      spinBox1_4_2->setValue( right.section('.',3,3).toInt() );
      
   }
}

void Form1::refreshAction_activated()
{
   rangeList.clear();
   ipList.clear();
   QListViewItem *item = listView1->firstChild();
   if ( item !=0 )
   {
      while ( item !=0 )
      {
         if (item !=0 )
         {
            rangeList << item->text(0);
            item = item->nextSibling();
         }
           
      }
   }
   //qDebug( rangeList.join(" , ") );
   if ( rangeList.count() > 0 )
   {
      
      
      setIpList();
      
      buttonGroup1->setEnabled(FALSE);
      buttonGroup2->setEnabled(FALSE);
      fileOpenAction->setEnabled(FALSE);
      fileNewAction->setEnabled(FALSE);
      
      refreshAction->setEnabled(FALSE);
      stopRefreshAction->setEnabled(TRUE);
      
      spendTime.start();
      HostsUp = 0;   
      TotalHosts = 0;
      runScaning();
      
   } 
   else statusBar()->message( tr("No ip ranges available"), 5000 );
   
}

void Form1::runScaning()
{
   RangeTotalHosts = ipList.count() - 1;
   TotalHosts += RangeTotalHosts;
   RangeDoneHosts = 0;
   progress->setTotalSteps( RangeTotalHosts );
   progress->setProgress( RangeDoneHosts );
   shscan.scan( &ipList, spinBox9_2->value() , spinBox9->value(), spinBox9_3->value(), spinBox9_4->value(), checkBox1->isChecked(), checkBox1_2->isChecked() );
}

void Form1::setIpList()
{
   ipList.clear();
   if ( rangeList.count() > 0 )
   {
      ipRangeLister *ir = new ipRangeLister();
      ir->setRange( rangeList[0] );
      currentRange = rangeList[0];
      rangeList.remove( rangeList.first() );
      
      ipList = ir->getIpList();
      
      //qDebug( ipList.join(" , ") );
      delete ir;
   }   
}


void Form1::stopRefreshAction_activated()
{
   shscan.stopScan();
   rangeList.clear();
   ipList.clear();
   buttonGroup1->setEnabled(TRUE);
   buttonGroup2->setEnabled(TRUE);
   fileOpenAction->setEnabled(TRUE);
   fileNewAction->setEnabled(TRUE);
   stopRefreshAction->setEnabled(FALSE);
   refreshAction->setEnabled(TRUE); 
}


void Form1::onScanDone()
{
   progress->setProgress( RangeTotalHosts );
   //
   setIpList();
   if ( ipList.count() > 0 )
   {
      runScaning(); 
   }
   else
   {
      showStat();
      rangeList.clear();
      ipList.clear();
      buttonGroup1->setEnabled(TRUE);
      buttonGroup2->setEnabled(TRUE);
      fileOpenAction->setEnabled(TRUE);
      fileNewAction->setEnabled(TRUE);
      stopRefreshAction->setEnabled(FALSE);
      refreshAction->setEnabled(TRUE); 
      
   }

}


void Form1::listView1_doubleClicked( QListViewItem *item )
{
   if ( item != 0 ) if ( item->depth() == 2  )
   {
      QListViewItem *itemUp; 
      itemUp = item->parent();

      const char FIELD_SEP = '^';
   
      QString ct = "smb://" + itemUp->text(0) + "/"+ item->text(0);
      QString shr = "//" + itemUp->text(0) + "/"+ item->text(0);
      QString command;
      
      QProcess *look = new QProcess( this, ct );
      look->clearArguments();

      QStringList cmd;

      if ( item->text(0) == "ftp://" )
      {
         ct = item->text(0) + itemUp->text(0);
         shr = itemUp->text(0);
         if ( ftp_use_user_cmd )
         {
            command = ftp_user_cmd;
            command.replace( "$I", ct);
            command.replace( "$S", shr);
         }
         else
         {
            command = QString("konqueror") + QString("^") + ct;
         }
         
      }

      else if ( item->text(0) == "http://" )
      {
         ct = item->text(0) + itemUp->text(0);
         shr = itemUp->text(0);
         if ( http_use_user_cmd )
         {
            command = http_user_cmd;
            command.replace( "$I", ct);
            command.replace( "$S", shr);
         }
         else
         {
            command = QString("konqueror") + QString("^") + ct;
         }
         
      }
      else
      {
         if ( smb_use_user_cmd )
         {
            command = smb_user_cmd;
            command.replace( "$I", ct);
            command.replace( "$S", shr);
         }
         else
         {
            command = QString("konqueror") + QString("^") + ct;
         }
      }  

      cmd = QStringList::split(FIELD_SEP, command );
      
      look->setArguments( cmd ); 
      if ( !look->start() ) {
        // error handling
         QMessageBox::critical( 0,
                                tr("Fatal error"),
                                tr("Could not start konqueror"),
                                tr("Quit") );
      }
      
      
   }
}

void Form1::listView2_doubleClicked( QListViewItem *item )
{
   listView1_doubleClicked( item );
}

void Form1::editShow_sharesAction_activated()
{
   QListViewItem *range;
   QListViewItem *ip;
   
   range = listView1->firstChild();
   if ( range != 0 )
      while ( range !=0  )
      {
         ip = range->firstChild();
         if ( ip != 0 )
            while ( ip !=0  )
            {
               ip->setOpen(TRUE);
               ip = ip->nextSibling();  
            }
         range = range->nextSibling();  
      }
}


void Form1::editShow_hostsAction_activated()
{
   QListViewItem *range;
   QListViewItem *ip;
      
   range = listView1->firstChild();
   if ( range != 0 )
      while ( range !=0  )
      {
         ip = range->firstChild();
         if ( ip != 0 )
            while ( ip !=0  )
            {
               ip->setOpen(FALSE);
               ip = ip->nextSibling();  
            }
         range = range->nextSibling();  
      }
}

void Form1::showStat()
{

   if ( !spendTime.isNull() ) statusBar()->message( QString(tr("total scanned:  ")) +  QString::number(TotalHosts)+ QString(tr(" online:  "))
       + QString::number(HostsUp) + QString(tr("  spend time ")) + QString::number(spendTime.elapsed()/1000 ) + QString(tr(" s"))  );

   else statusBar()->message( QString(tr("total scanned:  ")) +  QString::number(TotalHosts)
                           + QString(tr(" online:  ")) + QString::number(HostsUp) );
}

void Form1::addIpShares(QString ip, QStringList shares)
{
   QListViewItem *rangeItem;
   IpListViewItem *ipItem=0;
   QListViewItem *shareItem;
   QString comment;
   
   QListViewItem *fav = listView2->findItem(QString("favorites"),0);
   QListViewItem *favitem = listView2->findItem(ip,0);
   if ( favitem != 0  )
   {
      comment = favitem->text(1);
      fav->removeItem( favitem );
      favitem = new QListViewItem( fav , ip );   
      fav->insertItem( favitem );
      favitem->setText(1, comment);
      favitem->setPixmap ( 0, QPixmap::fromMimeSource( "comp-on.png"  ) );
      
   }
   
   
   rangeItem = listView1->findItem( currentRange, 0 );
   
   
   if ( rangeItem != 0 )
   {
      rangeItem->setOpen(TRUE);
      QListViewItem *item =  rangeItem->firstChild();
      if ( item != 0 )
         while ( item !=0  )
         {
            if ( item->text(0) == ip ) break;   
            item = item->nextSibling();  
         }
      

      
      if ( item == 0 )
      {
         ipItem = new IpListViewItem( rangeItem , ip );
         rangeItem->insertItem( ipItem );
         ipItem->setPixmap ( 0, QPixmap::fromMimeSource( "apply.png"  ) );
         ipItem->setOpen(TRUE);
      } 
      else 
      {
         comment = item->text(1);
         rangeItem->removeItem( item );
         ipItem = new IpListViewItem( rangeItem , ip );
         rangeItem->insertItem( ipItem );
         ipItem->setText(1,comment);
         ipItem->setPixmap ( 0, QPixmap::fromMimeSource( "comp-on.png"  ) );
         ipItem->setOpen(FALSE);
      }
      ipItem->setOnline(TRUE);
      
      for (unsigned int i=0; i < shares.count(); i++)
      {
         shareItem = new QListViewItem( ipItem , shares[i] );   
         ipItem->insertItem( shareItem );         
         if ( shares[i] == "ftp://" ) shareItem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-ftp.png"  ) );
         else if ( shares[i] == "http://" ) shareItem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-http.png"  ) );  
         else shareItem->setPixmap ( 0, QPixmap::fromMimeSource( "folder.png"  ) );
         
         if ( favitem != 0  ) 
         {
            QListViewItem *fsItem = new QListViewItem(favitem, shares[i] );
            favitem->insertItem( fsItem );
            if ( shares[i] == "ftp://" ) fsItem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-ftp.png"  ) );
            else if ( shares[i] == "http://" ) fsItem->setPixmap ( 0, QPixmap::fromMimeSource( "folder-http.png"  ) );  
            else fsItem->setPixmap ( 0, QPixmap::fromMimeSource( "folder.png"  ) );
         }
      }
   }
   
}

void Form1::onFindShare( QString *ip, QStringList *shareslist )
{
   QString sh = shareslist->join(", ");
#ifdef QT_DEBUG
   qDebug(QString("=================> onFind ") + *ip + QString(" shres = ") + sh  );
#endif   
   HostsUp++;
   addIpShares( *ip , *shareslist ); 
}


void Form1::onScanIpNow( QString *ip )
{
   RangeDoneHosts = shscan.getDone();
   //qDebug(QString("  RangeDoneHosts = %1").arg(RangeDoneHosts) );
   progress->setProgress( RangeDoneHosts );
   
   statusBar()->message(QString(tr("range:  ")) + currentRange + QString(tr(" current ip:  ")) + *ip
                     + QString(tr(" online:  ")) + QString::number(HostsUp) );
   
}


void Form1::listView1_contextMenuRequested( QListViewItem *item, const QPoint &point, int )
{

   if ( item == 0 ) return;
   if ( item->depth() == 1  )
   {   
      menuIpList1->popup(point);
   }   
   if ( item->depth() == 0  )
   {   
      menuRangeList1->popup(point);
   }   
}

void Form1::listView2_contextMenuRequested( QListViewItem *item, const QPoint &point, int )
{
   if ( item == 0 ) return;
   if ( item->depth() == 1  )
   {   
      menuIpList2->popup(point);
   }      
}


void Form1::onMenuIpList1( int id )
{
   //qDebug( QString("ip= %1  selected= %2").arg( listView1->currentItem()->text(0) ).arg(id) );
   if ( id == ID_SCAN  )
   {
      ipList.clear();
      currentRange = listView1->currentItem()->parent()->text(0);
      ipList.append( listView1->currentItem()->text(0) );
      ipList.append( QString("") );
      
      
      buttonGroup1->setEnabled(FALSE);
      buttonGroup2->setEnabled(FALSE);
      fileOpenAction->setEnabled(FALSE);
      fileNewAction->setEnabled(FALSE);
      
      refreshAction->setEnabled(FALSE);
      stopRefreshAction->setEnabled(TRUE);
      
      spendTime.start();
      HostsUp = 0;   
      TotalHosts = 0;
      runScaning();
      
   }
   if ( id == ID_ADDFAVOR )
   {
      QListViewItem *mainitem = listView2->findItem(QString("favorites"),0);
      
      if ( mainitem == 0 )
      {
         
         mainitem = new QListViewItem( listView2, QString("favorites") );
         listView2->insertItem( mainitem  );
         mainitem->setPixmap ( 0, QPixmap::fromMimeSource( "many-comp.png"  ) );
         mainitem->setOpen(TRUE);
      }
      
      QListViewItem * item = listView1->currentItem();
      
      if ( listView2->findItem(item->text(0),0) == 0 ) 
      {
         mainitem->insertItem( item );
         item->setPixmap ( 0, QPixmap::fromMimeSource( "comp-off.png"  ) );
         item->setOpen(TRUE);
      }
      
   }
   if ( id == ID_COMMENT  )
   {
      bool ok;
      QString comment = listView1->currentItem()->text(1);
      QString text = QInputDialog::getText(
                                            CaptionName, tr("Enter comment:"), QLineEdit::Normal,
                                            comment, &ok, this );
      if ( ok ) {
         listView1->currentItem()->setText(1, text);
      } 
   }   
}


void Form1::onMenuRangeList1( int id )
{
   if ( id == ID_SCAN  )
   {
      ipList.clear();
      currentRange = listView1->currentItem()->text(0);
      
      ipRangeLister *ir = new ipRangeLister();
      ir->setRange( currentRange );            
      ipList = ir->getIpList();
      delete ir;
      
      buttonGroup1->setEnabled(FALSE);
      buttonGroup2->setEnabled(FALSE);
      fileOpenAction->setEnabled(FALSE);
      fileNewAction->setEnabled(FALSE);
      
      refreshAction->setEnabled(FALSE);
      stopRefreshAction->setEnabled(TRUE);
      
      spendTime.start();
      HostsUp = 0;   
      TotalHosts = 0;
      runScaning();
      
   }
   if ( id == ID_COMMENT  )
   {
      bool ok;
      QString comment = listView1->currentItem()->text(1);
      QString text = QInputDialog::getText(
                                            CaptionName, tr("Enter comment:"), QLineEdit::Normal,
                                            comment, &ok, this );
      if ( ok ) {
         listView1->currentItem()->setText(1, text);
      } 
   }   
}


void Form1::onMenuIpList2( int id )
{
   if ( id == ID_REMOVE  )
   {
      QListViewItem * parentItem = listView2->currentItem()->parent();
      parentItem->removeItem( listView2->currentItem() );
   }
   if ( id == ID_COMMENT  )
   {
      bool ok;
      QString comment = listView2->currentItem()->text(1);
      QString text = QInputDialog::getText(
                                            CaptionName, tr("Enter comment:"), QLineEdit::Normal,
                                            comment, &ok, this );
      if ( ok ) {
         listView2->currentItem()->setText(1, text);
      } 
   }   
}

void Form1::editConfig_activated()
{
   confdlg->checkBoxFtp->setChecked(ftp_use_user_cmd);
   confdlg->checkBoxHttp->setChecked(http_use_user_cmd);
   confdlg->checkBoxSmb->setChecked(smb_use_user_cmd);

   confdlg->lineEditFtp->setText(ftp_user_cmd);
   confdlg->lineEditHttp->setText(http_user_cmd);
   confdlg->lineEditSmb->setText(smb_user_cmd);
   
   if ( confdlg->exec() == QDialog::Accepted )
   {
      ftp_use_user_cmd = confdlg->checkBoxFtp->isChecked();
      http_use_user_cmd = confdlg->checkBoxHttp->isChecked();
      smb_use_user_cmd = confdlg->checkBoxSmb->isChecked();
      
      ftp_user_cmd = confdlg->lineEditFtp->text();
      http_user_cmd = confdlg->lineEditHttp->text();
      smb_user_cmd = confdlg->lineEditSmb->text();
   }

}

void Form1::showOnOnly_activated()
{
   QListViewItem *range;
   IpListViewItem *ip;
   
   range = listView1->firstChild();
   if ( showOnOnly->isOn() )
   {
      if ( range != 0 )
	 while ( range !=0  )
	 {
	    ip = (IpListViewItem *)range->firstChild();
	    if ( ip != 0 )
	       while ( ip !=0  )
	       {
		  if ( ! ip->isOnline() ) ip->setVisible(FALSE);
		  ip = (IpListViewItem *)ip->nextSibling();
	       }
	    range = range->nextSibling();
	 }
   }
   else
   {
      if ( range != 0 )
         while ( range !=0  )
         {
            ip = (IpListViewItem *)range->firstChild();
            if ( ip != 0 )
               while ( ip !=0  )
               {
                  ip->setVisible(TRUE);
                  ip = (IpListViewItem *)ip->nextSibling();
               }
            range = range->nextSibling();
         }
      
   }
}








































