/*
Copyright (C) 2005  Oleg Grigoriev

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef SHARESCANNER_H
#define SHARESCANNER_H

#include <qtimer.h> 
#include <qcstring.h>
#include <qstringlist.h> 
#include <qprocess.h>
#include <qptrlist.h>

#include <qdatetime.h>
#include <qapplication.h> 
#include <iostream>

#include <stdio.h>     
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/poll.h>

#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define CMD "lrpcscanip $I"
#define FTP_PORT  21
#define HTTP_PORT  80
#define SMB_PORT  139

#include <qthread.h>

class ScanThread : public QThread 
{   
public:
   ScanThread()
   {
      connect_timeoutNow = 5000;
      timeoutNow = 25000;
      sFtp = TRUE;
      sHttp = TRUE;
   };
   ~ScanThread()
   {
   };
   
   virtual void run();
   void stopIt();
   void setParam( QString ip, int timeout, int connect_to, bool scnFtp, bool scnHttp  );
   QString get_ip() const { return ipName; };
   QStringList get_shares() const { return shares; };
   
   
private:

   QStringList shares;
   QString ipName;
   int timeoutNow;
   int connect_timeoutNow;
   bool sFtp;
   bool sHttp;   
};



typedef QPtrList<ScanThread> ScanThreadList;


class ShareScanner : public QObject
{
   Q_OBJECT
public:
      ShareScanner()
      {
         connect( &timer, SIGNAL( timeout() ),  SLOT( timerDone() ) );
      };
      void scan( QStringList *ipList, int numthreads, int chk_time, int global_chk_time, int connect_timeout, bool sFtp, bool sHttp  );
      void stopScan();
      int getDone() const { return  scanIndex; };
private:
   unsigned int scanIndex;
   QTimer timer;
   ScanThreadList threads;
   QStringList *scanIpList;
   int treadTimeout;
   int tconnectTimeout;
   int cycleTime;
   bool scnFtp;
   bool scnHttp;
   void scanCycle();
   
signals:
   void scanDone();
   void findShare( QString * , QStringList * );
   void scanNowIp( QString * );
private slots:   
   void timerDone();
      
};

#endif // SHARESCANNER_H

