#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/silcd.conf.new
config etc/silcalgs.conf.new
( cd usr/lib ; rm -rf libsilc-1.0.so.2 )
( cd usr/lib ; ln -sf libsilc-1.0.so.2.4.1 libsilc-1.0.so.2 )
( cd usr/lib ; rm -rf libsilc.so )
( cd usr/lib ; ln -sf libsilc-1.0.so.2.4.1 libsilc.so )
( cd usr/lib ; rm -rf libsilcclient-1.0.so.1 )
( cd usr/lib ; ln -sf libsilcclient-1.0.so.1.3.2 libsilcclient-1.0.so.1 )
( cd usr/lib ; rm -rf libsilcclient.so )
( cd usr/lib ; ln -sf libsilcclient-1.0.so.1.3.2 libsilcclient.so )
