/***************************************************************************
** $Id: configdialog.cpp,v 1.26 2006/10/23 19:18:25 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//Adapted from configdialog.cpp in amaroK:
/***************************************************************************
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configdialog.h"
#include "konqueror.h"
#include "firewallsproxies.h"
#include "maxmin.h"
#include "running.h"
#include "torservers.h"
#include "usability.h"
#include "torkconfig.h"
#include "server.h"
#include "quickconfig.h"
#include "hiddensrvs.h"
#include "portsandnames.h"
#include "tork.h"
#include "crypto.h"

#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qobjectlist.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtextcodec.h>
#include <qtooltip.h>
#include <qvbox.h>
#include <qlistview.h>
#include <qcheckbox.h>

#include <kapplication.h> //kapp
#include <kcombobox.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <dcopref.h>
#include <kconfig.h>
#include <kmessagebox.h>

//////////////////////////////////////////////////////////////////////////////////////////
// PUBLIC
//////////////////////////////////////////////////////////////////////////////////////////

TorkConfigDialog::TorkConfigDialog( QWidget *parent, const char* name, KConfigSkeleton *config )
        : KConfigDialog( parent, name, config )
{
    setWFlags( WDestructiveClose );

    // IMPORTANT Don't simply change the page names, they are used as identifiers in other parts of the app.
        m_firewallsproxies = new FirewallsProxies( 0, "Firewalls Proxies" );
        m_usability = new Usability( 0, "Usability" );
        m_torservers = new TorServers( 0, "My Network View" );
	    m_maxmin = new MaxMin( 0, "My Bandwidth" );
	    m_running = new Running( 0, "My Client" );
        m_myserver = new MyServer( 0, "My Server" );
        m_myhidden = new MyHidden( 0, "My Hidden" );
        m_quickconfig = new QuickConfig( 0, "Quick Configure" );
        m_konq = new Konq( 0, "Konqueror" );

    // add pages
    addPage( m_quickconfig, i18n( "Quick Configure" ), "cache", i18n( "Quick Configuration" ) );
    addPage( m_konq, i18n( "Konqueror" ), "konqueror", i18n( "Konqueror and Privacy Proxy" ) );
    addPage( m_running, i18n( "My Client" ), "launch", i18n( "Configure My Client" ) );
    addPage( m_usability,   i18n( "Usability" ), "idea", i18n( "Configure Usability" ) );
    addPage( m_myserver, i18n( "My Server" ), "system", i18n( "COnfigure My Server" ) );
    addPage( m_firewallsproxies, i18n( "Firewalls Proxies" ), "proxy", i18n( "Configure Firewalls Proxies" ) );
    addPage( m_torservers, i18n( "My Network View" ), "network", i18n( "Configure My Network View" ) );
    addPage( m_maxmin, i18n( "My Bandwidth" ), "filter", i18n( "Configure My Bandwidth" ) );
    addPage( m_myhidden, i18n( "My Hidden Services" ), "agent", i18n( "Configure My Hidden Services" ) );

    QObjectList *list = queryList( "QLabel", "infoPixmap" );
    for( QObject *label = list->first(); label; label = list->next() )
        static_cast<QLabel*>(label)->setPixmap( QMessageBox::standardIcon( QMessageBox::Information ) );
    delete list;

    //stop KFont Requesters getting stupidly large
    list = queryList( "QLabel", "m_sampleLabel" );
    for( QObject *label = list->first(); label; label = list->next() )
        static_cast<QLabel*>(label)->setMaximumWidth( 250 );
    delete list;

    connect( m_usability->LongLivedPorts, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_torservers->ExitNodes, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_torservers->ExcludeNodes, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_torservers->MapAddress, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_torservers->AllowUnverifiedNodes, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_firewallsproxies->ReachableAddresses, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_running->SOCKSPolicy, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_running->SOCKSBindAddressMany, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_running->PushAdd, SIGNAL( clicked() ), this, SLOT( enableApply() ) );
    connect( m_running->PushAdd2, SIGNAL( clicked() ), this, SLOT( enableApply() ) );
    connect( m_running->kcfg_ClientOnly, SIGNAL( toggled(bool) ), this, SLOT( showServerOpts(bool) ) );
    connect( m_usability->TrackHostExits, SIGNAL( selectionChanged() ), this, SLOT( enableApply() ) );
    connect( m_usability->PushAdd, SIGNAL( clicked() ), this, SLOT( enableApply() ) );

    connect( m_quickconfig, SIGNAL( configChanged(const int &) ), this, SLOT( showHidePages(const int &) ) );
    //connect( m_usability, SIGNAL(settingsChanged()), SLOT(updateButtons()) ); 

    showHidePages(m_quickconfig->QuickConfigure->currentItem());

}

void TorkConfigDialog::showHidePages( const int &type )
{
    kdDebug() << type << endl;
    switch (type) {
            case 0 : //Tor client and server with default settings
            case 1 : //Tor client and relay server with default settings
            case 2 : //Tor client and relay server with default settings
            case 3 : //Tor client and relay server with default settings
            case 4 : //Tor client and relay server with default settings
/*               m_running->setEnabled(false); 
               m_usability->setEnabled(false); 
               m_torservers->setEnabled(false); 
               m_maxmin->setEnabled(false); 
               m_firewallsproxies->setEnabled(true); 
               m_myserver->setEnabled(false); 
               break;*/
            case 5 : //Use custom settings
               m_running->setEnabled(true); 
               m_usability->setEnabled(true); 
               m_torservers->setEnabled(true); 
               m_maxmin->setEnabled(true); 
               m_firewallsproxies->setEnabled(true); 
               m_myserver->setEnabled(true); 

                break;
    }

    m_myserver->setEnabled(!TorkConfig::clientOnly());
    show();

}

TorkConfigDialog::~TorkConfigDialog()
{
}

void TorkConfigDialog::showServerOpts( bool state)
{
    m_myserver->setEnabled(!state);
}


/** Show page by object name */
void TorkConfigDialog::showPage( const QCString& page )
{
    for( uint index = 0; index < m_pageList.count(); index++ ) {
        if ( m_pageList[index]->name() == page ) {
            KConfigDialog::showPage( index );
            return;
        }
    }
}

/** Reimplemented from KConfigDialog */
void TorkConfigDialog::addPage( QWidget *page, const QString &itemName, const QString &pixmapName, const QString &header, bool manage )
{
    // Add the widget pointer to our list, for later reference
    m_pageList << page;

    KConfigDialog::addPage( page, itemName, pixmapName, header, manage );
}


void TorkConfigDialog::enableApply()
{
    enableButtonApply(true);
}

void TorkConfigDialog::updateSettings()
{

    //QListViews need to be handled outside of kconfigxt
    TorkConfig::setQuickConfigure( m_quickconfig->QuickConfigure->currentItem() );

    TorkConfig::setAccountingStart(m_myserver->AccountingStart->currentText());
//     TorkConfig::setStatusFetchPeriodUnit(m_torservers->StatusFetchPeriodUnit->currentText());
//     TorkConfig::setDirFetchPeriodUnit(m_torservers->DirFetchPeriodUnit->currentText());

    kdDebug() << "in update settings" << endl;
    //Unverified Servers
    if ( m_torservers->AllowUnverifiedNodes->childCount() > 0 ) {
        QStringList v_allowUnverifiedNodes;
        QListViewItemIterator it( m_torservers->AllowUnverifiedNodes, QListViewItemIterator::Selected );
        while ( it.current() ) {
            v_allowUnverifiedNodes.append(it.current()->text(0));
	        ++it;
        }
        TorkConfig::setAllowUnverifiedNodes( v_allowUnverifiedNodes );
    }

    //Friendly Servers
    if ( m_torservers->MapAddress->childCount() > 0 ) {
        QStringList v_mapAddress;
        QListViewItemIterator it( m_torservers->MapAddress );
        while ( it.current() ) {
            QString s_mapAddress = it.current()->text(0) + " " + it.current()->text(0) + "." +
                it.current()->text(1) + "." + it.current()->text(2);
            v_mapAddress.append(s_mapAddress);
	        ++it;
        }
        TorkConfig::setMapAddress( v_mapAddress );
        //kdDebug() << v_mapAddress << endl;
    }else
        TorkConfig::setMapAddress( "" );

    //Enemy Servers
    if ( m_torservers->ExcludeNodes->childCount() > 0 ) {
        QStringList v_excludeNodes;
        QListViewItemIterator it( m_torservers->ExcludeNodes, QListViewItemIterator::Selected );
        while ( it.current() ) {
            v_excludeNodes.append("$"+getFPFromFPDigest(it.current()->text(1)));
	        ++it;
        }
        TorkConfig::setExcludeNodes( v_excludeNodes );
    }


    //Exit Servers
    if ( m_torservers->ExitNodes->childCount() > 0 ) {
        QStringList v_exitNodes;
        QListViewItemIterator it( m_torservers->ExitNodes, QListViewItemIterator::Selected );
        while ( it.current() ) {
            v_exitNodes.append("$"+getFPFromFPDigest(it.current()->text(1)));
	        ++it;
        }
        TorkConfig::setExitNodes( v_exitNodes );
    }

    //Family Servers
    if ( m_myserver->MyFamily->childCount() > 0 ) {
        QStringList v_myFamily;
        QListViewItemIterator it( m_myserver->MyFamily, QListViewItemIterator::Selected );
        while ( it.current() ) {
            v_myFamily.append(it.current()->text(0));
	        ++it;
        }
        TorkConfig::setMyFamily( v_myFamily );
    }

    //Track Host Exits
    if ( m_usability->TrackHostExits->childCount() > 0 ) {
        QStringList v_trackHostExits;
        QListViewItemIterator it( m_usability->TrackHostExits );
        while ( it.current() ) {
            v_trackHostExits.append(it.current()->text(0));
	        ++it;
        }
        TorkConfig::setTrackHostExits( v_trackHostExits );
    }else
        TorkConfig::setTrackHostExits( "" );

    //Long Lived Ports
    if ( m_usability->LongLivedPorts->childCount() > 0 ) {
        QStringList v_longLivedPorts;
        QListViewItemIterator it( m_usability->LongLivedPorts, QListViewItemIterator::Selected );
        while ( it.current() ) {
            int i;
            for (i = 0; _port_name[i].port; ++i) {
                portsandnames_t *pics = &_port_name[i];
                if (it.current()->text(0) == pics->name){
                    v_longLivedPorts.append(pics->port);
                }
            }

	        ++it;
        }
        TorkConfig::setLongLivedPorts( v_longLivedPorts );
    }

    //Socks Bind Addresses
    if ( m_running->SOCKSBindAddressMany->childCount() > 0 ) {
        QStringList v_sOCKSBindAddressMany;
        QListViewItemIterator it( m_running->SOCKSBindAddressMany );
        while ( it.current() ) {
            QString s_sOCKSBindAddressMany = it.current()->text(0) + ":" + it.current()->text(1);
            v_sOCKSBindAddressMany.append(s_sOCKSBindAddressMany);
	        ++it;
        }
        TorkConfig::setSOCKSBindAddressMany( v_sOCKSBindAddressMany );
    }else
        TorkConfig::setSOCKSBindAddressMany( "" );

    //Exit Policy
    if ( m_myserver->ExitPolicy->childCount() > 0 ) {
        QStringList v_exitPolicy;
        QListViewItemIterator it( m_myserver->ExitPolicy );
        while ( it.current() ) {
            QString s_exitPolicy = it.current()->text(0) + " " + it.current()->text(1) + ":" + it.current()->text(2);
            v_exitPolicy.append(s_exitPolicy);
	        ++it;
        }
        TorkConfig::setExitPolicy( v_exitPolicy );
    }else
        TorkConfig::setExitPolicy( "" );

    //Socks Policy
    if ( m_running->SOCKSPolicy->childCount() > 0 ) {
        QStringList v_sOCKSPolicy;
        QListViewItemIterator it( m_running->SOCKSPolicy );
        while ( it.current() ) {
            QString s_sOCKSPolicy = it.current()->text(0) + " " + it.current()->text(1) + ":" + it.current()->text(2);
            v_sOCKSPolicy.append(s_sOCKSPolicy);
	        ++it;
        }
        TorkConfig::setSOCKSPolicy( v_sOCKSPolicy );
    }else
        TorkConfig::setSOCKSPolicy( "" );

    //Reachable Address
    if ( m_firewallsproxies->ReachableAddresses->childCount() > 0 ) {
        QStringList v_reachableAddresses;
        QListViewItemIterator it( m_firewallsproxies->ReachableAddresses );
        while ( it.current() ) {
            QString s_reachableAddresses = it.current()->text(0) + ":" + it.current()->text(1);
            v_reachableAddresses.append(s_reachableAddresses);
	        ++it;
        }
        TorkConfig::setReachableAddresses( v_reachableAddresses );
    }else
        TorkConfig::setReachableAddresses( "" );

    //Reachable Address
    if ( m_myhidden->servicesList->childCount() > 0 ) {
        QStringList v_hiddenServices;
        QListViewItemIterator it( m_myhidden->servicesList );
        while ( it.current() ) {
            QString s_hiddenServices = it.current()->text(0) + "\n" + it.current()->text(1)
                                        + "\n" + it.current()->text(2) + "\n" + it.current()->text(3)
                                        + "\n" + it.current()->text(4)+ "\n" + it.current()->text(5);
            v_hiddenServices.append(s_hiddenServices);
	        ++it;
        }
        TorkConfig::setHiddenServices( v_hiddenServices );
    }else
        TorkConfig::setHiddenServices( "" );

    if ((m_quickconfig->kcfg_KDEUsesTor->isChecked()) != (TorkConfig::kDEUsesTor()))
        configureKonqi();
    emit settingsChanged();
    TorkConfig::writeConfig();

}

void
TorkConfigDialog::configureKonqi()
{
        kdDebug() << "updating konq" << endl;
        KConfig* config = new KConfig("kioslaverc", false, false);
        config->setGroup( "Proxy Settings" );
        if (m_quickconfig->kcfg_KDEUsesTor->isChecked()){
            config->writeEntry( "ftpProxy", "http://localhost:8118" );
            config->writeEntry( "httpProxy", "http://localhost:8118" );
            config->writeEntry( "httpsProxy", "http://localhost:8118" );
            config->writeEntry( "ProxyType", "1" );
        }else
            config->writeEntry( "ProxyType", "0" );

        config->sync();

        // Inform all running io-slaves about the changes...
        // if we cannot update, ioslaves inform the end user...
        if (!DCOPRef("*", "KIO::Scheduler").send("reparseSlaveConfiguration", QString::null))
        {
            QString caption = i18n("Update Failed");
            QString message = i18n("You have to restart the running applications "
                                "for these changes to take effect.");
            KMessageBox::information (this, message, caption);
            return;
        }
}




#include "configdialog.moc"
