/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include "torkconfig.h"
#include <klocale.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kdebug.h>

void FirewallsProxies::init()
{

    QStringList existingMaps = TorkConfig::reachableAddresses();
    QListViewItem *tm;
	for ( QStringList::Iterator it = existingMaps.begin(); it != existingMaps.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString entry = (*it).section(":",0,0);
        QString port = (*it).section(":",1,1);

        tm = new QListViewItem(ReachableAddresses,entry,port);
    }

    if (ReachableAddresses->childCount() == 0){
        textLabel1->setEnabled(FALSE);
        kcfg_KeepalivePeriod->setEnabled(FALSE);
    }
}
void FirewallsProxies::pushAdd_clicked()
{
    kdDebug() << "adding entry" << endl;
    new QListViewItem(ReachableAddresses,Address->text(), Port->text());
    textLabel1->setEnabled(TRUE);
    kcfg_KeepalivePeriod->setEnabled(TRUE);

}



void FirewallsProxies::ReachableAddresses_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( ReachableAddresses );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void FirewallsProxies::slotDeleteEntry( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(ReachableAddresses, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (ReachableAddresses->isSelected( it.current()))
            delete it.current();
        ++it;
    }

    if (ReachableAddresses->childCount() == 0){
        textLabel1->setEnabled(FALSE);
        kcfg_KeepalivePeriod->setEnabled(FALSE);
    }


}

// <connections>
//     <connection>
//         <sender>pushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>FirewallsProxies</receiver>
//         <slot>pushAdd_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>ReachableAddresses</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>FirewallsProxies</receiver>
//         <slot>ReachableAddresses_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">firewallsproxies.ui.h</include>
// </includes>
// <slots>
//     <slot>pushAdd_clicked()</slot>
//     <slot>ReachableAddresses_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>
