/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include "torkconfig.h"
#include "update.h"
#include "crypto.h"
#include <kapplication.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <stdlib.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include <kprocio.h>
#include <kdebug.h>
#include <stdlib.h>
#include <dcopref.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <klocale.h>


KProcIO *whichproc;


void
FirstRunWizard::init()
{

    TorkConfig::setUser(getenv("USER"));

    serverName->setText((QString("%1").arg(crypto_rand_int(99999))));
    
    //kdDebug() << QString("%1").arg(1+(int) (32767.0*rand()/(RAND_MAX+1.0))) << endl;

    //TorkConfig::setORPort((9090 + crypto_rand_int(900)));

    //aesthetics
    cancelButton()->setFixedSize( cancelButton()->sizeHint() );
    helpButton()->hide();

    preview->setPixmap( QPixmap(locate("data", "tork/about/oval_sticker2.png")) );
    preview_2->setPixmap( QPixmap(locate("data", "tork/about/download_tor.png")) );


//     picture1->setPixmap( getJPG( "amarok_rocks" ) );
//     picture4->setPixmap( *picture1->pixmap() );

    //ClamBanner->setText(QString("<a href=\"http://ads.clamav.net/adclick.php?n=a9141dd1\" target=\"_blank\"><img src=\"%1\" border=\"0\" alt=\"ClamAV banner\" /></a>").arg(locate("data", "klamav/about/tshirt.png")));


    setFinishEnabled ( WizardPage_3,true );

 	whichproc = new KProcIO();
	QString curpath = (QString) getenv("PATH");
	whichproc->setEnvironment("PATH",curpath + ":/usr/local/sbin:/usr/sbin:/sbin:/usr/local/bin:/usr/bin:/bin");
	whichproc->setUseShell(TRUE);

	QString whichCommand="which tor;which privoxy";

	*whichproc<<whichCommand;

	connect( whichproc, SIGNAL(readReady(KProcIO * )),
		SLOT(processWhich(KProcIO * )) );
	whichproc->start(KProcIO::NotifyOnExit,TRUE);


}

void FirstRunWizard::processWhich(KProcIO *whichproc)
{
	QString item = "";
	int pos;

	while ((pos = (whichproc->readln(item,true))) != -1) {
        kdDebug() << item << endl;
		if (item.find("/tor") != -1)
            TorLocation->setURL(item);
        else if (item.find("/privoxy") != -1)
            PrivoxyLocation->setURL(item);
	}
	whichproc->ackRead();

}

void
FirstRunWizard::showPage( QWidget *w ) //virtual
{
    QWizard::showPage( w );


//     if (currentPage() == "3")
//         setFinishEnabled ( WizardPage_3,true );

    cancelButton()->setText( w == WizardPage_0 ? i18n("&Skip") : i18n("&Cancel") );
}



void FirstRunWizard::downloadPrivoxy_clicked()
{
    TorkUpdate* updater = new TorkUpdate(this,true);
    updater->checkForNewPrivoxyDirectly();

}


void FirstRunWizard::downloadTor_clicked()
{

    TorkUpdate* updater = new TorkUpdate(this,true);
    updater->checkForNewTorDirectly();

}

void
FirstRunWizard::accept()
{

    if (kcfg_KDEUsesTor->isChecked())
        TorkConfig::setKDEUsesTor(true);

    TorkConfig::setQuickConfigure(WizardQuickConfigure->currentItem());
    TorkConfig::setTorLocation(TorLocation->url());
    TorkConfig::setPrivoxyLocation(PrivoxyLocation->url());
    TorkConfig::setNickName(serverName->text());
    TorkConfig::setContactInfo(contactMail->text());
    TorkConfig::setRemoteTorAddress(RemoteTorAddress->text());
    TorkConfig::setRemoteTorPort(RemoteTorPort->text().toInt());

    TorkConfig::writeConfig();
    QDialog::accept();
}
void
FirstRunWizard::reject()
{
    QDialog::reject();
}

void FirstRunWizard::WizardQuickConfigure_activated( int item)
{
    kdDebug() << "activated" << endl;
    RemoteTorAddress->setEnabled(false);

    if (item >= 6){
        if (WizardQuickConfigure->currentItem() == 6)
            RemoteTorAddress->setEnabled(true);
        RemoteTorPort->setEnabled(true);
    }else{
        RemoteTorPort->setEnabled(false);
    }
}
