/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include "tork.h"
#include <qtimer.h>

bool local;

void HidSrvWizard::init()
{
    local=false;
    setAppropriate ( LocalWebService, false );
    setAppropriate ( LocalWebServiceFiles, false );
    setAppropriate ( ServiceName, true );
    setAppropriate ( RedirectService, true );

}
void HidSrvWizard::localWeb_toggled( bool state)
{

    setAppropriate ( LocalWebService, state );
    setAppropriate ( LocalWebServiceFiles, state );
    setAppropriate ( RedirectService, !state );
    local = state;
}


void HidSrvWizard::downloadThttpd_clicked()
{
    TorkUpdate* updater = new TorkUpdate(this,false);
    updater->downloadThttpd();

}


void
HidSrvWizard::showPage( QWidget *w ) //virtual
{
    QWizard::showPage( w );


    if (currentPage() == this->GatherDetails){
        if (local)
            emit createService(QString("%1/.tork/%2/").arg(getenv("HOME")).arg(Nick->text()), QString("%1 localhost:%2").arg(WebPort->text()).arg(localWebPort->text()));
        else
            emit createService(QString("%1/.tork/%2/").arg(getenv("HOME")).arg(Nick->text()), QString("%1 %2:%3").arg(NonWebPort->text()).arg(RedirectAddress->text()).arg(RedirectPort->text()));
        GatheringDetailsText->setText("Please wait while Tor attempts to create the service.");
        QTimer::singleShot( 3000, this, SLOT(checkServiceDetails()) );
        finishButton()->setEnabled(false);
    }

}

void
HidSrvWizard::checkServiceDetails()
{

    QString hostname;
    QFile inf(QString("%1/.tork/%2/hostname").arg(getenv("HOME")).arg(Nick->text()));
    if ( inf.open(IO_ReadOnly) ) {
        inf.readLine(hostname,50);
        inf.close();
    }else{
        GatheringDetailsText->setText("Failed. Click Back and Next to try again.");
        return;
    }

    hostname.replace("\n","");

    cancelButton()->setEnabled(false);

    QString serviceDetails = "Hidden Service Hostname: ";
    serviceDetails += hostname;
    serviceDetails += "<br>";
    if (local){
        serviceDetails += "Serving files in:";
        serviceDetails += FilesToServe->url();
        serviceDetails += "<br>";
        serviceDetails += "Public Facing Port:"; 
        serviceDetails += WebPort->text();
        serviceDetails += "<br>";
        serviceDetails += "Tor Facing Port:"; 
        serviceDetails += localWebPort->text();
        emit addService(Nick->text(),WebPort->text(),QString("localhost:%1").arg(localWebPort->text()),hostname,FilesToServe->url(),QString("%1/.tork/%2/").arg(getenv("HOME")).arg(Nick->text()));

    }else{
        serviceDetails += "Redirecting to:";
        serviceDetails += RedirectAddress->text();
        serviceDetails += "<br>";
        serviceDetails += "On Port:";
        serviceDetails  += RedirectPort->text();
        serviceDetails += "<br>";
        serviceDetails += "Serving Tor Network with Port:";
        serviceDetails  += NonWebPort->text();
        serviceDetails += "<br>";
        emit addService(Nick->text(),NonWebPort->text(),QString("%1:%2").arg(RedirectAddress->text()).arg(RedirectPort->text()),hostname,"",QString("%1/.tork/%2/").arg(getenv("HOME")).arg(Nick->text()));

    }


    GatheringDetailsText->setText(serviceDetails);
    finishButton()->setEnabled(true);

}

void
HidSrvWizard::accept()
{
    QDialog::accept();
}

void
HidSrvWizard::reject()
{
    QDialog::reject();
}


