/***************************************************************************
** $Id: main.cpp,v 1.17 2006/10/23 19:19:31 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "tork.h"
#include "crashhandler.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfigdialogmanager.h>

static const char description[] =
    I18N_NOOP("TorK - A Controller for the Tor Onion Router");

static const char version[] = "0.10-alpha";
static const char title[] = "TorK 0.10-alpha";

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("tork", I18N_NOOP(title), version, description,
    KAboutData::License_GPL, "(C) 2006 Robert Hogan", 0, 0, "tork-users@lists.sf.net");
    about.addAuthor( "Robert Hogan - Author and Maintainer", 0, "robert@roberthogan.net" );
    about.addAuthor( "Corinna Habets - Icons", 0, "" );
    about.addAuthor( "Contains code by: Matt Edman, Justin Hipple, Max Howell,", 0, "" );
    about.addAuthor( "                  Trolltech AS, Roger Dingledine, Nick Mathewson, ", 0, "" );
    about.addAuthor( "                  Sebastien Trueg, Joris Guisson,  Markus Gustavsson, ", 0, "" );
    about.addAuthor( "                  Diego Petena, Ben Burton, David Sansome ", 0, "" );
    about.addCredit("Maxmind", I18N_NOOP("Country locator. Flags are taken from http://flags.blogpotato.de/ so thanks to them too."), "http://www.maxmind.com/");

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;


    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(tork);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            tork *widget = new tork;
            widget->show();

        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                tork *widget = new tork;
                widget->show();

            }
        }
        args->clear();
    }

    KCrash::setCrashHandler( torK::Crash::crashHandler );

    return app.exec();
}

