/* 
 *
 * $Id: newstreamosd.cpp,v 1.9 2006/10/24 19:14:23 hoganrobert Exp $
 * Copyright (C) 2005 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2005 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 *
 * Some minor changes for TorK:
 *   Copyright (C) 2006 by Robert Hogan                                    *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 */

#include "newstreamosd.h"


#include <kwin.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <kcursor.h>
#include <kconfig.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <qlistview.h>
#include <qlayout.h>
#include <qheader.h>

#include <qpixmap.h>
#include <qpainter.h>
#include <qapplication.h>
#include <qframe.h>
#include <qtoolbutton.h>

#include <X11/Xlib.h>
#include <qtooltip.h> //QToolTip::palette()


StreamOSD::StreamOSD( QWidget* parent, const char* name )
  : QWidget( parent, name, WType_TopLevel | WNoAutoErase | WStyle_Customize | WX11BypassWM | WStyle_StaysOnTop ),
    m_dirty(true),
    m_dragging(false),
    m_screen(0),
    m_position(s_outerMargin, s_outerMargin)
{
  setFocusPolicy( NoFocus );
  setBackgroundMode( NoBackground );
  // dummy size
  resize( 250, 125 );

  // make sure we are always visible
  KWin::setOnAllDesktops( winId(), true );
  renderOSD();

}


StreamOSD::~StreamOSD()
{
}




void StreamOSD::setText( const QString& text )
{
  if( m_text != text ) {
    m_text = text;
    refresh();
  }
}


void StreamOSD::setProgress( int p )
{

  if( m_progress != p ) {
    m_progress = p;
    refresh();
  }
}


void StreamOSD::setPosition( const QPoint& p )
{
  m_position = p;
  reposition();
}


void StreamOSD::refresh()
{
  if( isVisible() )
    renderOSD();
  else
    m_dirty = true;
}


void StreamOSD::renderOSD()
{
  // ----------------------------------------
  // |        Copying CD                    |
  // |  K3B   ========== 40%                |
  // |                                      |
  // ----------------------------------------

/*    QFrame* frame = new QFrame(this);
    frame->setFrameStyle( QFrame::Panel | QFrame::Raised );
    frame->setFrameShape( QFrame::StyledPanel );*/
    //6 10
    //8 10
    kdDebug() << fontMetrics().width( 'x' ) << endl;
    kdDebug() << font().pointSize() << endl;
    QFont f( font().rawName(), 8 );
    setFont( f );
    setWFlags( Qt::WX11BypassWM );
    setPalette(QToolTip::palette());
    setPaletteBackgroundColor(Qt::white);
    setBackgroundMode( PaletteBase );
    QGridLayout* TabPageLayout = new QGridLayout( this, 3, 4, 11, 6, "TabPageLayout"); 
    TabPageLayout->setMargin(2);
    QLabel* textLabel = new QLabel( this, "textLabel2" );
    textLabel->setText(i18n("<b>Tor Traffic</b>"));
    QFont f2( font().rawName(), 9    );
    textLabel->setFont( f2 );

    TabPageLayout->addMultiCellWidget( textLabel, 0,0,0,2 );

//     QToolButton* toggleKDE = new QToolButton( this,"konq" );
//     toggleKDE->setIconSet( SmallIconSet( "tork_konqueroroff" ) );
//     toggleKDE->setUsesTextLabel(false);
//     toggleKDE->setMaximumSize(SmallIconSet( "tork_konqueroroff" ).iconSize(QIconSet::Small));
//     toggleKDE->adjustSize();
//     TabPageLayout->addWidget(toggleKDE,0,2);

    QToolButton* hideMonitor = new QToolButton( this,"hide" );
    hideMonitor->setIconSet( SmallIconSet( "cancel" ) );
    hideMonitor->setTextLabel(i18n( "Hide" ));
    hideMonitor->setTextPosition(QToolButton::Right);
    hideMonitor->setUsesTextLabel(true);
    hideMonitor->adjustSize();
    TabPageLayout->addWidget(hideMonitor,0,3);

     connect( hideMonitor, SIGNAL(clicked()),
         SLOT(slotHideMonitor()) );
//      connect( toggleKDE, SIGNAL(clicked()),
//          SLOT(slotToggleKDE()) );


    infoList = new QListView( this, "infoList" );
    infoList->addColumn(  "StreamID"  );
    infoList->addColumn(  "Host"  );
    infoList->addColumn(  "Status"  );
    infoList->addColumn(  "Exit"  );
    infoList->setColumnWidthMode(0, QListView::Manual);
    infoList->hideColumn(0);
    infoList->header()->setResizeEnabled(FALSE, 0);
    infoList->setResizeMode( QListView::NoColumn );
    infoList->setHScrollBarMode(QScrollView::AlwaysOff);
    infoList->setSelectionMode( QListView::Single );
    TabPageLayout->addMultiCellWidget( infoList, 1,1,0,3 );

	m_graphOut = new StatGraph(this,1,0,"Up");
	m_graphIn = new StatGraph(this,1,0,"Down");

    TabPageLayout->addMultiCellWidget( m_graphOut, 2,2, 0,1 );
    TabPageLayout->addMultiCellWidget( m_graphIn, 2, 2, 2,3 );

    //infoList->adjustSize();
    //frame->update();
     connect( infoList, SIGNAL( contextMenuRequested(QListViewItem*,const QPoint&,int) ), this, SLOT( contextMenuRequested(QListViewItem*,const QPoint&,int) ) );


}


void StreamOSD::setScreen( int screen )
{
  const int n = QApplication::desktop()->numScreens();
  m_screen = (screen >= n) ? n-1 : screen;
  reposition();
}


void StreamOSD::reposition( QSize newSize )
{
  if( !newSize.isValid() )
    newSize = size();

  QPoint newPos = m_position;
  const QRect& screen = QApplication::desktop()->screenGeometry( m_screen );

  // now to properly resize if put into one of the corners we interpret the position
  // depending on the quadrant
  int midH = screen.width()/2;
  int midV = screen.height()/2;
  if( newPos.x() > midH )
    newPos.rx() -= newSize.width();
  if( newPos.y() > midV )
    newPos.ry() -= newSize.height();

  newPos = fixupPosition( newPos );
 
  // correct for screen position
  newPos += screen.topLeft();
  
  // ensure we are painted before we move
  if( isVisible() )
    paintEvent( 0 );

  // fancy X11 move+resize, reduces visual artifacts
  XMoveResizeWindow( x11Display(), winId(), newPos.x(), newPos.y(), newSize.width(), newSize.height() );
}


void StreamOSD::paintEvent( QPaintEvent* )
{
  bitBlt( this, 0, 0, &m_osdBuffer );
}


void StreamOSD::mousePressEvent( QMouseEvent* e )
{
  m_dragOffset = e->pos();

  if( e->button() == LeftButton && !m_dragging ) {
    grabMouse( KCursor::sizeAllCursor() );
    m_dragging = true;
  }
/*  else if( e->button() == RightButton ) {
    KPopupMenu m;
    if( m.insertItem( i18n("Hide OSD") ) == m.exec( e->pos() ) )
      hide();
  }*/
}


void StreamOSD::mouseReleaseEvent( QMouseEvent* )
{
  if( m_dragging ) {
    m_dragging = false;
    releaseMouse();
  }
}


void StreamOSD::mouseMoveEvent( QMouseEvent* e )
{
  if( m_dragging && this == mouseGrabber() ) {

    // check if the osd has been dragged out of the current screen
    int currentScreen = QApplication::desktop()->screenNumber( e->globalPos() );
    if( currentScreen != -1 )
      m_screen = currentScreen;

    const QRect& screen = QApplication::desktop()->screenGeometry( m_screen );
    
    // make sure the position is valid
    m_position = fixupPosition( e->globalPos() - m_dragOffset - screen.topLeft() );

    // move us to the new position
    move( m_position );

    // fix the position
    int midH = screen.width()/2;
    int midV = screen.height()/2;
    if( m_position.x() + width() > midH )
      m_position.rx() += width();
    if( m_position.y() + height() > midV )
      m_position.ry() += height();
  }
}


QPoint StreamOSD::fixupPosition( const QPoint& pp )
{
  QPoint p(pp);
  const QRect& screen = QApplication::desktop()->screenGeometry( m_screen );
  int maxY = screen.height() - height() - s_outerMargin;
  int maxX = screen.width() - width() - s_outerMargin;

  if( p.y() < s_outerMargin )
    p.ry() = s_outerMargin;
  else if( p.y() > maxY )
    p.ry() = maxY;

  if( p.x() < s_outerMargin )
    p.rx() = s_outerMargin;
  else if( p.x() > maxX )
    p.rx() = screen.width() - s_outerMargin - width();

  p += screen.topLeft();

  return p;
}


void StreamOSD::readSettings( KConfigBase* c )
{
  QString oldGroup = c->group();
  c->setGroup( "TorKOSD Position" );

  setPosition( c->readPointEntry( "Position", 0 ) );
  setScreen( c->readNumEntry( "Screen", 0 ) );
    
  c->setGroup( oldGroup );
}


void StreamOSD::saveSettings( KConfigBase* c )
{
  QString oldGroup = c->group();
  c->setGroup( "TorKOSD Position" );

  c->writeEntry( "Position", m_position );
  c->writeEntry( "Screen", m_screen );

  c->setGroup( oldGroup );
}

void StreamOSD::slotHideMonitor( )
{
    emit requestHideMonitor();
}


void StreamOSD::contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( infoList );

    menu->clear();
    menu->insertItem( "Close Stream", this,SLOT(slotCloseStream()) );
    menu->popup( point );

}


void StreamOSD::slotCloseStream( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(infoList, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (infoList->isSelected( it.current()))
            emit closeStream(it.current()->text(0));
        ++it;
    }


}

#include "newstreamosd.moc"
