/***************************************************************************
** $Id: portsandicons.h,v 1.9 2006/08/20 13:47:19 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   Based on config method in Tor
 *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/** Enumeration of types which option values can take */
typedef enum display_once_t {
  DISPLAY = 0,   /**< An arbitrary string. */
  DONT_DISPLAY_AGAIN,         /**< A non-negative integer less than MAX_INT */
} display_once_t;

typedef struct portsandicons_t {
  const char *port; /**< The full keyword (case insensitive). */
  const char *icon; /**< String (or null) describing initial value. */
  int secure; /**< String (or null) describing initial value. */
  display_once_t display; 
} portsandicons_t;


#define MSG(port,icon,secure, display)                             \
  { port,icon,secure, display }

static portsandicons_t _port_icon[] = {
    MSG("80","konqueror", 0, DISPLAY),
    MSG("443","konqueror",1 , DISPLAY),
    MSG("http","konqueror",0 , DISPLAY),
    MSG("https","konqueror",1 , DISPLAY),
    MSG("21","ftp",0 , DISPLAY),
    MSG("22","konsole",0 , DISPLAY),
    MSG("telnet","konsole",0 , DISPLAY),
    MSG("23","konsole",1 , DISPLAY),
    MSG("25","mail",0 , DISPLAY),
    MSG("smtp","mail",0 , DISPLAY),
    MSG("53","error",0 , DISPLAY),
    MSG("domain","error",0 , DISPLAY),
    MSG("110","mail",0 , DISPLAY),
    MSG("pop3","mail",0 , DISPLAY),
    MSG("1863","tork_msn_protocol",0 , DISPLAY),
    MSG("mmcc","tork_yahoo_protocol",0 , DISPLAY),
    MSG("5050","tork_yahoo_protocol",0 , DISPLAY),
    MSG("6667","tork_irc_protocol",0 , DISPLAY),
    MSG("ircd","tork_irc_protocol",0 , DISPLAY),
    MSG("9030","tork_tor",1 , DISPLAY),
    MSG("9031","tork_tor",1 , DISPLAY),
    MSG("9001","tork_tor",1 , DISPLAY),
    MSG("9051","tork_tor",1 , DISPLAY),
    MSG("9050","tork_tor",1 , DISPLAY),
  { NULL, NULL, 0, DISPLAY }
};
#undef MSG

