/***************************************************************************
** $Id: questions.h,v 1.11 2006/09/11 20:47:26 hoganrobert Exp $
 *
 *   Based on config method in Tor
 *
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tork.h"


/** A variable allowed in the configuration file or on the command line. */
typedef struct question_t {
  const char *logquestion; /**< The full keyword (case insensitive). */
  const char *headline; /**< String (or null) describing initial value. */
  const char *body; /**< String (or null) describing initial value. */
  char torsaid[250]; /**< String (or null) describing initial value. */
  const char *question; /**< String (or null) describing initial value. */
  display_status_t state;  /**< The type of the value. */
  const char *type; /**< String (or null) describing initial value. */
  bool (tork::*pt2Member2)();
  void (tork::*pt2Member)();
} question_t;


/** An entry for config_vars: "The option <b>name</b> has type
 * CONFIG_TYPE_<b>conftype</b>, and corresponds to
 * or_options_t.<b>member</b>"
 */
#define MSG(logquestion,headline,body,torsaid,question, state, type, show, doIt)                             \
  { logquestion, headline,body,torsaid,question, state, type, show, doIt }

/** Array of configuration options.  Until we disallow nonstandard
 * abbreviations, order is significant, since the first matching option will
 * be chosen first.
 */
static question_t _tork_questions[] = {
    MSG("Your ContactInfo config option is not set", 
        "You Are Running A Server Without Any Contact Information!",
        "You can set your contact info in the configuration section 'My Server'. Please do so! ",
        "",
        "Would you like to set your contact info now?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::contactInfoSet),
        (&tork::enterContactInfo)),

    MSG("Could not bind to", 
        "Tor Couldn't Bind to One of the Addresses/Ports you configured!",
        "Tor is probably already running. If you like, TorK can connect to the already-running instance of Tor and manage that for you instead. (You will have to open the configuration dialog and re-apply any settings you wished to use.) ",
        "",
        "Would you like to do this now?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::fixAddressPort)),
    MSG("has not managed to confirm that its ORPort is reachable", 
        "Sorry! You're Tor Server is not working!",
        "You could be blocking incoming traffic on your Tor port.",
        "",
        "Would you like to see information on how to fix this?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::serverHelp)),
    MSG("must have public IP addresses", 
        "Sorry! You can't run a Tor Server!",
        "You appear to be behind a NAT router and TorK/Tor can't determine your public IP address.",
        "",
        "Would you like to continue running as a client only?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::continueAsClient)),
    MSG("Our testing circuit (to see if your ORPort is reachable) has failed.", 
        "A Test Connection to Your Server Failed!",
        "The address/port you specified in 'My Server' is proving difficult to connect to! Is it your firewall maybe?",
        "",
        "Would you like to see information on how to fix this?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::serverHelp)),
    MSG("Please upgrade!", 
        "Your Version of Tor is a Bit Out-of-Date!",
        "TorK can download and compile the latest stable version for you.",
        "",
        "Would you like to try this?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::updateTorStable)),
    MSG("cannotcontacttor", 
        "TorK cannot connect to Tor!",
        "If you are trying to manage a remote or already-running instance of Tor you may not have configured the address and/or port of the Tor server correctly.",
        "",
        "Would you like to configure the address and port now?",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::quickConfig)),

    MSG("applysettings", 
        "Would you like to apply your settings to Tor?",
        "You are connecting to a remote or local instance of Tor, it may not have the settings you've configured with TorK.",
        "",
        "Would you like to apply the settings now? (Note that you can do this automatically in future by selecting the option in the 'Quick Configure' dialog.)",
        DISPLAY_NONE,
        "TorK Feedback",
        (&tork::showGuideQuestions),
        (&tork::applySettingsToRunningTor)),

    MSG("securitynotice", 
        "Your Traffic Can Be Eavesdropped!",
        "",
        "",
        "Would you like to see an explanation of why using Tor can make un-encrypted traffic <b>potentially less secure</b> than normal?",
        DISPLAY_NONE,
        "Security Warnings",
        (&tork::showSecurityWarnings),
        (&tork::readEavesdropping)),


  { NULL,  NULL, NULL, "", NULL, DISPLAY_NONE, NULL, NULL, NULL }
};
#undef MSG
