/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

//dummy
#include "torkconfig.h"
#include <klocale.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kdebug.h>

void Running::init()
{

    QStringList existingMaps = TorkConfig::sOCKSBindAddressMany();
    QListViewItem *tm;
	for ( QStringList::Iterator it = existingMaps.begin(); it != existingMaps.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString entry = (*it).section(":",0,0);
        QString port = (*it).section(":",1,1);

        tm = new QListViewItem(SOCKSBindAddressMany,entry,port);
    }

    QStringList existingSocksPolicies = TorkConfig::sOCKSPolicy();

	for ( QStringList::Iterator it = existingSocksPolicies.begin(); it != existingSocksPolicies.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString policy = (*it).section(" ",0,0);
        QString section2 = (*it).section(" ",1,1);
        QString entry = section2.section(":",0,0);
        QString port = section2.section(":",1,1);


        tm = new QListViewItem(SOCKSPolicy,policy,entry,port);
    }

    
}
void Running::PushAdd_clicked()
{
    kdDebug() << "adding entry" << endl;
    new QListViewItem(SOCKSBindAddressMany,Address->text(), Port->text());
}

void Running::PushAdd2_clicked()
{
    kdDebug() << "adding entry" << endl;
    new QListViewItem(SOCKSPolicy,Policy->currentText(),SocksAddress->text(), SocksPort->text());
}


void Running::SOCKSBindAddressMany_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( SOCKSBindAddressMany );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void Running::slotDeleteEntry( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(SOCKSBindAddressMany, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SOCKSBindAddressMany->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


void Running::SOCKSPolicy_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( SOCKSPolicy );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeletePolicyEntry()) );
    menu->popup( point );

}


void Running::slotDeletePolicyEntry( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(SOCKSPolicy, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SOCKSPolicy->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


void Running::kcfg_DefaultRunningNormalOptions_toggled( bool state)
{
    NormalOptions->setEnabled(!state);
}



void Running::kcfg_CookieAuthentication_toggled( bool )
{
    if ( kcfg_CookieAuthentication->isChecked()){
        kcfg_HashedControlPassword->setEnabled(false);
    }else{
        kcfg_HashedControlPassword->setEnabled(true);
    }
}


void Running::kcfg_HashedControlPassword_textChanged( const QString & )
{
    if (! kcfg_HashedControlPassword->text().isEmpty()){
        kcfg_CookieAuthentication->setEnabled(false);
    }else{
        kcfg_CookieAuthentication->setEnabled(true);
    }

}


// <connections>
//     <connection>
//         <sender>SOCKSPolicy</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>Running</receiver>
//         <slot>SOCKSPolicy_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>SOCKSBindAddressMany</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>Running</receiver>
//         <slot>SOCKSBindAddressMany_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>Running</receiver>
//         <slot>PushAdd_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd2</sender>
//         <signal>clicked()</signal>
//         <receiver>Running</receiver>
//         <slot>PushAdd2_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_DefaultRunningNormalOptions</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_DefaultRunningNormalOptions_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_HashedControlPassword</sender>
//         <signal>textChanged(const QString&amp;)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_HashedControlPassword_textChanged(const QString&amp;)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_CookieAuthentication</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_CookieAuthentication_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_ClientOnly</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_ClientOnly_toggled(bool)</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">running.ui.h</include>
// </includes>
// <slots>
//     <slot>PushAdd_clicked()</slot>
//     <slot>PushAdd2_clicked()</slot>
//     <slot>SOCKSBindAddressMany_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
//     <slot>SOCKSPolicy_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeletePolicyEntry()</slot>
//     <slot>kcfg_DefaultRunningNormalOptions_toggled( bool state )</slot>
//     <slot>kcfg_HashedControlPassword_textChanged( const QString &amp; )</slot>
//     <slot>kcfg_CookieAuthentication_toggled( bool )</slot>
//     <slot>kcfg_ClientOnly_toggled( bool state )</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// <includehints>
//     <includehint>kurlrequester.h</includehint>
//     <includehint>kcombobox.h</includehint>
//     <includehint>kpushbutton.h</includehint>
// </includehints>




