/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include "torkconfig.h"
#include <klocale.h>
#include <kdebug.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kiconloader.h>

#ifdef HAVE_GEOIP_H
# include <GeoIP.h>
#else
# include "GeoIP-1.4.0/libGeoIP/GeoIP.h"
#endif

void MyServer::init()
{

    QStringList existingServers = TorkConfig::serversHistory();
    QListViewItem *tm;
	for ( QStringList::Iterator it = existingServers.begin(); it != existingServers.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        int cc = (*it).section("-",0,0).toInt();
        QString nick = (*it).section("-",-1);
        tm = new QListViewItem(MyFamily,nick);
        tm->setPixmap(0,QPixmap(SmallIcon("tork_" + QString(GeoIP_country_code[cc]).lower())));
        if (TorkConfig::myFamily().contains(*it))
            MyFamily->setSelected(tm,true);

	}


    QStringList exitPolicy = TorkConfig::exitPolicy();
	for ( QStringList::Iterator it = exitPolicy.begin(); it != exitPolicy.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString policy = (*it).section(" ",0,0);
        QString section2 = (*it).section(" ",1,1);
        QString ip = section2.section(":",0,0);
        QString port = section2.section(":",1,1);

        tm = new QListViewItem(ExitPolicy,policy, ip,port);
    }

}




void MyServer::kcfg_DefaultServerIP_toggled( bool )
{
    if ( kcfg_DefaultServerIP->isChecked()){
        kcfg_ORPort->setEnabled(false);
    }else{
        kcfg_ORPort->setEnabled(true);
    }
}

void MyServer::kcfg_DynDnsServerIP_toggled( bool )
{
    if (kcfg_DynDnsServerIP->isChecked() ){
        kcfg_Address->setEnabled(false);
    }else{
        kcfg_Address->setEnabled(true);
    }
}

void MyServer::kcfg_MiddleMan_toggled( bool )
{
    if (kcfg_MiddleMan->isChecked() ){
        tabWidget->page(2)->setEnabled(false);
    }else{
        tabWidget->page(2)->setEnabled(true);
    }
}


void MyServer::checkBox6_toggled( bool state)
{

    PerformanceOptions->setEnabled(!state);

}

void MyServer::pushAdd2_clicked()
{
    kdDebug() << "adding entry" << endl;
    new QListViewItem(ExitPolicy,Policy->text(0), SocksAddress->text(), SocksPort->text());
}


void MyServer::ExitPolicy_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( ExitPolicy );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void MyServer::slotDeleteEntry( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(ExitPolicy, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (ExitPolicy->isSelected( it.current()))
            delete it.current();
        ++it;
    }
    

}

// <connections>
//     <connection>
//         <sender>kcfg_DefaultServerIP</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>MyServer</receiver>
//         <slot>kcfg_DefaultServerIP_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_DefaultServerPerformance</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>MyServer</receiver>
//         <slot>checkBox6_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_DynDnsServerIP</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>MyServer</receiver>
//         <slot>kcfg_DynDnsServerIP_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_MiddleMan</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>MyServer</receiver>
//         <slot>kcfg_MiddleMan_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd2</sender>
//         <signal>clicked()</signal>
//         <receiver>MyServer</receiver>
//         <slot>pushAdd2_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>ExitPolicy</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>MyServer</receiver>
//         <slot>ExitPolicy_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>pushButton2</sender>
//         <signal>clicked()</signal>
//         <receiver>MyServer</receiver>
//         <slot>pushButton2_clicked()</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">server.ui.h</include>
// </includes>
// <slots>
//     <slot>kcfg_DefaultServerIP_toggled( bool )</slot>
//     <slot>kcfg_DynDnsServerIP_toggled( bool )</slot>
//     <slot>kcfg_MiddleMan_toggled( bool )</slot>
//     <slot>checkBox6_toggled( bool state )</slot>
//     <slot>pushAdd2_clicked()</slot>
//     <slot>ExitPolicy_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
//     <slot>pushButton2_clicked()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>


void MyServer::pushButton2_clicked()
{

    QListViewItemIterator it(MyFamily, QListViewItemIterator::Selected);
    while ( it.current() ) {
        it.current()->listView()->setSelected(it.current(),false);
        ++it;
    }

}
