/****************************************************************************
** $Id: torclient.h,v 1.36 2006/10/07 18:18:10 hoganrobert Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef _TORCLIENT_H_
#define _TORCLIENT_H_

#include <qsocket.h>
#include <qtextstream.h>
#include <kdebug.h>
#include <http.h>
#include <kconfigskeleton.h>




class KConfigSkeleton;
class KConfigSkeletonItem;

class PrevConfig
    {
    public:
        PrevConfig(): pr(0) {}
        PrevConfig( const QString& name, const QVariant& property )
            : nm(name), pr(property)
        {}
        typedef QValueList<PrevConfig> PrevConfigList;
        QString name() const { return nm; }
        QVariant property() const { return pr; }
        void setName( QString n ) { nm = n; }
        void setProperty( QVariant p ) { pr = p; }
    private:
        QString nm;
        QVariant pr;
    };



class Client : public QObject
{
    Q_OBJECT
public:
    Client( const QString &host, Q_UINT16 port );

    virtual ~Client();


    void sendToServer(const QString &string)
    {
        if (!socket)
            return;
        // write to the server
        //kdDebug() << string << endl;
        QTextStream os(socket);
        os << string << "\r\n";
        //socket->flush();
    }

    void bandwidth();
    bool isControllerWorking( );
    void updatePrevConfig(PrevConfig::PrevConfigList previtems);
    void newIdentity();
    void createService(const QString &dir, const QString &port);
signals:

    void streamStatusUpdate(const QString &, const QString &,
        const QString &, const QString &);
    void ORStatusUpdate(const QString &, const QString &);
    void circuitStatusUpdate(const QString &, const QString &, const QString &);
    void infoUpdate(const QString &,const QString &, const QString &);
    void bwUpdate(const QString &,const QString &);
    void updateActiveServers(const QStringList &);
    void updateServerStatus(const QString &, const QString &, const QString &,const QString &, bool);
    void fatalError();
    void serverError();
    void displayError(const QString &,const QString &);
    void displayServer(const QString &,const QString &);
    void whatImDoing(const QString &);
    void copyOldConfig();
    void shouldIApplySettings();
    void torConnectionClosed();
    void makeTorkStoppable();

public slots:
    void socketReadyRead();
    void applySettingsToRunningTor();
    void attemptAttach(const QString &, const QString &);
    void attemptExtendCircuit(const QString &, const QString &, bool);
    void attemptCreateCircuit(const QString &, bool);
    void attemptCloseStream(const QString &);
    void attemptAttachStreams( bool );
    void attemptCloseCircuit(const QString &);
    void fetchServerInfo(const QString &);
    void fetchServerInfoByNick(const QString &);

private slots:
    void closeConnection()
    {
        socket->close();
        if ( socket->state() == QSocket::Closing ) {
            // We have a delayed close.
            connect( socket, SIGNAL(delayedCloseFinished()),
                    SLOT(socketClosed()) );
        } else {
            // The socket is closed.
            socketClosed();
        }
    }


    void socketConnected()
    {
       kdDebug() << "connected to server" << endl;
       authenticate();
    }

    void socketConnectionClosed()
    {
       kdDebug() << "closed" << endl;
        emit torConnectionClosed();
    }

    void socketClosed()
    {
        kdDebug() << "close" << endl;
    }

    void socketError( int e )
    {
         if ( e == QSocket::ErrHostNotFound ||
              e == QSocket::ErrConnectionRefused )
            emit fatalError();
    }

    void authenticate();
    void parseEvent(const QString &type, const QString &info);
    void parseStream(const QString &info);
    void parseGuards(const QString &info);
    void parseORConn(const QString &info);
    void parseServer(const QString &info);
    void parseCircuit(const QString &info);
    void parseInfo(const QString &type, const QString &info);
    void parseBW(const QString &info);
    void parseDirStatus(const QString &info);
    void slotCheckTorNet();


private:
    void updateCandidateServers(const QString &path);
    QSocket *socket;
    bool m_expectingCircuitInfo;
    bool m_expectingStreamInfo;
    bool m_expectingOrconnInfo;
    bool m_expectingGuardsInfo;
    bool m_expectingDirStatus;
    bool m_expectingServerInfo;
//     void storeServers(const QString &line);
/*    QString getFPDigestFromFP(const QString &fp);
    QString getNickNameFromFPDigest(const QString &fpdigest);
    QString getNickNameFromFP(const QString &fp);
    QString getFPFromNickName(const QString &nickname);
    QString getFPFromFPDigest(const QString &fp);*/
    bool elementShouldBeUsed(const KConfigSkeletonItem* it);
    bool noSpecialProcessing(const KConfigSkeletonItem* it);
    bool readCookie();
    void readRouters();
    QString getPublicIP();
    QString ds_identity;
    QString ds_fp_identity;
    QString ds_ip;
    QString ds_server;
    QString ds_statuses;
    QString m_statustip;
    bool m_controllerWorking;
    bool authorityread;
    bool m_firstloadcomplete;
    PrevConfig::PrevConfigList m_previtems;
    typedef QMap<QString, QString> guardsmap;
    guardsmap entryGuards;
};

#endif // _Freshklam_H_


