/***************************************************************************
** $Id: tork.cpp,v 1.81 2006/10/24 19:14:23 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "tork.h"
#include "configdialog.h"
#include "quickconfig.h"
#include "torkconfig.h"
#include "functions.h"
#include "dndlistview.h"
#include "firstrunwizard.h"
#include "http.h"
#include "warnings.h"
#include "questions.h"
//#include "torconfig.h"
#include "portsandicons.h"
#include "likeback.h"
#include "version.h"

#include <qdragobject.h>
#include <kprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qtimer.h>
#include <qgroupbox.h>

#include <kconfigdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdeversion.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kkeydialog.h>
#include <ksqueezedtextlabel.h>
#include <kedittoolbar.h>

#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>
#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <kprocio.h>
#include <kmessagebox.h>
#include <dcopref.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kpassivepopup.h>
#include <kio/netaccess.h>
#include <khtml_part.h>
#include <dom/html_misc.h>
#include <kurl.h>
#include <khtmlview.h>
#include <kstandarddirs.h>
#include <ktip.h>

#include <qtooltip.h>
#include <qlabel.h>
#include <qfile.h>
#include <qhostaddress.h>

#ifdef HAVE_GEOIP_H
# include <GeoIP.h>
#else
# include "GeoIP-1.4.0/libGeoIP/GeoIP.h"
#endif

tork *kmain = 0L;

using namespace tk;

const char *dayweekmonth[] = {
    "day",
    "week",
    "month"
};

tork::tork()
    : KMainWindow( 0, "TorK" ),
      m_view(new torkView(this)),
      m_printer(0),
      m_servererrornag(true),
      m_contactinfonag(true),
      m_serverworking(true),
      m_toolTipShowing(false)
{

/*    getPublicIP();*/
	kmain = this;

    if (TorkConfig::user().isEmpty())
        runWizard();

    client = 0L;
    childproc = 0L;
    privoxyproc = 0L;
    tfPrivoxy = 0L;
    tfTor = 0L;

    // accept dnd
    //setAcceptDrops(true);


    // then, setup our actions
    setupActions();

    // Instanciate the LikeBack system, and show the first-use information dialog if the button-bar is shown:
     LikeBack *likeBack = new LikeBack(LikeBack::AllButtons, LikeBack::isDevelopmentVersion(TORK_VERSION)); // Show button-bar only in beta-versions
     likeBack->setServer("tork.sourceforge.net", "/likeback/send.php");
     likeBack->setAcceptedLanguages(QStringList::split(";", "en;fr"), i18n("Please write in English or French."));

     // Comment the following line once you are sure all your windows have a name:
     likeBack->setWindowNamesListing(LikeBack::WarnUnnamedWindows);

     // This line should be called early in your KMainWindow constructor because it references actionCollection().
     // It should be called before createGUI() for the action to be plugged in the Help menu:
     likeBack->sendACommentAction(actionCollection());

    // and a status bar
    statusBar()->show();

	m_statusInfo = new KSqueezedTextLabel(this);
/*	m_statusSpeed = new QLabel(this);*/
	m_statusTransfer = new QLabel(this);
	m_graphOut = new StatGraph(this,1,0,"Up");
	m_graphIn = new StatGraph(this,1,0,"Down");

	statusBar()->addWidget(m_statusInfo,2);
/*	statusBar()->addWidget(m_statusSpeed);*/
	statusBar()->addWidget(m_statusTransfer,2);
    statusBar()->addWidget(m_graphOut,1);
	statusBar()->addWidget(m_graphIn,1);

    // apply the saved mainwindow settings, if any, and ask the mainwindow
    // to automatically save settings if changed: window size, toolbar
    // position, icon size, etc.
    setAutoSaveSettings();

	//currentChanged(0);
	//applySettings(false);

    // tell the KMainWindow that this is indeed the main widget
    setCentralWidget(m_view);

	setStandardToolBarMenuEnabled(true);

    

    // allow the view to change the statusbar and caption
     connect(m_view, SIGNAL(signalChangeStatusbar(const QString&, const QString&)),
             this,   SLOT(changeStatusbar(const QString&,const QString&)));
     connect(m_view->m_osd, SIGNAL(requestHideMonitor()),
             this,   SLOT(toggleTorMon()));
    connect(m_view, SIGNAL(showSecurityNotice(const QString&)),
             this,   SLOT(showSecurityNotice(const QString&)));

    connect(m_view, SIGNAL(showMyClient()),
             this,   SLOT(showMyClient()));
    connect(m_view, SIGNAL(showMyServer()),
             this,   SLOT(showMyServer()));
    connect(m_view, SIGNAL(showMyNetworkView()),
             this,   SLOT(showMyNetworkView()));
    connect(m_view, SIGNAL(showMyBandwidth()),
             this,   SLOT(showMyBandwidth()));
    connect(m_view, SIGNAL(miniView()),
             this,   SLOT(toggleTorMon()));
    connect(m_view, SIGNAL(newIdentity()),
             this,   SLOT(useNewIdentity()));
    connect(m_view, SIGNAL(konqWithTor()),
             this,   SLOT(toggleKDESetting()));
    connect(m_view, SIGNAL(networkList()),
             this,   SLOT(networkList()));
    connect(m_view, SIGNAL(hiddenServices()),
             this,   SLOT(hiddenServices()));







//     connect(m_view, SIGNAL(signalChangeCaption(const QString&)),
//             this,   SLOT(changeCaption(const QString&)));

//    setupGUI();

    changeStatusbar("0","0");
    sayWhatImDoing("To start Tor, click the green onion.");
    showTipOnStart();
    turnOffKDE();

	if ((KApplication::kApplication()->isRestored()))
        startEverything();

}

tork::~tork()
{
    prepareToShut();
}

void tork::prepareToShut()
{

    KConfig* config = new KConfig("kioslaverc", false, false);
    config->setGroup( "Proxy Settings" );
    config->writeEntry( "httpProxy", TorkConfig::originalHttpProxy() );
    config->writeEntry( "httpsProxy", TorkConfig::originalHttpsProxy() );
    config->writeEntry( "ProxyType", TorkConfig::originalProxyType() );
    config->sync();

    // Inform all running io-slaves about the changes...
    // if we cannot update, ioslaves inform the end user...
    if (!DCOPRef("*", "KIO::Scheduler").send("reparseSlaveConfiguration", QString::null))
    {
        QString caption = i18n("Update Failed");
        QString message = i18n("You have to restart the running applications "
                            "for these changes to take effect.");
        KMessageBox::information (this, message, caption);
        return;
    }
    if (childproc !=0L){
        childproc->kill();
        delete childproc;
        childproc = 0L;
    }

    if (privoxyproc !=0L){
        privoxyproc->kill();
        delete privoxyproc;
        privoxyproc = 0L;
    }

 
    if (tfPrivoxy !=0L){
        delete tfPrivoxy;
        tfPrivoxy = 0L;
    }

    if (tfTor !=0L){
        delete tfTor;
        tfTor = 0L;
    }

    m_view->m_osd->saveSettings(KGlobal::config());

    TorkConfig::writeConfig();

}

bool tork::queryClose()
{

    if (client && !kapp->sessionSaving()) { 
        hide(); 
        return false; 
    } 
    return true;
}

/*    m_view->m_osd->saveSettings(KGlobal::config());
    TorkConfig::writeConfig();
    kapp->quit();
    e->accept();*/

void tork::setupActions()
{
    //Set up system tray
  	_tray = new KSystemTray(this, "tork tray");
	_tray->setPixmap(KSystemTray::loadIcon("tork_none"));
	connect(_tray,SIGNAL(quitSelected()),SLOT(shuttingDown()));

	KPopupMenu *conf_menu = _tray->contextMenu();
    torkConfigure = new KAction(i18n("&Configure TorK"), "configure", 0,this, SLOT(optionsPreferences()),actionCollection(),"configure_tor");

	torkStart = new KAction(i18n("Start Tor"), "tork_green", 0,this, SLOT(startEverything()),actionCollection(),"start_tor");
    torkStop = new KAction(i18n("Stop Tor"),"tork_none", 0,this, SLOT(stopTor()),actionCollection(),"stop_tor");

    enableKonqi = new KAction(i18n("Enable/Disable Konqueror's use of Tor"),"konqueror", 0,this, SLOT(toggleKDESetting()),actionCollection(),"enable_konqi");

    enableTormon = new KAction(i18n("Enable/Disable Connection Monitor"),"network", 0,this, SLOT(toggleTorMon()),actionCollection(),"enable_tormon");

    browseHiddenServices = new KAction(i18n("Browse Hidden Services"),"tork_tor", 0,this, SLOT(hiddenServices()),actionCollection(),"hidden_services");

    browseNetworkList = new KAction(i18n("Browse Tor Network Status"),"info", 0,this, SLOT(networkList()),actionCollection(),"network_list");


	torkUpdateTork = new KAction(i18n("Download Tork"), "tork_green", 0,this, SLOT(updateTork()),actionCollection(),"update_tork");

	torkUpdateStable = new KAction(i18n("Download Tor (Stable Version)"), "tork_tor", 0,this, SLOT(updateTorStable()),actionCollection(),"update_torstable");

	torkUpdateUnstable = new KAction(i18n("Download Tor (Experimental Version)"), "tork_tor", 0,this, SLOT(updateTorUnstable()),actionCollection(),"update_torunstable");

	torkUpdateDante = new KAction(i18n("Download Dante (SOCKS Client)"), "proxy", 0,this, SLOT(updateDante()),actionCollection(),"update_dante");

	torkUpdatePrivoxy = new KAction(i18n("Download Privoxy (Proxy)"), "proxy", 0,this, SLOT(updatePrivoxy()),actionCollection(),"update_privoxy");

	torkFirstRunWizard = new KAction(i18n("First Run Wizard"), "wizard", 0,this, SLOT(runWizard()),actionCollection(),"firstrun_wizard");

	toggleTorbar = new KAction(i18n("Toggle Tor Bar"), "tork_tor", 0,this, SLOT(toggleTorBar()),actionCollection(),"toggle_torbar");


	torkTip = new KAction(i18n("Tip of the Day"), "idea", 0,this, SLOT(showTip()),actionCollection(),"help_show_tip");

    torkStart->setEnabled(true);
    torkStop->setEnabled(false);
    enableKonqi->setEnabled(false);
    browseHiddenServices->setEnabled(false);
    //set up all other actions

//    KStdAction::openNew(this, SLOT(fileNew()), actionCollection());
    KStdAction::quit(kapp, SLOT(quit()), actionCollection());


    m_toolbarAction = KStdAction::showToolbar(this, SLOT(optionsShowToolbar()), actionCollection());
    m_statusbarAction = KStdAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());

    KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
    KStdAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), actionCollection());
    KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());

    // custom menu and menu item - the slot is in the class torkView
//     KAction *custom = new KAction(i18n("Swi&tch Colors"), 0,
//                                   m_view, SLOT(switchColors()),
//                                   actionCollection(), "switch_action");

    createGUI();

	torkStart->plug(conf_menu);
	torkStop->plug(conf_menu);
	torkConfigure->plug(conf_menu);
	
	QToolTip::add( _tray, i18n( "TorK - Onion Router" ) );
	_tray->show();

    if (m_view->getShowTormon())
        enableTormon->setIcon("cancel");
    else
        enableTormon->setIcon("network");

    kdDebug() << m_view->streamList->size() << endl;
    kdDebug() << m_view->streamList->viewport()->size() << endl;


}

void tork::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

    // create a new window
    (new tork)->show();
}

void tork::optionsShowToolbar()
{
    // this is all very cut and paste code for showing/hiding the
    // toolbar
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void tork::optionsShowStatusbar()
{
    // show/hide the statusbar
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void tork::optionsConfigureKeys()
{
    KKeyDialog::configure(actionCollection());
}

void tork::optionsConfigureToolbars()
{
	// use the standard toolbar editor
    #if defined(KDE_MAKE_VERSION)
    # if KDE_VERSION >= KDE_MAKE_VERSION(3,1,0)
        saveMainWindowSettings(KGlobal::config(), autoSaveGroup());
    # else
        saveMainWindowSettings(KGlobal::config());
    # endif
    #else
        saveMainWindowSettings(KGlobal::config());
    #endif
    KEditToolbar dlg(factory());
    connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(newToolbarConfig()));
    dlg.exec();
}

void tork::newToolbarConfig()
{
    // this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
    // recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
	createGUI();

    #if defined(KDE_MAKE_VERSION)
    # if KDE_VERSION >= KDE_MAKE_VERSION(3,1,0)
        applyMainWindowSettings(KGlobal::config(), autoSaveGroup());
    # else
        applyMainWindowSettings(KGlobal::config());
    # endif
    #else
        applyMainWindowSettings(KGlobal::config());
    #endif

}

void tork::copyOldConfig()
{

    KConfigSkeletonItem::List pitems(TorkConfig::self()->items());
    KConfigSkeletonItem::List::ConstIterator it;
    PrevConfig::PrevConfigList::iterator tp;
    
    for( it = pitems.begin(); it != pitems.end(); ++it ) {
        for( tp = prevlist.begin(); tp != prevlist.end(); ++tp ) {
            if ((*tp).name() == (*it)->name()){
                (*tp).setProperty((*it)->property());
                continue;
            }
        }
        //tp = prevlist.find(PrevConfig((*it)->name(),(*it)->property()));
        if ( tp == prevlist.end())
            prevlist.append(PrevConfig((*it)->name(),(*it)->property()));
    }

    if (client != 0L)
        client->updatePrevConfig(prevlist);


}

void tork::optionsPreferences()
{
	// The preference dialog is derived from prefs-base.ui which is subclassed into Prefs
	//
	// compare the names of the widgets in the .ui file 
	// to the names of the variables in the .kcfg file

    copyOldConfig();

    TorkConfigDialog* dialog = (TorkConfigDialog*) KConfigDialog::exists( "settings" );

    if( !dialog )
    {
        //KConfigDialog didn't find an instance of this dialog, so lets create it :
        dialog = new TorkConfigDialog( this, "settings", TorkConfig::self() );
        connect( dialog, SIGNAL(settingsChanged()), SLOT(applySettingsToRunningTor()) );
    }

    //FIXME it seems that if the dialog is on a different desktop it gets lost
    //      what do to? detect and move it?

    if (client != 0L)
        dialog->m_quickconfig->quickGroup->setEnabled(false);
    dialog->show();
    dialog->raise();
    dialog->setActiveWindow();


    //so that if the engine page is needed to be shown it works


}

void tork::openConfig(const QCString& page)
{
    copyOldConfig();

	// The preference dialog is derived from prefs-base.ui which is subclassed into Prefs
	//
	// compare the names of the widgets in the .ui file 
	// to the names of the variables in the .kcfg file
    TorkConfigDialog* dialog = (TorkConfigDialog*) KConfigDialog::exists( "settings" );

    if( !dialog )
    {
        //KConfigDialog didn't find an instance of this dialog, so lets create it :
        dialog = new TorkConfigDialog( this, "settings", TorkConfig::self() );
        connect( dialog, SIGNAL(settingsChanged()), SLOT(applySettingsToRunningTor()) );
    }

    //FIXME it seems that if the dialog is on a different desktop it gets lost
    //      what do to? detect and move it?

    if (client != 0L)
        dialog->m_quickconfig->quickGroup->setEnabled(false);

    dialog->show();
    dialog->raise();
    dialog->setActiveWindow();
    dialog->showPage(page);
    //so that if the engine page is needed to be shown it works


}

void tork::changeStatusbar(const QString& in,const QString& out)
{
    //from ktorrent
    static int down;
    static int up;
    static int secondselapsed=0;

    secondselapsed++;

    if ((in == "zero") && (out =="zero")){
        down = 0;
        up = 0;
        secondselapsed = 0;
//         QString tmp = i18n("Speed up: 0.00 KB/sec / down: 0.00 KB/sec");
//         m_statusSpeed->setText(tmp);

        QString tmp1 = i18n("Transferred up: 0 B / down: 0 B");
        m_statusTransfer->setText(tmp1);

    }else{
        down += in.toInt();
        up += out.toInt();

//         QString tmp = i18n("Speed up: %1 / down: %2")
//                 .arg(KBytesPerSecToString((up/1204.0)/secondselapsed,2))
//                 .arg(KBytesPerSecToString((down/1024.0)/secondselapsed,2));
//     
//         m_statusSpeed->setText(tmp);

        float bitRateIn = in.toInt();// * 8.0 / (secondselapsed / 1000.0);
        float bitRateOut = out.toInt();// * 8.0 / (secondselapsed / 1000.0);

//         kdDebug() << "bitRateIn " << bitRateIn << endl
//                 << "bitRateOut " << bitRateOut << endl;

        // Convert to percentages.
        int8_t upperIn = (int8_t) (100.0 * bitRateIn /28000);
        if (upperIn < 0) upperIn = 0;
        else if (upperIn > 100) upperIn = 100;

        int8_t upperOut = (int8_t) (100.0 * bitRateOut / (14000 ) );
        if (upperOut < 0) upperOut = 0;
        else if (upperOut > 100) upperOut = 100;

        m_graphIn->addPercentReading(upperIn, false);
        m_graphOut->addPercentReading(upperOut, false);

        m_view->m_osd->m_graphIn->addPercentReading(upperIn, false);
        m_view->m_osd->m_graphOut->addPercentReading(upperOut, false);

        QString tmp1 = i18n("Transferred up: %1 / down: %2")
                .arg(BytesToString(up))
                .arg(BytesToString(down));
        m_statusTransfer->setText(tmp1);
    }
	m_view->update();
}

void tork::sayWhatImDoing(const QString& text)
{
    // display the text on the caption
    m_statusInfo->setText(text);
}

void tork::changeCaption(const QString& text)
{
    // display the text on the caption
    setCaption(text);
}

void tork::startTor()
{


    if (childproc !=0L)
        return;
    m_list.clear();

    if (TorkConfig::torLocation().isEmpty()){
        int i;
        for (i = 0; _tork_messages[i].logmessage; ++i) {
            message_t *msg = &_tork_messages[i];
            if (QString(msg->logmessage).contains("notorexecutable")){
                strncpy(msg->torsaid,i18n("You can't find me."),249);
                showWarning(msg->state, msg->headline, msg->torsaid, msg->body, msg->type);
            }

        }
        return;
    }


    sayWhatImDoing("Starting Tor..");
    childproc = new KProcIO();
    childproc->setUseShell(TRUE);

    QString torConfFile = writeConf();


    *childproc << TorkConfig::torLocation() << " -f " + torConfFile;

	connect( childproc, SIGNAL(processExited(KProcess *)),
			SLOT(childExited()) );
	connect( childproc, SIGNAL(readReady(KProcIO *)),
		SLOT(receivedOutput(KProcIO *)) );

	childproc->start(KProcIO::NotifyOnExit)    ;


}

void tork::stopTor()
{
    // start Tor
    stopController();
    stopNetStat();

    if (tfPrivoxy !=0L){
        delete tfPrivoxy;
        tfPrivoxy = 0L;
    }

    if (tfTor !=0L){
        delete tfTor;
        tfTor = 0L;
    }

    if (childproc !=0L){
        childproc->kill();
        delete childproc;
        childproc = 0L;
    }
    torkStart->setEnabled(true);
    torkStop->setEnabled(false);
    enableKonqi->setEnabled(false);
    browseHiddenServices->setEnabled(false);
    timer->stop();
	_tray->setPixmap(KSystemTray::loadIcon("tork_none"));
    changeStatusbar("zero","zero");
    turnOffKDE();
    m_view->m_osd->infoList->clear();
    m_view->m_osd->hide();
    sayWhatImDoing("To start Tor, click the green onion.");

}

void tork::stopController()
{
    if (client != 0L){
        client->socketReadyRead();
        client->deleteLater();
        client = 0L;
    }
	_tray->setPixmap(KSystemTray::loadIcon("tork_none"));

    m_view->circuitList->clear();
    m_view->ORList->clear();
    m_view->serverList->clear();
    m_view->streamList->clear();
    m_list.clear();

    setCaption("");
}


QString tork::writeConf()
{

    if (tfTor != 0L)
        delete tfTor;

    tfTor = new KTempFile();
    tfTor->setAutoDelete(true);
    if ( tfTor->status() != 0 ) {
          tfTor->close();
          KMessageBox::information (this,"KMFilterActionWithCommand: Could not create temp file!");
          return "";
    }


	QTextStream &ts = *(tfTor->textStream());
    
    switch (TorkConfig::quickConfigure()) {
            case 0 : //Tor client and server with default settings
                ts << "ControlPort " << TorkConfig::controlPort() << "\n";
                ts << "NickName " << TorkConfig::nickName() << "\n";
                ts << "ORPort " << TorkConfig::oRPort() << "\n";
                ts << "DirPort " << TorkConfig::dirPort() << "\n";
                ts << "ContactInfo " << TorkConfig::contactInfo() << "\n";
                if (TorkConfig::dynDnsServerIP()){
                    QString myIP = getPublicIP();
                    ts << "Address " << myIP << "\n";
/*                    ts << "ORListenAddress " << myIP << "\n";*/
                }

                break;
            case 1 : //Tor client and relay server with default settings
                ts << "ControlPort " << TorkConfig::controlPort() << "\n";
                ts << "NickName " << TorkConfig::nickName() << "\n";
                ts << "ORPort " << TorkConfig::oRPort() << "\n";
                ts << "DirPort " << TorkConfig::dirPort() << "\n";
                ts << "ContactInfo " << TorkConfig::contactInfo() << "\n";
                if (TorkConfig::dynDnsServerIP()){
                    QString myIP = getPublicIP();
                    ts << "Address " << myIP << "\n";
/*                    ts << "ORListenAddress " << myIP << "\n";*/
                }
                if (TorkConfig::middleMan()){
                    ts << "ExitPolicy reject *:*\n";
                }

                break;

            case 2 : //Tor server with default settings
                ts << "ControlPort " << TorkConfig::controlPort() << "\n";
                ts << "NickName " << TorkConfig::nickName() << "\n";
                ts << "ORPort " << TorkConfig::oRPort() << "\n";
                ts << "DirPort " << TorkConfig::dirPort() << "\n";
                ts << "ContactInfo " << TorkConfig::contactInfo() << "\n";
                if (TorkConfig::dynDnsServerIP() ){
                    QString myIP = getPublicIP();
                    ts << "Address " << myIP << "\n";
/*                    ts << "ORListenAddress " << myIP << "\n";*/
                }

                break;  

            case 3 : //Tor relay server with default settings
                ts << "ControlPort " << TorkConfig::controlPort() << "\n";
                ts << "NickName " << TorkConfig::nickName() << "\n";
                ts << "ORPort " << TorkConfig::oRPort() << "\n";
                ts << "DirPort " << TorkConfig::dirPort() << "\n";
                ts << "ContactInfo " << TorkConfig::contactInfo() << "\n";
                if (TorkConfig::dynDnsServerIP() ){
                    QString myIP = getPublicIP();
                    ts << "Address " << myIP << "\n";
/*                    ts << "ORListenAddress " << myIP << "\n";*/
                }
                if (TorkConfig::middleMan()){
                    ts << "ExitPolicy reject *:*\n";
                }

                break;  

            case 4 : //Tor client with default settings
                ts << "ControlPort " << TorkConfig::controlPort() << "\n";
                ts << "DirPort " << TorkConfig::dirPort() << "\n";
                break;


            case 5 : //Use custom settings
                ts << "ContactInfo " << TorkConfig::contactInfo() << "\n";
                ts << "NickName " << TorkConfig::nickName() << "\n";
                ts << "ControlPort " << TorkConfig::controlPort() << "\n";
                ts << "DirPort " << TorkConfig::dirPort() << "\n";
                if (TorkConfig::dynDnsServerIP()){
                    QString myIP = getPublicIP();
                    ts << "Address " << myIP << "\n";
/*                    ts << "ORListenAddress " << myIP << "\n";*/
                }

                writeCustomOptions2(ts);
                break;
    }

    if ((TorkConfig::httpProxyPort() > 0) && (!TorkConfig::httpProxyHost().isEmpty()))  
        ( ts << "HttpProxy " << TorkConfig::httpProxyHost() << ":" << TorkConfig::httpProxyPort() << "\n") ;
    if ((TorkConfig::httpsProxyPort() > 0) && (!TorkConfig::httpsProxyHost().isEmpty()))  
        ( ts << "HttpsProxy " << TorkConfig::httpsProxyHost() << ":" << TorkConfig::httpsProxyPort() << "\n") ;

    if ((!TorkConfig::httpProxyAuthenticatorUserName().isEmpty()) && (!TorkConfig::httpProxyAuthenticatorPassword().isEmpty()))
        (ts << "HttpProxyAuthenticator " << TorkConfig::httpProxyAuthenticatorUserName() << ":" << TorkConfig::httpProxyAuthenticatorPassword() << "\n");

    if ((!TorkConfig::httpsProxyAuthenticatorUserName().isEmpty()) && (!TorkConfig::httpsProxyAuthenticatorPassword().isEmpty()))  
        (ts << "HttpsProxyAuthenticator " << TorkConfig::httpsProxyAuthenticatorUserName() << ":" << TorkConfig::httpsProxyAuthenticatorPassword() << "\n");


    tfTor->close();

    kdDebug() << "to here" << endl;
    return tfTor->name();

}

void tork::writeCustomOptions2(QTextStream &ts)
{

    //Add any new servers to excludeNodes that we want excluded by Country
    QStringList existingServers = TorkConfig::serversHistory();
    QStringList currentExcludeNodes = TorkConfig::excludeNodes();
	for ( QStringList::Iterator it = existingServers.begin(); it != existingServers.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;

        int cc = (*it).section("-",0,0).toInt();
        QString nick = (*it).section("-",1);
        if ((!TorkConfig::excludeNodes().contains(nick)) &&
            (TorkConfig::excludeCountries().contains(GeoIP_country_code[cc])))
            currentExcludeNodes.append(nick);
    }
    if (!currentExcludeNodes.isEmpty()){
        TorkConfig::setExcludeNodes(currentExcludeNodes);
    }


    KConfigSkeletonItem::List items = TorkConfig::self()->items();
    KConfigSkeletonItem::List::ConstIterator it;
    for( it = items.begin(); it != items.end(); ++it ) {
        kdDebug() << (*it)->name()  << endl;
        if (elementShouldBeUsed((*it))){
            if (noSpecialProcessing((*it), ts)){
                kdDebug() << (*it)->name()  << endl;
                if ( (*it)->property().type() == QVariant::String ) {
                    if (!((*it)->property().toString()).isEmpty()){
                        ( ts << (*it)->name() << " " << (*it)->property().toString() << "\n");
                        kdDebug() << (*it)->name() << " " << (*it)->property().toString() << endl;
                    }
                }else if ( (*it)->property().type() == QVariant::StringList ) {
                    if (!((*it)->property().toStringList()).isEmpty()){
                        ( ts << (*it)->name() << " " << (*it)->property().toStringList().join(",") << "\n");
                        kdDebug() << (*it)->name() << " " << (*it)->property().toStringList().join(",") << endl;
                    }
                }else if ( (*it)->property().type() == QVariant::Int ) {
                    if (((*it)->property().toInt()) > 0){
                        ( ts << (*it)->name() << " " << (*it)->property().toString() << "\n");
                        kdDebug() << (*it)->name() << " " << (*it)->property().toString() << endl;
                    }
                }else if ( (*it)->property().type() == QVariant::Bool ) {
                    if (((*it)->property().toInt()) > 0){
                        ( ts << (*it)->name() << " " << (*it)->property().toInt() << "\n");
                        kdDebug() << (*it)->name() << " " << (*it)->property().toInt() << endl;
                    }
                }

            }
        }
        //if ( p.type() == QVariant::Bool ) {
    }


    if ((!TorkConfig::sOCKSBindAddressHost().isEmpty()) && (TorkConfig::sOCKSBindAddressPort()  > -1))
        ( ts << "SOCKSListenAddress " << TorkConfig::sOCKSBindAddressHost() << ":" << TorkConfig::sOCKSBindAddressPort() <<"\n") ;

    if ((TorkConfig::sOCKSBindAddressHost().isEmpty()) && (TorkConfig::sOCKSBindAddressPort()  > -1))
        ( ts << "SOCKSPort " << TorkConfig::sOCKSBindAddressPort() <<"\n") ;

}

bool tork::elementShouldBeUsed(const KConfigSkeletonItem* it)
{


    if ((((!TorkConfig::defaultMaxMinOptions())) && ((*it).group() == "MaxMin")) ||
       (((!TorkConfig::defaultRunningNormalOptions())) && ((*it).group() == "RunningNormal")) ||
       ((!(TorkConfig::defaultServerIP()))  && ((*it).group() == "DefaultServerAddress")) ||
       (((*it).group() == "FirewallsProxies")) ||
       (((*it).group() == "RunningSpecial")) ||
       (((*it).group() == "Servers")) ||
       (((*it).group() == "MyServer")) ||
       (((*it).group() == "Usability")) ||
       (((*it).group() == "UsingTor")) ||
       (((*it).group() == "MyHiddenServices")) ||
       ((!(TorkConfig::defaultServerPerformance())) && ((*it).group() == "ServerPerformance")))
            return true;


    return false;
}

bool tork::noSpecialProcessing(const KConfigSkeletonItem* it, QTextStream &ts)
{

    if (((*it).name() == "BandwidthBurst") || ((*it).name() == "BandwidthRate")){
        ( ts << (*it).name() << " " << (*it).property().toString() << "KB\n");
        return false;
    }

    if ((*it).name() == "MaxAdvertisedBandwidth"){
        ( ts << (*it).name() << " " << (*it).property().toString() << "GB\n");
        return false;
    }

    if ((*it).name() == "AccountingMax"){
        ( ts << (*it).name() << " " << ((*it).property().toInt() * 1024 * 1024) << "bytes\n");
        return false;
    }

    if ((*it).name() == "AccountingStart"){
       if ((*it).property().toString() == "day")
            ( ts << (*it).name() << " " << (*it).property().toString() << " 00:00\n");
       else
            ( ts << (*it).name() << " " << (*it).property().toString() << " 1 00:00\n");
       return false;
    }


    if ((*it).name() == "KeepalivePeriod"){
        if (!TorkConfig::reachableAddresses().isEmpty()){
            ( ts << (*it).name() << " " << ((*it).property().toInt() * 60) << "\n") ;
        }
        return false;
    }

    if ((*it).name() == "TrackHostExits"){
        if (!TorkConfig::trackHostExits().isEmpty()){
            ( ts << (*it).name() << " " << ((*it).property().toStringList().join(",")) << "\n") ;
            if (TorkConfig::trackHostExitsExpire() > 0)  
                ( ts << "TrackHostExitsExpire " << (TorkConfig::trackHostExitsExpire() * 60) << "\n") ;
        }
        return false;
    }


    if ((*it).name() == "SOCKSBindAddressMany"){

        if (!TorkConfig::sOCKSBindAddressMany().isEmpty()){
            QStringList socksbind = TorkConfig::sOCKSBindAddressMany();
            for ( QStringList::Iterator it = (socksbind).begin(); it != (socksbind).end(); it++ )
            {
                if ((*it).isEmpty())
                    continue;
                ts << "SOCKSListenAddress " << (*it) << "\n" ;
            }
        }
        return false;
    }

    if ((*it).name() == "HashedControlPassword"){
        if (!TorkConfig::hashedControlPassword().isEmpty()){
            QString hash = doHashPassword();
            if(!hash.isEmpty())
                ts << "HashedControlPassword " << hash << "\n" ;
        }
        return false;
    }


    if ((*it).name() == "ExitPolicy"){
        if (TorkConfig::middleMan())
            ts << "ExitPolicy " << "reject *:*" << "\n" ;
        else
            ts << "ExitPolicy " << (*it).property().toStringList().join(",") << "\n" ;
        return false;
    }

    if ((*it).name() == "HiddenServices"){
        QStringList hiddenServices = TorkConfig::hiddenServices();
        for ( QStringList::Iterator it = (hiddenServices).begin(); it != (hiddenServices).end(); it++ )
        {
            if ((*it).isEmpty())
                continue;
            ts <<  "HiddenServiceDir " << (*it).section("\n",-1) << "\n" ;
            ts <<  "HiddenServicePort " << (*it).section("\n",-4,-4) << " " << (*it).section("\n",-3,-3) << "\n";
        }
        return false;
    }

    return true;
}


QString tork::doHashPassword()
{

 	hashproc = new KProcIO();
	hashproc->setUseShell(TRUE);
    m_hashedpassword = "";
	QString hashCommand=QString("tor --hash-password %1").arg(TorkConfig::hashedControlPassword());

	*hashproc<<hashCommand;

	connect( hashproc, SIGNAL(readReady(KProcIO * )),
		SLOT(processHashProc(KProcIO * )) );
	hashproc->start(KProcIO::NotifyOnExit,TRUE);

    while (hashproc->isRunning() && m_hashedpassword.isEmpty())
        kapp->processEvents();

    return m_hashedpassword;
}

void tork::processHashProc(KProcIO *hashproc)
{
	QString item = "";
	int pos;

	while ((pos = (hashproc->readln(item,true))) != -1) {
        kdDebug() << item << endl;
		if (item.startsWith("16:"))
            m_hashedpassword = item;
	}
	hashproc->ackRead();

}





void tork::childExited()
{

    int status = childproc->exitStatus();
    kdDebug() << status << endl;
    delete childproc;
    childproc = 0L;
    torkStart->setEnabled(true);
    torkStop->setEnabled(false);
    enableKonqi->setEnabled(false);
    browseHiddenServices->setEnabled(false);
    sayWhatImDoing("To start Tor, click the green onion.");

    turnOffKDE();



}

void tork::privoxyExited()
{



}

void tork::startEverything()
{



    switch (TorkConfig::quickConfigure()) {
        case 0 : 
        case 1 : 
        case 2 : 
        case 3 : 
        case 4 : 
        case 5 : 
            startNetStat();
            startPrivoxy();
            startTor();
            break;
        case 6 :
            startNetStat();
            startController();
            break;
        case 7 :
            startNetStat();
            startPrivoxy();
            startController();
            break;
        default:
            return;
    }
}

void tork::startPrivoxy()
{

    if (TorkConfig::systemProxy())
        return;

    if (TorkConfig::privoxyLocation().isEmpty()){
        int i;
        for (i = 0; _tork_messages[i].logmessage; ++i) {
            message_t *msg = &_tork_messages[i];
            if (QString(msg->logmessage).contains("noprivoxyexecutable")){
                strncpy(msg->torsaid,i18n("You can't find Privoxy."),249);
                showWarning(msg->state, msg->headline, msg->torsaid, msg->body, msg->type);
            }

        }
        return;
    }

    privoxyproc = new KProcIO();
    privoxyproc->setUseShell(TRUE);

	QString curpath = (QString) getenv("PATH");
	privoxyproc->setEnvironment("PATH",curpath + ":/usr/local/sbin:/usr/sbin:/sbin:/usr/local/bin:/usr/bin:/bin");

    QString privoxypid = QString("%1/.tork/privoxypid").arg(getenv("HOME"));
    QString privoxyConfFile = writePrivoxyConf();
    *privoxyproc << "kill `/bin/cat /var/run/privoxy.pid`&& /rm -f /var/lock/privoxy /var/run/privoxy.pid;";
    *privoxyproc << "kill `/bin/cat " << privoxypid << "`&& /rm -f /var/lock/privoxy " << privoxypid << ";";
    *privoxyproc << TorkConfig::privoxyLocation() << " " << privoxyConfFile << " --user " << getenv("USER") << " --pidfile " << privoxypid;

 	connect( privoxyproc, SIGNAL(processExited(KProcess *)),
 			SLOT(privoxyExited()) );
// 	connect( privoxyproc, SIGNAL(readReady(KProcIO *)),
// 		SLOT(receivedOutput(KProcIO *)) );

	privoxyproc->start(KProcIO::NotifyOnExit)    ;


}


QString tork::writePrivoxyConf()
{

    if (tfPrivoxy != 0L)
        delete tfPrivoxy;

    tfPrivoxy = new KTempFile();
    tfPrivoxy->setAutoDelete(true);
    if ( tfPrivoxy->status() != 0 ) {
          tfPrivoxy->close();
          KMessageBox::information (this,"KMFilterActionWithCommand: Could not create temp file!");
          return "";
    }


	QTextStream &ts = *(tfPrivoxy->textStream());
    
    ts << "forward-socks4a / localhost:9050 ." << "\n";
    ts << "confdir ." << "\n";
    ts << "logdir ." << "\n";
    ts << "listen-address 127.0.0.1:8118" << "\n";
    ts << "debug   1    # URLs" << "\n";
    ts << "debug   4096 # Info" << "\n";
    ts << "debug   8192 # Errors - *we highly recommended enabling this*" << "\n";
    ts << "toggle 1" << "\n";
    ts << "buffer-limit 4069" << "\n";
    ts << "enable-edit-actions 1" << "\n";
    ts << "enable-remote-toggle 1" << "\n";

    tfPrivoxy->close();

    kdDebug() << "to here" << endl;
    return tfPrivoxy->name();

}

void tork::startController()
{

    QPixmap bg = QPixmap(locate("data", "tork/about/europe.png"));
    kdDebug() << m_view->streamList->size() << endl;
    kdDebug() << m_view->streamList->viewport()->size() << endl;
    m_view->streamList-> setPaletteBackgroundPixmap( bg );

    bg = QPixmap(locate("data", "tork/about/africa.png"));
    kdDebug() << m_view->circuitList->size() << endl;
    kdDebug() << m_view->circuitList->viewport()->size() << endl;
    m_view->circuitList-> setPaletteBackgroundPixmap( bg );

    bg = QPixmap(locate("data", "tork/about/america.png"));
    kdDebug() << m_view->serverList->size() << endl;
    kdDebug() << m_view->serverList->viewport()->size() << endl;
    m_view->serverList-> setPaletteBackgroundPixmap( bg );

    bg = QPixmap(locate("data", "tork/about/australia.png"));
    kdDebug() << m_view->ORList->size() << endl;
    kdDebug() << m_view->ORList->viewport()->size() << endl;
    m_view->ORList-> setPaletteBackgroundPixmap( bg );

    kdDebug() << "starting controller" <<endl;
    QString host;
    int port;

    if (TorkConfig::quickConfigure() == 6){ 
        host = TorkConfig::remoteTorAddress();
        port = TorkConfig::remoteTorPort();
    }else if (TorkConfig::quickConfigure() == 7){
        host = "localhost"; 
        port = TorkConfig::remoteTorPort();
    }else{
        host = "localhost";
        port = TorkConfig::controlPort();
    }
    QString caption = QString("%1:%2").arg(host).arg(port);
    client = new Client(host,port);
    setCaption(caption);

    connect( client, SIGNAL(fatalError()),this, SLOT(cannotContactTor()));
    connect( client, SIGNAL(torConnectionClosed()), SLOT(torClosedConnection()) );
    connect( client, SIGNAL(streamStatusUpdate(const QString &, const QString &,
        const QString &, const QString &)),
        m_view,SLOT(streamStatusUpdated(const QString &, const QString &,
        const QString &, const QString &)) );
    connect( client, SIGNAL(ORStatusUpdate(const QString &, const QString &)),
        m_view,SLOT(ORStatusUpdated(const QString &, const QString &)) );
    connect( client, SIGNAL(circuitStatusUpdate(const QString &, const QString &, const QString &)),
        m_view,SLOT(circuitStatusUpdated(const QString &, const QString &, const QString &)) );
    connect( client, SIGNAL(infoUpdate(const QString &,const QString &, const QString &)),
        this,SLOT(infoUpdated(const QString &,const QString &, const QString &)) );
    connect( client, SIGNAL(bwUpdate(const QString &,const QString &)),
        m_view,SLOT(bwUpdated(const QString &,const QString &)) );

    connect( client, SIGNAL(updateActiveServers(const QStringList &)),
        m_view,SLOT(activeServersUpdated(const QStringList &)) );
    connect( client, SIGNAL(updateServerStatus(const QString &,const QString &,const QString &,const QString &, bool)),
        m_view,SLOT(serverStatusUpdated(const QString &,const QString &,const QString &,const QString &, bool)) );

    connect(m_view->circuitList, SIGNAL(attach(const QString &,const QString &)),
            client, SLOT(attemptAttach(const QString &,const QString & )) );
    connect(m_view->circuitList, SIGNAL(extendCircuit(const QString &, const QString &, bool)),
            client, SLOT(attemptExtendCircuit(const QString &, const QString &, bool)) );
    connect(m_view->circuitList, SIGNAL(createCircuit(const QString &, bool)),
            client, SLOT(attemptCreateCircuit(const QString &, bool)) );

	//connect( m_view->serverList, SIGNAL(onItem ( QListViewItem * )),
	//	SLOT(slotOnItem ( QListViewItem * )));
	//connect( m_view->serverList, SIGNAL(onViewport (  )),
	//	SLOT(slotOffItem ( )));

	connect( m_view->serverList, SIGNAL(clicked ( QListViewItem * )),
		SLOT(slotOnItem ( QListViewItem * )));
	connect( m_view->ORList, SIGNAL(clicked ( QListViewItem * )),
		SLOT(slotOnORItem ( QListViewItem * )));


    connect(m_view->m_osd, SIGNAL(closeStream(const QString &)),
            client, SLOT(attemptCloseStream(const QString & )) );
    connect(m_view, SIGNAL(closeStream(const QString &)),
            client, SLOT(attemptCloseStream(const QString & )) );
    connect(m_view, SIGNAL(attachStreams(bool)),
            client, SLOT(attemptAttachStreams( bool )) );

    connect(m_view, SIGNAL(closeCircuit(const QString &)),
            client, SLOT(attemptCloseCircuit(const QString & )) );

    connect(client, SIGNAL(displayError(const QString &, const QString &)),
            m_view, SLOT(displayError(const QString &,const QString & )) );
    connect(client, SIGNAL(displayServer(const QString &, const QString &)),
            m_view, SLOT(displayServer(const QString &,const QString & )) );

    connect(client, SIGNAL(whatImDoing(const QString &)),
            this, SLOT(sayWhatImDoing(const QString & )) );
    connect(client, SIGNAL(copyOldConfig()),
            this, SLOT(copyOldConfig()) );

    connect(client, SIGNAL(shouldIApplySettings()),
            this, SLOT(shouldIApplySettings()) );

    connect(client, SIGNAL(makeTorkStoppable()),
            this, SLOT(makeTorkStoppable()) );

     connect(m_view->streamList, SIGNAL(attach(const QString &,const QString &)),
             client, SLOT(attemptAttach(const QString &,const QString & )) );


    timer = new QTimer( this );
    connect( timer, SIGNAL( timeout() ), this, SLOT( slotUpdateStatus() ) );
    timer->start( 2000, FALSE );

    torkStart->setEnabled(false);

	_tray->setPixmap(KSystemTray::loadIcon("tork_green"));
    getKDESetting();

}

void tork::makeTorkStoppable()
{

    torkStop->setEnabled(true);
    enableKonqi->setEnabled(true);
    browseHiddenServices->setEnabled(true);
    sayWhatImDoing("Ready for use.");
}

void tork::slotUpdateStatus()
{

    switch (m_view->ORList->childCount()) {
            case 0 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_red"));break;
            case 1 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_orange"));break;
            case 2 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_yellow"));break;
            default :
                _tray->setPixmap(KSystemTray::loadIcon("tork_green"));
    }

    switch (m_view->circuitList->childCount()) {
            case 0 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_red"));break;
            case 1 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_orange"));break;
            case 2 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_orange"));break;
            case 3 : 
                _tray->setPixmap(KSystemTray::loadIcon("tork_yellow"));break;
            default :
                _tray->setPixmap(KSystemTray::loadIcon("tork_green"));
    }

    if (!m_serverworking)
        _tray->setPixmap(KSystemTray::loadIcon("tork_yellow"));

    if (m_view->streamList->childCount() == 0)
        m_view->m_osd->hide();

}
void tork::startFromBeginning()
{
    stopController();
    startTor();
}


void tork::receivedOutput(KProcIO *)
{
    int pos;
    QString item2;

    if (!(childproc))
        return;


	while ((childproc) && ((pos = (childproc->readln(item2,true))) != -1)) {
            if ((pos = (item2.find("Opening Control listener on"))) != -1){
                QTimer::singleShot( 200, this, SLOT(startController()) );
                QTimer::singleShot( 10000, this, SLOT(isControllerWorking()) );
            }
            int i;
            for (i = 0; _tork_messages[i].logmessage; ++i) {
                message_t *msg = &_tork_messages[i];
                if (item2.contains(msg->logmessage)){
                    if ((*this.*(msg->pt2Member))()){
                        strncpy(msg->torsaid,item2,249);
                        showWarning(msg->state, msg->headline, item2, msg->body, msg->type);
                    }
                }

            }

            for (i = 0; _tork_questions[i].logquestion; ++i) {
                question_t *msg = &_tork_questions[i];
                if (item2.contains(msg->logquestion)){
                    if ((*this.*(msg->pt2Member2))()){
                        strncpy(msg->torsaid,item2,249);
                        askQuestion(msg->state, msg->headline, msg->torsaid, msg->body, msg->question,msg->pt2Member, msg->type);
                    }
                }

            }


            //kdDebug() << item2 << endl;
            item2 = "";


    }


}

void tork::infoUpdated(const QString &type, const QString &summary, const QString &data)
{

            int i;
            for (i = 0; _tork_messages[i].logmessage; ++i) {
                message_t *msg = &_tork_messages[i];
                if (summary.contains(msg->logmessage)){
                    if ((*this.*(msg->pt2Member))()){
                        strncpy(msg->torsaid,summary,249);
                        showWarning(msg->state, msg->headline, summary, msg->body, msg->type);
                    }
                }

            }

            for (i = 0; _tork_questions[i].logquestion; ++i) {
                question_t *msg = &_tork_questions[i];
                if (summary.contains(msg->logquestion)){
                    if ((*this.*(msg->pt2Member2))()){
                        strncpy(msg->torsaid,summary,249);
                        askQuestion(msg->state, msg->headline, msg->torsaid, msg->body, msg->question,msg->pt2Member, msg->type);
                    }
                }

            }
            m_view->infoUpdated(type,summary,data);
}

bool tork::showUsage()
{
    return TorkConfig::showUsageWarnings();
}

bool tork::showSecurityWarnings()
{
    return TorkConfig::showSecurityWarnings();
}

bool tork::showGuideQuestions()
{
    return TorkConfig::showGuideQuestions();
}

bool tork::showDNSLeaks()
{
    return TorkConfig::showDNSLeaks();
}

bool tork::contactInfoSet()
{
    if ((TorkConfig::showGuideQuestions()) && (TorkConfig::contactInfo().isEmpty()))
        return true;
    return false;
}

void tork::continueAsClient()
{

    TorkConfig::setQuickConfigure(1);
    startFromBeginning();

}

void tork::shouldIApplySettings()
{

    disconnect(client, SIGNAL(shouldIApplySettings()),
            this, SLOT(shouldIApplySettings()) );

    switch (TorkConfig::quickConfigure()) {
        case 0 : 
        case 1 : 
        case 2 : 
        case 3 : 
        case 4 : 
        case 5 :
            break;
        case 6 :
        case 7 :
            if (TorkConfig::applySettingsToInstance()){
                applySettingsToRunningTor();
                return;
            }
            int i;
            for (i = 0; _tork_questions[i].logquestion; ++i) {
                question_t *msg = &_tork_questions[i];
                if ((*this.*(msg->pt2Member2))()){
                    if (QString(msg->logquestion).contains("applysettings")){
                        strncpy(msg->torsaid,i18n("Nothing."),249);
                        askQuestion(msg->state, msg->headline, msg->torsaid, msg->body, msg->question,msg->pt2Member, msg->type);
                    }
                }
            }
            break;
        default:
            break;
    }

    makeTorkStoppable();

}

void tork::applySettingsToRunningTor()
{

    if (client != 0L){
        sayWhatImDoing("Applying settings to Tor..");
        client->applySettingsToRunningTor();
    }
}

void tork::updateTork()
{

    updater = new TorkUpdate(this,false);
    updater->checkForNewTorkDirectly();

}

void tork::updateTorStable()
{

    updater = new TorkUpdate(this,false);
    updater->checkForNewTorDirectly();

}

void tork::updateDante()
{
    #if KDE_VERSION < KDE_MAKE_VERSION(3,5,4)
	KMessageBox::error(this, i18n("<p>Your version of KDE cannot process the Dante tarball.</p><p> Try downloading and installing Dante directly from http://www.mirrors.wiretapped.net/security/firewalls/dante/"), i18n("Version Limitation"));
    return;
    #endif
    updater = new TorkUpdate(this,false);
    updater->checkForNewDanteDirectly();


}

void tork::updateTorUnstable()
{

    updater = new TorkUpdate(this,true);
    updater->checkForNewTorDirectly();

}

void tork::updatePrivoxy()
{

    updater = new TorkUpdate(this,true);
    updater->checkForNewPrivoxyDirectly();

}

void tork::runWizard()
{
        FirstRunWizard wizard;
        wizard.setCaption( i18n( "First-Run Wizard" ));
        wizard.exec();

}


void tork::turnOffKDE()
{
    setKDE(false);
}

void tork::toggleTorBar()
{
    TorkConfig::setShowTorBar(!TorkConfig::showTorBar());

    if (TorkConfig::showTorBar())
        m_view->frame4->show();
    else
        m_view->frame4->hide();
}

void tork::toggleTorMon()
{
    m_view->setShowTormon(!m_view->getShowTormon());
    bool tormon = m_view->getShowTormon();
    TorkConfig::setShowTorMon(tormon);
    if (tormon){
        enableTormon->setIcon("cancel");
        if (m_view->streamList->childCount() == 0)
            m_view->m_osd->hide();
        else
            m_view->m_osd->show();
    }else{
        enableTormon->setIcon("network");
        m_view->m_osd->hide();
    }
}

void tork::hiddenServices()
{

       KURL url = "http://6sxoyfb3h2nvok2d.onion/tor/";
       kapp->invokeBrowser(url.url(), "0");
}

void tork::networkList()
{

       KURL url = "http://serifos.eecs.harvard.edu/cgi-bin/exit.pl";
       kapp->invokeBrowser(url.url(), "0");
}

void tork::toggleKDESetting()
{
    TorkConfig::setKDEUsesTor(!TorkConfig::kDEUsesTor());
    setKDE(TorkConfig::kDEUsesTor());
}

void tork::getKDESetting()
{
    setKDE(TorkConfig::kDEUsesTor());
}

void tork::setKDE(bool set)
{
        kdDebug() << "updating konq" << endl;
        KConfig* config = new KConfig("kioslaverc", false, false);
        config->setGroup( "Proxy Settings" );
        if (set){
            TorkConfig::setOriginalHttpProxy(config->readEntry( "httpProxy" ));
            TorkConfig::setOriginalHttpsProxy(config->readEntry( "httpsProxy" ));
            TorkConfig::setOriginalProxyType(config->readEntry( "ProxyType" ));
            config->writeEntry( "httpProxy", "http://localhost:8118" );
            config->writeEntry( "httpsProxy", "http://localhost:8118" );
            config->writeEntry( "ProxyType", "1" );
            config->sync();
            config = new KConfig("kcookiejarrc", false, false);
            config->setGroup( "Cookie Policy" );
            TorkConfig::setOriginalCookies(config->readEntry( "Cookies" ));
            config->writeEntry( "Cookies", !TorkConfig::disableCookies() );
            config->sync();
            config = new KConfig("kio_httprc", false, false);
            TorkConfig::setOriginalUseCache(config->readEntry( "UseCache" ));
            TorkConfig::setOriginalSendUserAgent(config->readEntry( "SendUserAgent" ));
            config->writeEntry( "UseCache", !TorkConfig::disableCaching() );
            config->writeEntry( "SendUserAgent", !TorkConfig::disableBrowserIdentification() );
            config->sync();
            config = new KConfig("konquerorrc", false, false);
            config->setGroup( "Java/JavaScript Settings" );
            TorkConfig::setOriginalEnableJavascript(config->readEntry( "EnableJavaScript" ));
            TorkConfig::setOriginalEnableJava(config->readEntry( "EnableJava" ));
            TorkConfig::setOriginalEnablePlugins(config->readEntry( "EnablePlugins" ));
            config->writeEntry( "EnableJavaScript", !TorkConfig::disableJava() );
            config->writeEntry( "EnableJava", !TorkConfig::disableJava() );
            config->writeEntry( "EnablePlugins", !TorkConfig::disableJava() );
            config->sync();
        }else{
            config->writeEntry( "httpProxy", TorkConfig::originalHttpProxy() );
            config->writeEntry( "httpsProxy", TorkConfig::originalHttpsProxy() );
            config->writeEntry( "ProxyType", TorkConfig::originalProxyType() );
            config->sync();

            config = new KConfig("kcookiejarrc", false, false);
            config->setGroup( "Cookie Policy" );
            config->writeEntry( "Cookies", TorkConfig::originalCookies() );
            config->sync();

            config = new KConfig("kio_httprc", false, false);
            config->writeEntry( "UseCache", TorkConfig::originalUseCache() );
            config->writeEntry( "SendUserAgent", TorkConfig::originalSendUserAgent() );
            config->sync();

            config = new KConfig("konquerorrc", false, false);
            config->setGroup( "Java/JavaScript Settings" );
            config->writeEntry( "EnableJavaScript", TorkConfig::originalEnableJavascript() );
            config->writeEntry( "EnableJava", TorkConfig::originalEnableJava() );
            config->writeEntry( "EnablePlugins", TorkConfig::originalEnablePlugins() );

        }
        config->sync();

        // Inform all running io-slaves about the changes...
        // if we cannot update, ioslaves inform the end user...
        if (!DCOPRef("*", "KIO::Scheduler").send("reparseSlaveConfiguration", QString::null))
        {
            QString caption = i18n("Update Failed");
            QString message = i18n("You have to restart the running applications "
                                "for these changes to take effect.");
            KMessageBox::information (this, message, caption);
            return;
        }

        if (set)
            enableKonqi->setIcon("tork_konqueroroff");
        else
            enableKonqi->setIcon("tork_konqueroron");

}

QString tork::getPublicIP()
{


    Http http("ipid.shat.net");
    if (http.request("/iponly/")) {
        QString publicip = http.body().replace("Current IP Address:","");
        kdDebug() << publicip << endl;
        if (QHostAddress().setAddress(publicip))
            return publicip;
    }

    return "";
}

void tork::showWarning( display_status_t &msg, const QString &headline,const QString &torsaid,const QString &thismeans, const QString &type)
{

    if (m_list.contains(thismeans))
        return;

    if (m_toolTipShowing){
        msg = DISPLAY_QUEUED;
        return;
    }

    if (!headline.contains("You May Be Leaking DNS Requests!"))
        m_body = thismeans;
    else
        m_body = "";

    m_toolTipShowing = true;
    m_msg = &msg;

    kdDebug() << "type: " << type << endl;

    m_tooltip = new KDE::PopupMessage(statusBar(), m_statusInfo, 40000, type );
    QString text = i18n( "<b>%1</b>").arg(headline);
    text += QString( "<br>" ) + i18n( "<b>Tor said: </b> %1" ).arg(torsaid);
    text += QString( "<br>" ) + i18n( "<b>This means: </b> %1" ).arg(thismeans);
    text += QString( "<br>" );

        //connect(m_tooltip, SIGNAL(yesClicked()),this, SLOT(serverHelp()));

    connect(m_tooltip, SIGNAL(noClicked( )), SLOT(noClicked( )));
    connect(m_tooltip, SIGNAL(Closed( )), SLOT(popUpClosed( )));

    m_tooltip->showOkButton( true );
    m_tooltip->showCounter( true );
    m_tooltip->setMaskEffect( KDE::PopupMessage::Slide );
    m_tooltip->setText( text );

    QString icon = QString("tork_%1").arg(type).replace(" ","_");
    m_tooltip->setImage( DesktopIcon( icon, 32 ) );

    m_tooltip->move( x(), y() + m_tooltip->height() );

    m_tooltip->display();

    if (!kmain->isActiveWindow()){

        KPassivePopup *pop;
    
        QPoint pnt;
        pop = new KPassivePopup( kmain->_tray );
        pnt = kmain->_tray->pos();
        pop->setTimeout(15000);
        pop->setView( i18n("%1").arg(headline),i18n("See TorK window for details.") );
        pop->show(QPoint(pnt));
    }
   
 
}

void tork::askQuestion(display_status_t &msg, const QString &headline,const QString &torsaid,const QString &body,const QString &question,void (tork::*pt2Func)(), const QString &type)
{

    if (m_list.contains(body))
        return;

    if (m_toolTipShowing){
        msg = DISPLAY_QUEUED;
        return;
    }


    m_body = body;
    m_toolTipShowing = true;
    m_msg = &msg;


    kdDebug() << "type: " << type << endl;

    m_pt2Func = pt2Func;
    m_tooltip = new KDE::PopupMessage(statusBar(), m_statusInfo, 40000, type );
    QString text = i18n( "<b>%1</b>").arg(headline);
    text += QString( "<br>" ) + i18n( "<b>Tor said: </b> %1" ).arg(torsaid);
    text += QString( "<br>" ) + i18n( "<b>Reason: </b> %1" ).arg(body);
    text += QString( "<br>" ) + i18n( "%1" ).arg(question);

    //damn. functions pointers can't be used in slots. i don't have the heart to unroll it atm.
    connect(m_tooltip, SIGNAL(yesClicked( )), SLOT(slotHandle( )));
    connect(m_tooltip, SIGNAL(noClicked( )), SLOT(noClicked( )));
    connect(m_tooltip, SIGNAL(Closed( )), SLOT(popUpClosed( )));


    m_tooltip->showBothButton( true );
    m_tooltip->showCounter( true );
    m_tooltip->setMaskEffect( KDE::PopupMessage::Slide );
    m_tooltip->setText( text );
    QString icon = QString("tork_%1").arg(type).replace(" ","_");
    m_tooltip->setImage( DesktopIcon( icon, 32 ) );

    m_tooltip->move( x(), y() + m_tooltip->height() );

    m_tooltip->display();

    if (!kmain->isActiveWindow()){

        KPassivePopup *pop;
    
        QPoint pnt;
        pop = new KPassivePopup( kmain->_tray );
        pnt = kmain->_tray->pos();
        pop->setTimeout(15000);
        pop->setView( i18n("%1").arg(headline),i18n("%1 See TorK window for details.").arg(body) );
        pop->show(QPoint(pnt));
    }
   
 
}


void tork::slotHandle()
{
    (*this.*m_pt2Func)();
    if (!m_body.isEmpty())
        m_list.append( m_body  );
    processQueue( );
}

void tork::noClicked()
{
    if (!m_body.isEmpty())
        m_list.append( m_body  );
    processQueue( );
}


void tork::popUpClosed()
{
    kdDebug() << "popupclosed" << endl;
    processQueue();
}

void tork::processQueue()
{
    if (m_tooltip && (m_tooltip !=0L)){
        //disconnect(m_tooltip, SIGNAL(yesClicked( )),this, SLOT(slotHandle( )));
        //disconnect(m_tooltip, SIGNAL(noClicked( )), this,SLOT(noClicked( )));
    }

    m_toolTipShowing = false;
    *m_msg = DISPLAY_NONE;

    int i;
    for (i = 0; _tork_questions[i].logquestion; ++i) {
         question_t *msg = &_tork_questions[i];
         if (msg->state == DISPLAY_QUEUED){
            askQuestion(msg->state, msg->headline, msg->torsaid, msg->body, msg->question,msg->pt2Member, msg->type);
            return;
         }else
            strcpy(msg->torsaid,"");

     }

    for (i = 0; _tork_messages[i].logmessage; ++i) {
         message_t *msg = &_tork_messages[i];
         if (msg->state == DISPLAY_QUEUED){
            showWarning(msg->state, msg->headline, msg->torsaid, msg->body, msg->type);
            return;
         }else
            strcpy(msg->torsaid,"");
     }


}


void tork::serverHelp()
{

       KURL url = "http://tork.sourceforge.net/wiki/index.php/FAQ#Tor.2FTorK_say_my_server_isn.27t_reachable._What_do_I_do.3F";
       kapp->invokeBrowser(url.url(), "0");

}


void tork::readEavesdropping()
{

       KURL url = "http://tork.sourceforge.net/wiki/index.php/FAQ#Is_Tor_more_secure_than_ordinary_internet_use.3F";
       kapp->invokeBrowser(url.url(), "0");

}

void tork::enterContactInfo()
{

    openConfig("My Server");

}

void tork::cannotContactTor()
{

    stopTor();
    int i;
    for (i = 0; _tork_questions[i].logquestion; ++i) {
        question_t *msg = &_tork_questions[i];
        if (QString(msg->logquestion).contains("cannotcontacttor")){
            strncpy(msg->torsaid,i18n("Nothing. TorK tried to connect to Tor and failed."),249);
            askQuestion(msg->state, msg->headline, msg->torsaid, msg->body, msg->question,msg->pt2Member, msg->type);
        }
    }


}

void tork::torClosedConnection()
{

    stopTor();
    int i;
    for (i = 0; _tork_messages[i].logmessage; ++i) {
        message_t *msg = &_tork_messages[i];
        if (QString(msg->logmessage).contains("torclosedconnection")){
            strncpy(msg->torsaid,i18n("Did something happen to me?"),249);
            showWarning(msg->state, msg->headline, msg->torsaid, msg->body, msg->type);
        }

    }
    return;


}

void tork::quickConfig()
{
    openConfig("Quick Configure");

}

void tork::fixAddressPort()
{
    TorkConfig::setQuickConfigure(7);
    startEverything();

}

void tork::slotOnItem( QListViewItem * item)
{

    if (item == NULL)
        return;
    client->fetchServerInfo(item->text(2));
    m_prevItem = item;

}

void tork::slotOnORItem( QListViewItem * item)
{

    if (item == NULL)
        return;
    client->fetchServerInfoByNick(item->text(1));
    m_prevItem = item;

}

void tork::slotOffItem( )
{

    m_view->hidePopup( );
}

void tork::isControllerWorking( )
{
    if (!client)
        return;

    if (!client->isControllerWorking()){

        int i;
        for (i = 0; _tork_messages[i].logmessage; ++i) {
            message_t *msg = &_tork_messages[i];
            if (QString(msg->logmessage).contains("jdsklajdkslajdskla")){
                strncpy(msg->torsaid,i18n("TorK can't communicate with Tor on the controller port %1. Do you have something limiting/blocking traffic on that port?").arg(TorkConfig::controlPort()),249);
                showWarning(msg->state, msg->headline, msg->torsaid, msg->body, msg->type);
            }

        }
    }

}

void tork::showTip()
{
   KTipDialog::showTip(this,QString::null,true);
}

void tork::showTipOnStart()
{
      KTipDialog::showTip(this);
}


void tork::startNetStat()
{


    netstatproc = new KProcIO();
    netstatproc->setUseShell(TRUE);

    *netstatproc << "netstat -ntucpe";

	connect( netstatproc, SIGNAL(processExited(KProcess *)),
			SLOT(netStatExited()) );
	connect( netstatproc, SIGNAL(readReady(KProcIO *)),
		SLOT(receivedNetStatOutput(KProcIO *)) );

	netstatproc->start(KProcIO::NotifyOnExit)    ;

}

void tork::stopNetStat()
{
    
    if (netstatproc !=0L){
        netstatproc->kill();
        delete netstatproc;
        netstatproc = 0L;
    }

}

void tork::netStatExited()
{

    int status = netstatproc->exitStatus();
    kdDebug() << status << endl;
    delete netstatproc;
    netstatproc = 0L;
}


void tork::receivedNetStatOutput(KProcIO *)
{
    int pos;
    QString item2;

    if (!(netstatproc))
        return;


	while ((netstatproc) && ((pos = (netstatproc->readln(item2,true))) != -1)) {
            QString foreignAddress = item2.mid(44,24);
            QString state = item2.mid(68,11);
            QString inode = item2.mid(90,11);
            QString program = item2.mid(102,19).stripWhiteSpace();
            QListViewItem* nonTorTrafficLine;

            if (inodes.count() > TorkConfig::nonTorTrafficMaxEntries()){
                inodes.clear();
                m_view->NonTorTraffic->clear();

            }
            if (program.isEmpty())
                program = "unknown";

            if  (foreignAddress.contains("*:*"))
                continue;

            if (((item2.left(3).contains("tcp")) || (item2.left(3).contains("udp"))) &&
               (!foreignAddress.contains("127.0.0.1"))){
                QListViewItem* ba = inodes.find( inode );

                if (!ba) {
                    nonTorTrafficLine = new QListViewItem(m_view->NonTorTraffic,QDateTime::currentDateTime().toString(), foreignAddress,program,inode);
                    inodes.insert( inode, nonTorTrafficLine );

                    QString cleanedTarget = foreignAddress.section(":",0,0).stripWhiteSpace();
                    QString cleanedPort = foreignAddress.section(":",1,1).stripWhiteSpace();
                    QString iconPath = locate("cache", KMimeType::favIconForURL("http://"+cleanedTarget)+".png");
                    if (!iconPath.isEmpty()){
                        nonTorTrafficLine->setPixmap( 1, QPixmap( iconPath ) );
                    }else{
                        int i;
                        for (i = 0; _port_icon[i].port; ++i) {
                            portsandicons_t *pics = &_port_icon[i];
                            if (cleanedPort == pics->port){
                                nonTorTrafficLine->setPixmap( 1, SmallIcon(pics->icon) );
                            }
                        }
                    }
                }
            }

            if (program.endsWith("/tor"))
               continue;

            if (item2.left(3).contains("udp")){
                    if ((foreignAddress.contains(":domain")) || (foreignAddress.contains(":53 "))){
                        //kdDebug() << "detected dns request" << endl;
                        if (TorkConfig::kDEUsesTor()){
                            int i;
                            for (i = 0; _tork_messages[i].logmessage; ++i) {
                                message_t *msg = &_tork_messages[i];
                                if (QString(msg->logmessage).contains("dnsrequestsdetected")){
                                    if ((*this.*(msg->pt2Member))()){
                                        strncpy(msg->torsaid,i18n("Although you are directing your web traffic to Tor, the program <b>%1</b> has just bypassed Tor to turn a domain name to an IP address. Traffic from <b>%2</b> is therefore not anonymous.").arg(program).arg(program),249);
                                        showWarning(msg->state, msg->headline, msg->torsaid, msg->body, msg->type);
                                    }
                                }
                            }
                        }
                    }

            }
            //kdDebug() << item2 << endl;
            item2 = "";


    }


}


void tork::showSecurityNotice(const QString& port)
{
    int i;
    for (i = 0; _tork_questions[i].logquestion; ++i) {
        question_t *msg = &_tork_questions[i];
        if ((*this.*(msg->pt2Member2))()){
           if (QString(msg->logquestion).contains("securitynotice")){
                strncpy(msg->torsaid,i18n("Traffic on port %1 is not encrypted. <b> Passwords </b> transmitted on this channel could be harvested by the owner of the exit node.").arg(port),249);
                askQuestion(msg->state, msg->headline, msg->torsaid, msg->body, msg->question,msg->pt2Member, msg->type);
            }
        }

    }

}


void tork::showMyClient()
{
    openConfig("My Client");
}

void tork::showMyServer()
{
    openConfig("My Server");
} 

void tork::showMyNetworkView()
{
    openConfig("My Network View");
} 

void tork::showMyBandwidth()
{
    openConfig("My Bandwidth");
} 

void tork::useNewIdentity()
{
    if (client != 0L)
        client->newIdentity();
} 

void tork::createService(const QString& dir, const QString& port)
{

    if (client != 0L)
        client->createService(dir,port);

} 

 
//-----------------------------





// just in case i ever need it again

/*    int i;

    bool (*pt2Member)();


    for (i = 0; _tor_config[i].configvalue; ++i) {
        config_t *conf = &_tor_config[i];

        //If the group condition isn't met skip to the next config value
        if (conf->groupcondition != NULL)
            //pt2Member = conf->groupcondition;
            pt2Member = &TorkConfig::defaultMaxMinOptions;
            if (!(*pt2Member)()) continue;
*/
/*        switch (conf->type) {
            case CONFIG_TYPE_STRING: 
                if (!torkconf.*(conf->configvalue)()).isEmpty()
                    ( ts << conf->text << " " << (torkconf.*(conf->configvalue)()) << conf->suffix << "\n"); 
                break;
            case CONFIG_TYPE_UINT: 
                if (torkconf.*(conf->configvalue)() > 0)
                    ( ts << conf->text << " " << (torkconf.*(conf->configvalue)()) << conf->suffix << "\n"); 
                break;

            case CONFIG_TYPE_BOOL: 
                if (torkconf.*(conf->configvalue)())
                    ( ts << conf->text << " " << (torkconf.*(conf->configvalue)()) << conf->suffix << "\n"); 
                break;

            case CONFIG_TYPE_LINELIST: 
                if ((!torkconf.*(conf->configvalue)()).isEmpty()){
                    QString linelist;
                    for ( QStringList::Iterator it = (torkconf.*(conf->configvalue)()).begin(); it != (torkconf.*(conf->configvalue)()).end(); ++it )
                    {
                        if ((*it).isEmpty())
                            continue;
                        linelist.append((*it));
                    }

                    ( ts << conf->text << " " << linelist << conf->suffix << "\n"); 
                }
                break;

            case CONFIG_TYPE_DUO: 
                if (((!torkconf.*(conf->configvalue)()).isEmpty()) && ((!torkconf.*(conf->configvaluetwo)()).isEmpty()))

                    ( ts << conf->text << " " << (torkconf.*(conf->configvalue)()) 
                      << conf->suffix << (torkconf.*(conf->configvaluetwo)())  << "\n"); 
                break;

            default:
            case CONFIG_TYPE_OBSOLETE:
            type = NULL; break;*/
//         }



//     }




#include "tork.moc"

