/***************************************************************************
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _TORK_H_
#define _TORK_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <ktempfile.h>

#include "torkview.h"
#include "torclient.h"
#include "statgraph.h"
#include "popupMessage.h"
#include "torkconfig.h"
#include "version.h"
#include <kconfigskeleton.h>
#include "update.h"

class KPrinter;
class KToggleAction;
class KURL;
class KSystemTray;
class QLabel;
class KProcIO;
class Client;
class QPoint;
class StatGraph;
class TorkConfig;
class KConfigSkeleton;
class KConfigSkeletonItem;
class KTempFile;


/** Enumeration of types which option values can take */
typedef enum display_status_t {
  DISPLAY_NONE = 0,   /**< An arbitrary string. */
  DISPLAY_QUEUED,         /**< A non-negative integer less than MAX_INT */
} display_status_t;




/**
 * This class serves as the main window for tork.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Robert Hogan <robert@roberthogan.net>
 * @version 0.03
 */
class tork : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    tork();

    /**
     * Default Destructor
     */
    virtual ~tork();

    KSystemTray *_tray;
    torkView *m_view;
    QDict<QListViewItem> inodes;
    bool connectedToTor(){return (client!=0) ? true : false;};

private slots:
    void fileNew();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
    void startTor();
    void stopTor();
    void startNetStat();
    void stopNetStat();
    void updateTorUnstable(); 
    void updatePrivoxy();
    void updateDante();
    void childExited();
    void privoxyExited();
    void netStatExited();
    void startFromBeginning();
    void isControllerWorking( );
    
    void changeStatusbar(const QString& in,const QString& out);
    void changeCaption(const QString& text);
    void startController();
    void stopController();
    void startEverything();
    void startPrivoxy();
    void receivedOutput(KProcIO *);
    void receivedNetStatOutput(KProcIO *);
    void slotUpdateStatus();
    void toggleKDESetting();
    void getKDESetting();
    void setKDE(bool set);
    void turnOffKDE();
    void sayWhatImDoing(const QString& );
    void slotOnItem( QListViewItem * );
    void slotOnORItem( QListViewItem * );
    void slotOffItem( );
    void openConfig(const QCString& page);

    void slotHandle(/*TFunctor *functor*/);
    void noClicked(/*TFunctor *functor*/);
    void popUpClosed();
    void processHashProc(KProcIO *hashproc);
    void toggleTorMon();
    void toggleTorBar();
    void hiddenServices();
    void networkList();
    void infoUpdated(const QString &type, const QString &summary, const QString &data);

    void showMyClient();
    void showMyServer();
    void showMyNetworkView();
    void showMyBandwidth();
    void useNewIdentity();


public slots:

    void serverHelp(); 
    void enterContactInfo();
    void fixAddressPort();
    void continueAsClient();
    void updateTorStable();
    void updateTork();
    void quickConfig();
    void cannotContactTor();
    void showTip();
    void showTipOnStart();
    void runWizard(); 
    void copyOldConfig();
    void shouldIApplySettings();
    void applySettingsToRunningTor();
    bool showUsage();
    bool showSecurityWarnings();
    bool showGuideQuestions();
    bool contactInfoSet();
    bool showDNSLeaks();
    void readEavesdropping();
    void showSecurityNotice(const QString &port);
    void torClosedConnection();
    void makeTorkStoppable();
    void createService(const QString& dir,const QString& port);

private:
    void setupAccel();
    void setupActions();
    QString writeConf();
    QString writePrivoxyConf();
    void writeCustomOptions(QTextStream &ts);
    void writeCustomOptions2(QTextStream &ts);
    QString getPublicIP();
    void showWarning( display_status_t &msg, const QString &headline,const QString &torsaid,const QString &thismeans, const QString &type);
    void askQuestion(display_status_t &msg, const QString &headline,const QString &torsaid,const QString &body,const QString &question,void (tork::*pt2Func)(), const QString &type);
    void processQueue();
    bool elementShouldBeUsed(const KConfigSkeletonItem* it);
    bool noSpecialProcessing(const KConfigSkeletonItem* it, QTextStream &ts);
    QString doHashPassword();
    bool queryClose();
    void prepareToShut();
private:
    KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KAction *torkConfigure;
    KAction *torkStop;
    KAction *torkStart;
    KAction *torkUpdateTork;
    KAction *torkUpdateStable;
    KAction *torkUpdateUnstable;
    KAction *torkUpdatePrivoxy;
    KAction *torkUpdateDante;
    KAction *torkFirstRunWizard;
    KAction *torkTip;
    KAction *enableKonqi;
    KAction *enableTormon;
    KAction *browseHiddenServices;
    KAction *browseNetworkList;
    KAction *toggleTorbar;
	QLabel* m_statusInfo;
	QLabel* m_statusTransfer;
	QLabel* m_statusSpeed;
	StatGraph* m_graphIn;
	StatGraph* m_graphOut;
    KProcIO* childproc;
    KProcIO* netstatproc;
    KProcIO* privoxyproc;
    Client* client;
    bool m_servererrornag;
    bool m_contactinfonag;
    bool m_serverworking;
    QListViewItem* m_prevItem;
    QTimer *timer;
    void (tork::*m_pt2Func)();
    bool m_toolTipShowing;
    KDE::PopupMessage *m_tooltip;
    QStringList m_list;
    QString m_body;
    display_status_t* m_msg;
    KProcIO *hashproc;
    QString m_hashedpassword;
    KConfigSkeletonItem::List previtems;
    KConfigSkeleton pcopy;
    PrevConfig::PrevConfigList prevlist;
    TorkUpdate* updater;
    KTempFile* tfTor;
    KTempFile* tfPrivoxy;

};


extern tork *kmain;

#endif // _TORK_H_

