/***************************************************************************
** $Id: torkview.cpp,v 1.42 2006/10/21 13:46:08 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "torkview.h"
#include "tork.h"
#include "torclient.h"
#include <klocale.h>
#include <qlabel.h>
#include <qlistview.h>
#include "dndlistview.h"
#include "portsandicons.h"
#include "torkconfig.h"

#ifdef HAVE_GEOIP_H
# include <GeoIP.h>
#else
# include "GeoIP-1.4.0/libGeoIP/GeoIP.h"
#endif

#include "kdebug.h"
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kmimetype.h>
#include <ksystemtray.h>

#include <qsplitter.h>
#include <qgroupbox.h>

torkView::torkView(QWidget *parent)
    : torkview_base(parent), pop(0L), m_tormon(TorkConfig::showTorMon())
{

    if (!TorkConfig::showTorBar())
        frame4->hide();

	settingsChanged();
    m_osd = new StreamOSD(this );
    m_osd->readSettings(KGlobal::config());

}

torkView::~torkView()
{

}

void torkView::streamStatusUpdated(const QString &streamID, const QString &status,
        const QString &circID, const QString &Target)
{

    m_osd->setShown(m_tormon);

//    kdDebug() << "status update: " << Target << endl;
    streamItem* streamline;
    QListViewItem* osdstreamline;
    QListViewItem* torTrafficLine;
    QString cleanedTarget = Target.section(":",0,0);
    QString cleanedPort = Target.section(":",1,1);
    

    if ((streamline = (streamItem*)streamList->findItem(streamID,0)) == 0){
        if (!(status == "CLOSED") && !(status == "FAILED")){
            
            //log entry
            torTrafficLine = new QListViewItem(TorTraffic, streamID, QDateTime::currentDateTime ().toString(), Target);


            streamline = new streamItem(streamList, streamID, Target,"",circID);
            osdstreamline = new QListViewItem(m_osd->infoList,streamID, Target,"",circID);

            streamItem* circuitline;
            if ((circuitline = (streamItem*) circuitList->findItem(circID,0)) == 0){
                streamline->setText(4,circID);
                torTrafficLine->setText(3,circID);
                if (osdstreamline) osdstreamline->setText(3,circID);
            }else{

                QString exit = circuitline->text(2).section( ',', -1 );
                QListViewItem* serverline;
                if ((serverline = (QListViewItem*) serverList->findItem(exit,1)) != 0){
                    streamline->setText(3,serverline->text(1));
                    streamline->setPixmap( 3, *serverline->pixmap(1) );
                    if (osdstreamline){
                        osdstreamline->setText(3,serverline->text(1));
                        osdstreamline->setPixmap( 3, *serverline->pixmap(1) );
                    }
                }

                streamline->setText(4,circuitline->text(2));
                torTrafficLine->setText(3,circuitline->text(2));
                
            }

            QString iconPath = locate("cache", KMimeType::favIconForURL("http://"+cleanedTarget)+".png");
            if (!iconPath.isEmpty()){
                streamline->setPixmap( 1, QPixmap( iconPath ) );
                osdstreamline->setPixmap( 1, QPixmap( iconPath ) );
                torTrafficLine->setPixmap( 2, QPixmap( iconPath ) );
            }else{
                int i;
                for (i = 0; _port_icon[i].port; ++i) {
                    portsandicons_t *pics = &_port_icon[i];
                    if (cleanedPort == pics->port){
                        streamline->setPixmap( 1, SmallIcon(pics->icon) );
                        osdstreamline->setPixmap( 1, SmallIcon(pics->icon) );
                        torTrafficLine->setPixmap( 2, SmallIcon(pics->icon) );
                        if ((!pics->secure) && (!pics->display)){
                            pics->display = DONT_DISPLAY_AGAIN;
                            emit showSecurityNotice(cleanedPort);
                        }
                    }
                }
            }

            streamline->setDragEnabled(true);
            streamline->setDropEnabled(true);
            streamline->setPixmap(2,QPixmap(SmallIcon("tork_"+status.stripWhiteSpace())));
            osdstreamline->setPixmap(2,QPixmap(SmallIcon("tork_"+status.stripWhiteSpace())));


        }
    }else{
        torTrafficLine = (QListViewItem*)TorTraffic->findItem(streamID,0);
        osdstreamline = (QListViewItem*)m_osd->infoList->findItem(streamID,0);
        streamline->setPixmap(2,QPixmap(SmallIcon("tork_"+status)));
        if (osdstreamline) osdstreamline->setPixmap(2,QPixmap(SmallIcon("tork_"+status)));

        streamItem* circuitline;
        if ((circuitline = (streamItem*) circuitList->findItem(circID,0)) == 0){
            streamline->setText(4,circID);
            if (osdstreamline) osdstreamline->setText(3,circID);
            if ((torTrafficLine) && (circID != "0")) torTrafficLine->setText(3,circID);
        }else{
            QString exit = circuitline->text(2).section( ',', -1 );
            QListViewItem* serverline;
            if ((serverline = (QListViewItem*) serverList->findItem(exit,1)) != 0){
                streamline->setText(3,serverline->text(1));
                //QPixmap pix = *serverline->pixmap(1);
                streamline->setPixmap( 3, *serverline->pixmap(1) );
                if (osdstreamline){
                    osdstreamline->setText(3,serverline->text(1));
                    osdstreamline->setPixmap( 3, *serverline->pixmap(1) );
                }

            }


            streamline->setText(4,circuitline->text(2));
            if (torTrafficLine) torTrafficLine->setText(3,circuitline->text(2));
        }


        if (status == "CLOSED"){
            delete streamline;
            if (osdstreamline) delete osdstreamline;
        }
    }

}

void torkView::circuitStatusUpdated(const QString &circuitID, const QString &status, const QString &server)
{


    circuitItem* circuitline;
    if ((circuitline = (circuitItem*)circuitList->findItem(circuitID,0)) == 0){
        if (!(status == "CLOSED") && !(status == "FAILED")){
            circuitline = new circuitItem(circuitList, circuitID, "",server);
            circuitline->setDragEnabled(true);
            circuitline->setDropEnabled(true);
            circuitline->setPixmap(1,QPixmap(SmallIcon("tork_"+status)));

            //connect( circuitline, SIGNAL(itemDropped( QDropEvent*)),SLOT(attemptAttach( QDropEvent* )) );
        }
    }else{
        circuitline->setPixmap(1,QPixmap(SmallIcon("tork_"+status)));
        circuitline->setText(2,server);
        if ((status == "CLOSED") || (status == "FAILED"))
            delete circuitline;

    }

}


void torkView::ORStatusUpdated(const QString &ORID, const QString &status)
{

    QString tmpstatus = status;
/*    kdDebug() << status << endl;
    kdDebug() << ORID << endl;*/
    if (tmpstatus.contains("CONNECTED"))
        tmpstatus = "BUILT";


    QListViewItem* ORline = ORList->findItem(ORID,1);
    if (ORline == 0){

        if ((tmpstatus.stripWhiteSpace() == "CLOSED") || (tmpstatus.stripWhiteSpace() == "FAILED"))
            return;
        ORline = new QListViewItem(ORList, "", ORID);
        if ((tmpstatus.contains("up")) || (tmpstatus.contains("down")) 
            || (tmpstatus.contains("never-connected")) || (tmpstatus.contains("unusable")))
            ORline->setPixmap(0,QPixmap(SmallIcon("tork_guard_"+tmpstatus.replace("-",""))));
        else
            ORline->setPixmap(0,QPixmap(SmallIcon("tork_"+tmpstatus)));

    }else if (ORline > 0){
 
       if ((tmpstatus.contains("up")) || (tmpstatus.contains("down")) 
            || (tmpstatus.contains("never-connected"))|| (tmpstatus.contains("unusable")))
            ORline->setPixmap(0,QPixmap(SmallIcon("tork_guard_"+tmpstatus.replace("-",""))));
        else
            ORline->setPixmap(0,QPixmap(SmallIcon("tork_"+tmpstatus)));

        if ((tmpstatus.stripWhiteSpace() == "CLOSED") || (tmpstatus.stripWhiteSpace() == "FAILED"))
            delete ORline;

    }

}

void torkView::infoUpdated(const QString &type, const QString &summary, const QString &data)
{

    new QListViewItem(infoList, QDateTime::currentDateTime ().toString(Qt::ISODate).replace("T"," "), type, summary);

}

void torkView::bwUpdated(const QString &in, const QString &out)
{

    emit signalChangeStatusbar( in, out );

}

void torkView::activeServersUpdated( const QStringList &servers)
{
    kdDebug() << "active servers updated" << endl;
    QListViewItem* tm;
    QStringList tmpservers = servers;
	for ( QStringList::Iterator it = tmpservers.begin(); it != tmpservers.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        if ( tm = serverList->findItem((*it),1))
            tm->setPixmap(0,QPixmap(SmallIcon("tork_green")));
        else{
            tm = new QListViewItem(serverList, (*it));
            tm->setPixmap(0,QPixmap(SmallIcon("tork_green")));
        }
	}

}

void torkView::serverStatusUpdated(const QString &ip,const QString &fp, const QString &server,const QString &statuses, bool update )
{
    QListViewItem* tm;
    
    if (update){
        if (!( tm = serverList->findItem((fp),2)))
            tm = new QListViewItem(serverList, "", (server), fp);
    }else{

        tm = new QListViewItem(serverList, "", (server), fp);
        //tm->setPixmap(1,QPixmap(SmallIcon(locate( "locale",
        //                        QString::fromLatin1( "l10n/%1/flag.png" ).arg(cc).lower()))));
    }

    GeoIP * gi;
    int country_id = 0;
    gi = GeoIP_new(GEOIP_STANDARD);
    country_id = GeoIP_id_by_name(gi, ip);
    QString cc = GeoIP_country_code[country_id];
/*    QString cc = GeoIP_country_code_by_name(gi, ip);*/
    GeoIP_delete(gi);
    tm->setPixmap(1,QPixmap(SmallIcon("tork_" + cc.lower())));


    if ((statuses.contains("Stable")) && (statuses.contains("Running")) && (statuses.contains("Fast")))
        tm->setPixmap(0,QPixmap(SmallIcon("tork_green")));
    else if ((statuses.contains("Stable")) && (statuses.contains("Running")))
        tm->setPixmap(0,QPixmap(SmallIcon("tork_yellow")));
    else if ((statuses.contains("Running")))
        tm->setPixmap(0,QPixmap(SmallIcon("tork_orange")));
    else if ((statuses.contains("Valid")))
        tm->setPixmap(0,QPixmap(SmallIcon("tork_red")));

    if ((statuses.contains("Exit"))){
        if (!TorkConfig::TorkConfig::serversHistory().contains(QString("%1-%2-%3").arg(country_id).arg(fp).arg(server))){
            QStringList existingServers = TorkConfig::serversHistory();
            existingServers.append(QString("%1-%2-%3").arg(country_id).arg(fp).arg(server));
            TorkConfig::setServersHistory(existingServers);
        }
    }
}

void torkView::switchColors()
{
	// switch the foreground/background colors of the label
/*	QColor color = Settings::col_background();
	Settings::setCol_background( Settings::col_foreground() );
	Settings::setCol_foreground( color );
*/
	settingsChanged();
}

void torkView::settingsChanged()
{
/*	sillyLabel->setPaletteBackgroundColor( Settings::col_background() );
	sillyLabel->setPaletteForegroundColor( Settings::col_foreground() );

	// i18n : internationalization
	sillyLabel->setText( i18n("This project is %1 days old").arg(Settings::val_time()) );
	emit signalChangeStatusbar( i18n("Settings changed") );*/
}

void torkView::displayError( const QString &caption, const QString &infol)
{

    if (!circuitList->recentDropEvent())
        return;
    QString info = infol;;
    info.replace(QRegExp("(\\$[A-Z0-9]{40})(~|=)"),"");
    if (pop != 0L)
        pop->hide();

    QPoint pnt;
    if (kmain->isActiveWindow()){
        pop = new KPassivePopup( kmain );
        pnt = kmain->pos() += kmain->m_view->pos() += kmain->m_view->circuitList->pos() +=
                kmain->m_view->circuitList->getMousePos() += kmain->m_view->splitter3->pos() += 
                kmain->m_view->splitter4->pos() += kmain->m_view->groupBox1->pos();
    }else{
        pop = new KPassivePopup( kmain->_tray );
        pnt = kmain->_tray->pos();
    }
    pop->setView( caption,info );
    pop->show(QPoint(pnt));

}

void torkView::displayServer( const QString &caption, const QString &info)
{


    if (pop != 0L)
        pop->hide();

    QPoint pnt;
    if (kmain->isActiveWindow()){
        pop = new KPassivePopup( serverList );
        //pnt = kmain->pos()  -= kmain->m_view->serverList->getMousePos() -= kmain->m_view->serverList->getMousePos() -= kmain->m_view->serverList->getMousePos();
    }else{
        pop = new KPassivePopup( kmain->_tray );
        pnt = kmain->_tray->pos();
    }
    pop->setView( caption,info );
    //pop->show(QPoint(pnt));
    pop->show();

}

void torkView::hidePopup( )
{

    if (pop != 0L)
        pop->hide();

}

circuitItem::circuitItem( DndListView *parent, const QString &id, const QString &status, const QString &server )
    : QListViewItem(  parent, id, status, server)
{
}

// void circuitItem::dragEntered( )
// {
//     kdDebug() << "item drag enter event" << endl;
//     this->setSelected(true);
// }
// 
// 
// void circuitItem::dropped( QDropEvent *evt )
// {
//     QString text;
//     kdDebug() << "item receiving drop" << endl;
//     if ( QTextDrag::decode( evt, text ) ) 
// 	   kdDebug() << text << endl;
// }
// 
// bool circuitItem::acceptDrop( const QMimeSource *mime ) const
// {
// //    if ( mime->provides( "text/plain" ) )
//     kdDebug() << "accepting drop" << endl;
//     return TRUE;
// //    return FALSE;
// }

streamItem::streamItem( DndListView *parent, const QString &id, const QString &target, const QString &status, const QString &circuit )
    : QListViewItem(  parent, id, target, status, circuit)
{
/*    setDragEnabled(true);
    setDropEnabled(true);*/
}


#include "torkview.moc"

