/***************************************************************************
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _TORKVIEW_H_
#define _TORKVIEW_H_

#include <qwidget.h>

#include "torkview_base.h"
#include <qlistview.h>
#include <qdragobject.h>
#include <qiconview.h>
#include <kpassivepopup.h>
#include "newstreamosd.h"

class QPainter;
class KURL;
class QListViewItem;
class QDragEnterEvent;
class QDragDropEvent;
class KPassivePopup;
class StreamOSD;
/**
 * This is the main view class for tork.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Robert Hogan <robert@roberthogan.net>
 * @version 0.1
 */
class torkView : public torkview_base
{
    Q_OBJECT
public:
	/**
	 * Default constructor
	 */
    torkView(QWidget *parent);

	/**
	 * Destructor
	 */
    virtual ~torkView();

    void hidePopup();
    bool getShowTormon() {return m_tormon;}
    void setShowTormon(bool tormon) { m_tormon = tormon;}
    void infoUpdated(const QString &type, const QString &summary, const QString &data);
    StreamOSD* m_osd;
signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& in, const QString& out );

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);
    void showSecurityNotice(const QString& cleanedPort);

private slots:
    void switchColors();
    void settingsChanged();
    void streamStatusUpdated(const QString &, const QString &, const QString &, const QString &);
    void circuitStatusUpdated(const QString &, const QString &, const QString &);
    void ORStatusUpdated(const QString &ORID, const QString &status);
    void bwUpdated(const QString &in, const QString &out);
    void activeServersUpdated(const QStringList &servers);
    void displayError(const QString &,const QString &);
    void displayServer(const QString &,const QString &);
    void serverStatusUpdated(const QString &, const QString &,const QString &,const QString &, bool );

private:

    KPassivePopup *pop;
    bool m_tormon;
};

class streamItem : public QObject, public QListViewItem
{
Q_OBJECT

public:
    streamItem( DndListView *parent, const QString &id, const QString &target, const QString &status, const QString &circuit );


private:


    bool dragging;

};

class circuitItem : public QObject, public QListViewItem
{
Q_OBJECT

public:
    circuitItem( DndListView *parent, const QString &id, const QString &status, const QString &server );

//     bool acceptDrop( const QMimeSource *mime ) const;
//     void dropped ( QDropEvent * e );
//     void dragEntered( );


};


#endif // _TORKVIEW_H_
