/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kdebug.h>

#include <kapplication.h>
#include <kiconloader.h>

#include "torkconfig.h"
#include "tork.h"

bool m_LeaveStreamsUnattached;
KActiveLabel* thislabel;

void torkview_base::init()
{

    serverList->addColumn( kapp->iconLoader()->loadIconSet("tork_torsmall", KIcon::Small),"", 24 );
    serverList->addColumn( "Server" );
    serverList->addColumn( "FP" );
    serverList->setSelectionMode( QListView::Extended );
    serverList->setColumnWidthMode(2, QListView::Manual);
    serverList->hideColumn(2);
    serverList->header()->setResizeEnabled(FALSE, 1);
    serverList->setResizeMode( QListView::NoColumn );
    serverList->setHScrollBarMode(QScrollView::AlwaysOff);

//     QListViewItem *tm;
//     QStringList servers = TorkConfig::serversHistory();
// 	for ( QStringList::Iterator it = servers.begin(); it != servers.end(); ++it )
// 	{
// 
// 		if ((*it).isEmpty())
// 			continue;
//         tm = new QListViewItem(serverList,*it);
// 	}

    streamList->addColumn( "ID" );
    streamList->addColumn(  "Host/Port"  );
    streamList->addColumn(  "Status"  );
    streamList->addColumn(  "Exit"  );
    streamList->addColumn(  "Circuit"  );
    
    streamList->setSelectionMode( QListView::Extended );
    streamList->setColumnWidthMode(0, QListView::Manual);
    streamList->hideColumn(0);
    streamList->header()->setResizeEnabled(FALSE, 0);
    streamList->setResizeMode( QListView::NoColumn );

    circuitList->addColumn( tr2i18n( "ID" ) );
    circuitList->addColumn( kapp->iconLoader()->loadIconSet("tork_torsmall", KIcon::Small),"", 24 );
    circuitList->addColumn( tr2i18n( "Path" ) );
    circuitList->setSelectionMode( QListView::Single );
    circuitList->setColumnWidthMode(0, QListView::Manual);
    circuitList->hideColumn(0);
    circuitList->header()->setResizeEnabled(FALSE, 0);
    circuitList->setResizeMode( QListView::LastColumn );


    ORList->addColumn( kapp->iconLoader()->loadIconSet("tork_torsmall", KIcon::Small),"", 24 );
    ORList->addColumn( tr2i18n( "Server" ) );
    ORList->setSelectionMode( QListView::Extended );
    ORList->setColumnWidthMode(0, QListView::Manual);
    ORList->setResizeMode( QListView::LastColumn );

    TorTraffic->setColumnWidthMode(0, QListView::Manual);
    TorTraffic->hideColumn(0);
    TorTraffic->header()->setResizeEnabled(FALSE, 0);
    TorTraffic->setResizeMode( QListView::NoColumn );
    m_LeaveStreamsUnattached = false;
}


void torkview_base::streamList_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( streamList );

    menu->clear();

    if (streamList->childCount() > 0)
        menu->insertItem( "Close Connection", this,SLOT(slotCloseStream()) );
    if (!m_LeaveStreamsUnattached)
        menu->insertItem( "Let Me Drag Connections To Circuits Myself", this,SLOT(slotAttachStreams()) );
    else
        menu->insertItem( "Attach Connections To Circuits Automatically", this,SLOT(slotAttachStreams()) );

    menu->popup( point );

}


void torkview_base::slotAttachStreams( )
{

    m_LeaveStreamsUnattached = !m_LeaveStreamsUnattached;
    emit attachStreams(m_LeaveStreamsUnattached);
}
void torkview_base::slotCloseStream( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(streamList, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (streamList->isSelected( it.current()))
            emit closeStream(it.current()->text(0));
        ++it;
    }


}

void torkview_base::circuitList_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( circuitList );

    menu->clear();
    menu->insertItem( "Close Circuit", this,SLOT(slotCloseCircuit()) );
    menu->popup( point );

}


void torkview_base::slotCloseCircuit( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(circuitList, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (circuitList->isSelected( it.current()))
            emit closeCircuit(it.current()->text(0));
        ++it;
    }


}


void torkview_base::clearInfo_clicked()
{
    infoList->clear();
}


void torkview_base::clearTorTraffic_clicked()
{
    TorTraffic->clear();
}


void torkview_base::clearNonTorTraffic_clicked()
{

    NonTorTraffic->clear();

}

void torkview_base::NonTorTrafficMaxEntries_valueChanged( int newval)
{

    TorkConfig::setNonTorTrafficMaxEntries(newval);

}

void torkview_base::confMyClient_clicked( int, int )
{

    emit showMyClient();
}


void torkview_base::confMyServer_clicked( int, int )
{
    emit showMyServer();
}


void torkview_base::confMyNetworkView_clicked( int, int )
{

    emit showMyNetworkView();
}


void torkview_base::confMyBandwidth_clicked( int, int )
{

    emit showMyBandwidth();
}


void torkview_base::useMiniView_clicked( int, int )
{

    emit miniView();
}


void torkview_base::useNewIdentity_clicked( int, int )
{

    emit newIdentity();
}


void torkview_base::useKonqWithTor_clicked( int, int )
{

    emit konqWithTor();
}


void torkview_base::viewNetworkList_clicked( int, int )
{

    emit networkList();
}


void torkview_base::viewHiddenServices_clicked( int, int )
{

    emit hiddenServices();
}


// <connections>
//     <connection>
//         <sender>clearInfo</sender>
//         <signal>clicked()</signal>
//         <receiver>torkview_base</receiver>
//         <slot>clearInfo_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>clearTorTraffic</sender>
//         <signal>clicked()</signal>
//         <receiver>torkview_base</receiver>
//         <slot>clearTorTraffic_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>clearNonTorTraffic</sender>
//         <signal>clicked()</signal>
//         <receiver>torkview_base</receiver>
//         <slot>clearNonTorTraffic_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>streamList</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>torkview_base</receiver>
//         <slot>streamList_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>circuitList</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>torkview_base</receiver>
//         <slot>circuitList_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">torkview_base.ui.h</include>
// </includes>
// <signals>
//     <signal>closeStream(const QString &amp;)</signal>
//     <signal>closeCircuit(const QString &amp;)</signal>
//     <signal>attachStreams(bool)</signal>
// </signals>
// <slots>
//     <slot>streamList_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotCloseStream()</slot>
//     <slot>slotAttachStreams()</slot>
//     <slot>circuitList_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotCloseCircuit()</slot>
//     <slot>clearInfo_clicked()</slot>
//     <slot>clearTorTraffic_clicked()</slot>
//     <slot>clearNonTorTraffic_clicked()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// <includehints>
//     <includehint>dndlistview.h</includehint>
// </includehints>
// </UI>








/*
    <connection>
        <sender>streamList</sender>
        <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
        <receiver>torkview_base</receiver>
        <slot>streamList_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
    </connection>
    <connection>
        <sender>circuitList</sender>
        <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
        <receiver>torkview_base</receiver>
        <slot>circuitList_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
    </connection>*/


