/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include "torkconfig.h"
#include "crypto.h"
#include <klocale.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kdebug.h>
#include <kiconloader.h>

#ifdef HAVE_GEOIP_H
# include <GeoIP.h>
#else
# include "GeoIP-1.4.0/libGeoIP/GeoIP.h"
#endif

typedef QMap<QString, QString> codemap;
QString ccode;
QString cname;
codemap ccodes;
QStringList blockCCs;

void TorServers::init()
{
    
    ExcludeNodes->setSelectionMode( QListView::Extended );
    ExcludeNodes->setColumnWidthMode(0, QListView::Manual);
    ExcludeNodes->hideColumn(0);
    ExcludeNodes->header()->setResizeEnabled(FALSE, 0);
    ExcludeNodes->setColumnWidthMode(1, QListView::Manual);
    ExcludeNodes->hideColumn(1);
    ExcludeNodes->header()->setResizeEnabled(FALSE, 1);
    ExcludeNodes->setResizeMode( QListView::LastColumn );

    ExitNodes->setSelectionMode( QListView::Extended );
    ExitNodes->setColumnWidthMode(0, QListView::Manual);
    ExitNodes->hideColumn(0);
    ExitNodes->header()->setResizeEnabled(FALSE, 0);
    ExitNodes->setColumnWidthMode(1, QListView::Manual);
    ExitNodes->hideColumn(1);
    ExitNodes->header()->setResizeEnabled(FALSE, 1);
    ExitNodes->setResizeMode( QListView::LastColumn );

    QStringList existingServers = TorkConfig::serversHistory();
    QListViewItem *tm;
    int cc;
    QString fp;
    QString nick;
	for ( QStringList::Iterator it = existingServers.begin(); it != existingServers.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;

        fp.setLength(0);
        nick.setLength(0);
        cc = (*it).section("-",0,0).toInt();
        fp = (*it).section("-",1,1);
        nick = (*it).section("-",2);

        if ( cc >= sizeof(GeoIP_country_name)/sizeof(GeoIP_country_name[0]) )
           continue;
        
        tm = new QListViewItem(ExcludeNodes,GeoIP_country_name[cc],fp,nick);
        tm->setPixmap(2,QPixmap(SmallIcon("tork_" + QString(GeoIP_country_code[cc]).lower())));
        if ((TorkConfig::excludeNodes().contains("$"+getFPFromFPDigest(fp))) ||
            (TorkConfig::excludeCountries().contains(GeoIP_country_code[cc])))
            ExcludeNodes->setSelected(tm,true);

        QString countryName = GeoIP_country_name[cc];
        if (CountryList->findItem(countryName) == 0){
            CountryList->insertItem(countryName);
            cname = QString(GeoIP_country_name[cc]);
            ccode = QString(GeoIP_country_code[cc]);
            ccodes[cname] = ccode;
            if (TorkConfig::excludeCountries().contains(GeoIP_country_code[cc]))
                CountryList->setSelected(CountryList->findItem(countryName),true);
        }

        tm = new QListViewItem(ExitNodes,GeoIP_country_name[cc],fp,nick);
        tm->setPixmap(2,QPixmap(SmallIcon("tork_" + QString(GeoIP_country_code[cc]).lower())));
        if ((TorkConfig::exitNodes().contains("$"+getFPFromFPDigest(fp))) ||
           (TorkConfig::preferredCountries().contains(GeoIP_country_code[cc])))
            ExitNodes->setSelected(tm,true);

        if (PreferredCountryList->findItem(countryName) == 0){
            PreferredCountryList->insertItem(countryName);
            cname = QString(GeoIP_country_name[cc]);
            ccode = QString(GeoIP_country_code[cc]);
            ccodes[cname] = ccode;
            if (TorkConfig::preferredCountries().contains(GeoIP_country_code[cc]))
                PreferredCountryList->setSelected(PreferredCountryList->findItem(countryName),true);
        }


        CandidateList->insertItem( nick );

	}

    QStringList mapAddresses = TorkConfig::mapAddress();

	for ( QStringList::Iterator it = mapAddresses.begin(); it != mapAddresses.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        QString entry = (*it).section(" ",1,1);
        QString destination = entry.section(".",0,-3);
        QString server = entry.section(".",-2,-2);
        QString waypoint = entry.section(".",-1,-1);

        tm = new QListViewItem(MapAddress,destination,server,waypoint);
    }

    QListViewItemIterator it(AllowUnverifiedNodes);
    while ( it.current() ) {
        if (TorkConfig::allowUnverifiedNodes().contains(it.current()->text(0)))
            AllowUnverifiedNodes->setSelected(*it,true);
        ++it;
    }

    CountryList->sort(true);
    PreferredCountryList->sort(true);

}

void TorServers::destroy()
{
    QStringList cclist;
    for (unsigned int index = 0; index != CountryList->count(); ++index){
        if (CountryList->item(index)->isSelected()){
            cclist.append(ccodes[CountryList->item(index)->text()]);
        }
    }
    TorkConfig::setExcludeCountries(cclist);

    cclist.clear();
    for (unsigned int index = 0; index != PreferredCountryList->count(); ++index){
        if (PreferredCountryList->item(index)->isSelected()){
            cclist.append(ccodes[PreferredCountryList->item(index)->text()]);
        }
    }
    TorkConfig::setPreferredCountries(cclist);

    TorkConfig::writeConfig();

}

void TorServers::pushButton6_clicked()
{

    new QListViewItem(MapAddress,Destination->text(), CandidateList->currentText(), WayPoints->currentText());
}



void TorServers::MapAddress_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( MapAddress );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void TorServers::slotDeleteEntry( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(MapAddress, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (MapAddress->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


void TorServers::MapAddress_returnPressed( QListViewItem * )
{

}



void TorServers::clearSelected_clicked()
{

    QListViewItemIterator it(ExcludeNodes, QListViewItemIterator::Selected);
    while ( it.current() ) {
        it.current()->listView()->setSelected(it.current(),false);
        ++it;
    }
    CountryList->clearSelection();
}


void TorServers::clearSelected_3_clicked()
{

    QListViewItemIterator it(ExitNodes, QListViewItemIterator::Selected);
    while ( it.current() ) {
        it.current()->listView()->setSelected(it.current(),false);
        ++it;
    }
    PreferredCountryList->clearSelection();
}



void TorServers::pushButton6_2_clicked()
{

    QListViewItemIterator it(AllowUnverifiedNodes, QListViewItemIterator::Selected);
    while ( it.current() ) {
        it.current()->listView()->setSelected(it.current(),false);
        ++it;
    }

}


// <connections>
//     <connection>
//         <sender>pushButton6</sender>
//         <signal>clicked()</signal>
//         <receiver>TorServers</receiver>
//         <slot>pushButton6_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>MapAddress</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>TorServers</receiver>
//         <slot>MapAddress_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>MapAddress</sender>
//         <signal>returnPressed(QListViewItem*)</signal>
//         <receiver>TorServers</receiver>
//         <slot>MapAddress_returnPressed(QListViewItem*)</slot>
//     </connection>
//     <connection>
//         <sender>clearSelected</sender>
//         <signal>clicked()</signal>
//         <receiver>TorServers</receiver>
//         <slot>clearSelected_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>clearSelected_2</sender>
//         <signal>clicked()</signal>
//         <receiver>TorServers</receiver>
//         <slot>clearSelected_2_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>clearSelected_3</sender>
//         <signal>clicked()</signal>
//         <receiver>TorServers</receiver>
//         <slot>clearSelected_3_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>clearSelected_3_2</sender>
//         <signal>clicked()</signal>
//         <receiver>TorServers</receiver>
//         <slot>clearSelected_3_2_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>pushButton6_2</sender>
//         <signal>clicked()</signal>
//         <receiver>TorServers</receiver>
//         <slot>pushButton6_2_clicked()</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">torservers.ui.h</include>
// </includes>
// <slots>
//     <slot>pushButton6_clicked()</slot>
//     <slot>MapAddress_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
//     <slot>MapAddress_returnPressed( QListViewItem * )</slot>
//     <slot>clearSelected_clicked()</slot>
//     <slot>clearSelected_2_clicked()</slot>
//     <slot>clearSelected_3_clicked()</slot>
//     <slot>clearSelected_3_2_clicked()</slot>
//     <slot>pushButton6_2_clicked()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>




void TorServers::CountryList_clicked( QListBoxItem * curitem)
{

    QListViewItemIterator it( ExcludeNodes );
    while ( it.current() ) {
        QListViewItem *item = it.current();
        if (curitem){
/*            kdDebug() << item->text(0) << endl;
            kdDebug() << curitem->text() << endl;*/
            if (item->text(0) == curitem->text())
                item->setSelected(curitem->isSelected());
        }
        it++;
    }
    ExcludeNodes->repaintContents();

}

void TorServers::PreferredCountryList_clicked( QListBoxItem * curitem)
{

    QListViewItemIterator it( ExitNodes );
    while ( it.current() ) {
        QListViewItem *item = it.current();
        if (curitem){
/*            kdDebug() << item->text(0) << endl;
            kdDebug() << curitem->text() << endl;*/
            if (item->text(0) == curitem->text())
                item->setSelected(curitem->isSelected());
        }
        it++;
    }
    ExitNodes->repaintContents();

}


