/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


#include "torkconfig.h"
#include "portsandnames.h"
#include <klocale.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <kdebug.h>


void Usability::init()
{
    QListViewItemIterator it(LongLivedPorts);
    while ( it.current() ) {
        int i;
        QString port;
        for (i = 0; _port_name[i].port; ++i) {
            portsandnames_t *pics = &_port_name[i];
            if (it.current()->text(0) == pics->name){
                port = pics->port;
                continue;
            }
        }

        if (TorkConfig::longLivedPorts().contains(port))
            LongLivedPorts->setSelected(*it,true);
        ++it;
    }

    QStringList existingTracks = TorkConfig::trackHostExits();
    QListViewItem *tm;
	for ( QStringList::Iterator it = existingTracks.begin(); it != existingTracks.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        tm = new QListViewItem(TrackHostExits,(*it));
    }

}
void Usability::LongLivedPorts_selectionChanged()
{
    emit settingsChanged();
}




void Usability::PushAdd_clicked()
{

    new QListViewItem(TrackHostExits,NewHost->text());
}



void Usability::TrackHostExits_contextMenuRequested( QListViewItem *, const QPoint &point, int )
{

    QPopupMenu *menu = new QPopupMenu( TrackHostExits );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void Usability::slotDeleteEntry( )
{
    kdDebug() << "deleting entry" << endl;

    QListViewItemIterator it(TrackHostExits, QListViewItemIterator::Selected);
    while ( it.current() ) {
        if (TrackHostExits->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


// <connections>
//     <connection>
//         <sender>LongLivedPorts</sender>
//         <signal>selectionChanged()</signal>
//         <receiver>Usability</receiver>
//         <slot>LongLivedPorts_selectionChanged()</slot>
//     </connection>
//     <connection>
//         <sender>TrackHostExits</sender>
//         <signal>contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</signal>
//         <receiver>Usability</receiver>
//         <slot>TrackHostExits_contextMenuRequested(QListViewItem*,const QPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>Usability</receiver>
//         <slot>PushAdd_clicked()</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">usability.ui.h</include>
// </includes>
// <signals>
//     <signal>settingsChanged()</signal>
// </signals>
// <slots>
//     <slot>LongLivedPorts_selectionChanged()</slot>
//     <slot>TrackHostExits_contextMenuRequested( QListViewItem *, const QPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
//     <slot>PushAdd_clicked()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>



void Usability::clearSelected_clicked()
{

    QListViewItemIterator it(LongLivedPorts, QListViewItemIterator::Selected);
    while ( it.current() ) {
        it.current()->listView()->setSelected(it.current(),false);
        ++it;
    }

}
