/***************************************************************************
** $Id: warnings.h,v 1.12 2006/09/11 20:47:26 hoganrobert Exp $
 *   Copyright (C) 2006 by Robert Hogan   *
 *   robert@roberthogan.net   *
 *   Based on config method in Tor
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "tork.h"


typedef struct message_t {
  const char *logmessage; /**< The full keyword (case insensitive). */
  const char *headline; /**< String (or null) describing initial value. */
  char torsaid[250]; /**< String (or null) describing initial value. */
  const char *body; /**< String (or null) describing initial value. */
  const char *type; /**< String (or null) describing initial value. */
  bool (tork::*pt2Member)();
  display_status_t state;  /**< The type of the value. */
} message_t;


#define MSG(logmessage,headline,torsaid, body, type, show, state)                             \
  { logmessage, headline,torsaid,body, type, show, state }

static message_t _tork_messages[] = {
    MSG("ommencing hibernation", 
        "Tor Is No Longer Accepting Traffic!",
        "",
        "Tor has exceeded the bandwidth limits you set in "
        "'My Server->Performance' and so will no longer accept traffic. To fix this, set a higher threshold in"
        "'My Server->Performance'.",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Accounting period ended", 
        "Tor Is No Longer Accepting Traffic!",
        "",
        "Tor has exceeded the bandwidth limits you set in "
        "'My Server->Performance' and so will no longer accept traffic. To fix this, set a higher threshold in"
        "'My Server->Performance'.",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Hibernation period ended", 
        "Tor Is Now Accepting Traffic Again!",
        "",
        "Tor has completed a hibernation period that resulted from the settings you defined in "
        "'My Server->Performance'. If you do not want to accept traffic, set a lower threshold in"
        "'My Server->Performance'.",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Your IP seems to have changed", 
        "You are running a server without any contact information!",
        "",
        "You can set your contact info in the configuration section 'My Server'. Please do so! ",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("jdsklajdkslajdskla",
        "Tor Controller is Not Responding!", 
        "",
        "TorK hasn't been able to contact Tor yet. If the display remains empty, stop and restart Tor via the control buttons. ",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("notorexecutable", 
        "Can't Find Your Tor Installation!",
        "",
        "You need to tell me where Tor is - it's not in any of your executable paths. Run the 'First Run Wizard' again from the 'Tools' menu.",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("noprivoxyexecutable", 
        "Can't Find Your Privoxy Installation!",
        "",
        "You need to tell me where Privoxy is - it's not in any of your executable paths. Run the 'First Run Wizard' again from the 'Tools' menu.",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("dnsrequestsdetected", 
        "You May Be Leaking DNS Requests!",
        "",
        "You should inspect the 'Traffic Log' to establish which application is leaking the DNS requests. Look for :domain or :53 in the Host/Port column of the Non-Tor traffic log. It may be that the application submitting the requests is not of interest to you.",
        "DNS Leak Warnings",
        (&tork::showDNSLeaks),
        DISPLAY_NONE),
    MSG("Error writing to", 
        "Problem Accessing Files!",
        "",
        "You should make sure that you have the requisite access to the files required by Tor. Try typing 'tor' at the command line to investigate further.",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("cannot be read", 
        "Problem Accessing Files!",
        "",
        "You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further.",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Could not chmod", 
        "Problem Accessing Files!",
        "",
        "You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further.",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Couldn't open", 
        "Problem Accessing Files!",
        "",
        "You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further.",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Error creating", 
        "Problem Accessing Files!",
        "",
        "You should make sure that you have the requesite access to the files required by Tor. Try typing 'tor' at the command line to investigate further.",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("deprecated", 
        "TorK is using a deprecated config option!",
        "",
        "Please report this using 'Help->Report Bug' in the menu. Try to provide as much detail as possible. Thanks!",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("Failed to parse/validate config", 
        "TorK has passed an invalid configuration file to Tor!",
        "",
        "Please report this using 'Help->Report Bug' in the menu. Try to provide as much detail as possible. Thanks!",
        "General Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("your clock just jumped", 
        "Tor is having problems with your local clock!",
        "",
        "Please report this using 'Help->Report Bug' in the menu or directly to or-talk@freehaven.net. Try to provide as much detail as possible. Thanks!",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("your ORPort is reachable from the outside", 
        "Your Tor Server appears to be working!!",
        "",
        "You are now serving the Tor network. Be careful out there!",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("your DirPort is reachable from the outside", 
        "Your Tor Server's directory appears to be working!!",
        "",
        "You can now serve directory listings to the Tor network. Be careful out there!",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),
    MSG("torclosedconnection", 
        "Tor Stopped Talking To Us!!",
        "",
        "Try starting Tork again!",
        "Usage Warnings",
        (&tork::showUsage),
        DISPLAY_NONE),



  { NULL,  NULL, "", NULL, NULL, NULL, DISPLAY_NONE }
};
#undef MSG
