/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "bibparser.h"
#include "c2butils.h"


bibParser::bibParser(QObject *parent, const char *name)
        : QObject(parent, name)
{
    // Setting Reference Types and Reference Fields
    setRefTypes();

    // Setting Output Field Ordering
    setOutOrdering();

    // Setting Menu Field Ordering
    setMenuOrdering();

    // Creating Month List
    MDB = new MonthDB();
}

bibParser::~bibParser()
{
    delete MDB;
}


QString bibParser::medlToc2b( const QString& au )
{
    // Preprocess Author from Medline 'AAAAAAA BB' to Aaaaaaa, BB'
    // which can be unambiguously translated to 'B. B. Aaaaaaa'
    // Takes care of cb2Bib included prefixes and suffixes

    QString FullN = au.simplifyWhiteSpace();
    FullN.remove(",");
    // Attention: prefixes and sufixes come from astring
    FullN.replace( QRegExp( "\\b(da|de|del|der|di|do|dos|van|vande|von)\\s", FALSE ), "\\1+" );
    FullN.replace( "+", "_" );
    QStringList list = QStringList::split( QRegExp("[,\\s]"), FullN );
    QString LastN = list.first();
    if ( isUpperCaseString( LastN ) )
    {
        LastN = LastN.lower();
        LastN[0] = LastN[0].upper();
        int ii = LastN.find( QRegExp( "[-']" ) );
        if ( ii++ > 0 )
            LastN[ii] = LastN[ii].upper();
    }
    QString FisrtN = "";
    for ( QStringList::Iterator it = ++(list.begin()); it != list.end(); ++it )
        FisrtN += QString(" %1").arg(*it);
    QString isSuffix = list.last();
    if ( isSuffix.contains( QRegExp("\\b(2nd|3rd|Jr|II|III)\\b") ) )
    {
        isSuffix.replace(QRegExp("\\b2nd\\b"), "II");
        isSuffix.replace(QRegExp("\\b3rd\\b"), "III");
        LastN += " " + isSuffix;
        FisrtN.remove( QRegExp("\\b(2nd|3rd|Jr|II|III)\\b") );
    }
    LastN.replace( QRegExp( "(da|de|del|der|di|do|dos|van|vande|von)_", FALSE ), "\\1 " );
    FullN = LastN + "," + FisrtN;
    return FullN;
}

QString bibParser::setPages( const QString& pp )
{
    QString Pages = pp;
    Pages.replace( QRegExp("\\W"), " " );
    Pages = Pages.simplifyWhiteSpace();
    Pages.replace( " ", " - " );
    QRegExp rx = QRegExp("^(\\d+)\\s*-\\s*(\\d+)$");
    if ( Pages.contains( rx ) )
    {
        rx.search( Pages );
        QString fp = rx.cap(1);
        Pages = fp + " - ";
        QString lp = rx.cap(2);
        uint lfp = fp.length();
        uint llp = lp.length();
        if ( lfp > llp )
            lp = fp.remove( lfp - llp, llp ) + lp;     // eg, 123-7  ->  123 - 127
        Pages += lp;
    }
    return Pages;
}

void bibParser::setOutOrdering()
{
    fieldl <<
    "title" <<
    "author" <<
    "journal" <<
    "booktitle" <<
    "series" <<
    "chapter" <<
    "pages" <<
    "volume" <<
    "number" <<
    "edition" <<
    "institution" <<
    "organization" <<
    "school" <<
    "address" <<
    "month" <<
    "year" <<
    "editor" <<
    "publisher" <<
    "abstract" <<
    "keywords" <<
    "isbn" <<
    "issn" <<
    "doi" <<
    "eprint" <<
    "file" <<
    "url" <<
    "note" <<
    "annote";
    REfield = QRegExp( "\\b("+fieldl.join("|")+")\\b" );
}

void bibParser::setMenuOrdering()
{
    fieldlm << //
    "title" <<
    "author" <<
    "journal" <<
    "pages" <<
    "volume" <<
    "number" <<
    "year" <<
    "abstract" <<
    "keywords" <<
    "file" <<
    "address" <<
    "annote" <<
    "booktitle" <<
    "chapter" <<
    "doi" <<
    "edition" <<
    "editor" <<
    "eprint" <<
    "institution" <<
    "isbn" <<
    "issn" <<
    "month" <<
    "note" <<
    "organization" <<
    "publisher" <<
    "school" <<
    "series" <<
    "url";
}

void bibParser::setRefTypes()
{
    TypesList << "" <<
    "article" <<
    "book" <<
    "booklet" <<
    "conference" <<
    "inbook" <<
    "incollection" <<
    "inproceedings" <<
    "manual" <<
    "mastersthesis" <<
    "misc" <<
    "periodical" <<
    "phdthesis" <<
    "proceedings" <<
    "techreport" <<
    "unpublished";
}
