/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "bibsyntaxhighlighter.h"

bibSyntaxHighlighter::bibSyntaxHighlighter( QTextEdit *textEdit )
        : QSyntaxHighlighter( textEdit )
{
    isBlocked = FALSE;
    text_color = textEdit->color();
}


bibSyntaxHighlighter::~bibSyntaxHighlighter()
{}

int bibSyntaxHighlighter::highlightParagraph( const QString & text, int paraNo )
{
    paraNo = 0;
    if( isBlocked )
        return paraNo;

    int len = text.length();
    setFormat( 0, len - 1, text_color );

    QRegExp rx0( "[\\{\\}]+" );
    rx0.setMinimal(TRUE);
    int pos = 0;
    while ( pos >= 0 )
    {
        pos = rx0.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx0.matchedLength(), c.bib_delimiter_color );
            pos  += rx0.matchedLength();
        }
    }
    QRegExp rx1( "@\\w+" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx1.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx1.matchedLength(), c.bib_reference_type_color );
            pos  += rx1.matchedLength();
        }
    }
    QRegExp rx2( "^\\w+" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx2.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx2.matchedLength(), c.bib_reference_field_color );
            pos  += rx2.matchedLength();
        }
    }
    QRegExp rx3( "^% .+$" );
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx3.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx3.matchedLength(), c.comment_color );
            pos  += rx3.matchedLength();
        }
    }

    return paraNo;
}

void bibSyntaxHighlighter::reloadColors()
{
    c.loadColors();
    rehighlight();
}

void bibSyntaxHighlighter::blockSyntaxHighlighting( bool blocked )
{
    isBlocked = blocked;
    rehighlight();
}
