/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BBIBPARSER_H
#define C2BBIBPARSER_H
#include "bibparser.h"

#include <qdict.h>
#include <qlineedit.h>


class c2bBibPreParser;
class c2bPreProcess;
class c2bSettings;
class cb2bibbase;
class citeIDMaker;
class JournalDB;



/**
cb2Bib interface to bibParser
 
This class groups Bib Parser functionality related to GUI
 
@author Pere Constans
*/
class c2bBibParser : public bibParser
{
    Q_OBJECT

public:
    c2bBibParser(c2bSettings *st, cb2bibbase *c2bMain,
                 QObject *parent = 0, const char *name = 0);
    ~c2bBibParser();

    bool m_auto_regc;
    QDict<QLineEdit> RefFields;
    QString abbreviatedJournal( const QString& j );
    QString c2bAutoRecogStr;
    QString fullJournal( const QString& j );
    QString setJournalsToAbbreviated( const QString& text );
    QString setJournalsToFull( const QString& text );
    void clearFields();
    void makeCiteID();


signals:
    void bibModified();
    void helpRequested( const QString& ln );
    void message( const QString& ms );
    void preParserDataAvailable( const QString& ppItem );


public slots:
    QString makeBib( bool sig = TRUE );
    QString PProc( const QString, QString );
    virtual void guessItem( QString );
    virtual void preParseItem( const QString& cb );
    virtual void processItem( QString );
    virtual void setJournal();


protected:
    JournalDB *JDB;


private:
    c2bBibPreParser *prParser;
    c2bPreProcess *prProc;
    c2bSettings *s;
    cb2bibbase *c2b;
    citeIDMaker *citeIDM;
    int countFields();
    void guessAbstract( const QString& text );
    void guessISBN( const QString& text );
    void guessJournal( QString text );
    void guessKeywords( const QString& text );
    void guessNumber( const QString& text );
    void guessPages( const QString& text );
    void guessTitle( const QString& text );
    void guessVolume( const QString& text );
    void guessYear( const QString& text );
    void setFieldWidgetMap();
    void setRefType( QString );

};

#endif
