/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BBIBPREPARSER_H
#define C2BBIBPREPARSER_H

#include <qobject.h>

class c2bPreParserLogViewer;
class c2bSettings;
class cb2bibbase;
class QProcess;


/**
This class handles external processing of Bibliographic items. It's formally an
extension of the c2bBibParser, the glue class between GUI staff and the cb2Bib's
bibParser functionality.
 
*/
class c2bBibPreParser : public QObject
{
    Q_OBJECT

public:
    c2bBibPreParser(c2bSettings *st, cb2bibbase *c2bMain,
                    QObject *parent = 0, const char *name = 0);
    ~c2bBibPreParser();


signals:
    void helpRequested( const QString& ln );
    void preParserDataAvailable( const QString& ppItem );


public slots:
    virtual void preParseItem( const QString& cb );


protected slots:
    virtual void conversionEnded();


private:
    c2bPreParserLogViewer *viewLog;
    c2bSettings *s;
    cb2bibbase *c2b;
    QProcess *preParser;
    QString inp_file;
    QString inp_string;
    QString out_file;
    QString out_string;
    void preProcess();

};

#endif
