/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2bclipboard.h"
#ifdef CB_POLL
#include "clipboardpoll.h"
#endif


c2bClipboard::c2bClipboard(QObject *parent, const char *name)
        : QObject(parent, name)
{
    // Connecting clipboard
    cb = QApplication::clipboard();
    supportsSelection = cb->supportsSelection();
    isConnected = FALSE;
    clip = cb->text( QClipboard::Clipboard );
    if ( supportsSelection )
        clipS = cb->text( QClipboard::Selection );
    else
        clipS = "";

    // Setting timer
    interval = 1000;
    // Uncomment the 4 timer-related lines if clipboard appears unresponsive
    // and you cannot compile with cbpoll option
    //     timer = new QTimer( this );
    //     connect( timer, SIGNAL( timeout() ), this, SLOT( checkData() ) );

#ifdef CB_POLL

    poll = new ClipboardPoll();
    connect( poll, SIGNAL( clipboardChanged( bool ) ), this, SLOT( newClipboardData( bool ) ) );
#endif
}


c2bClipboard::~c2bClipboard()
{
#ifdef CB_POLL
    delete poll;
#endif
}

void c2bClipboard::checkData()
{
    if ( supportsSelection )
    {
        if( clip != cb->text( QClipboard::Clipboard ) )
        {
            clip = cb->text( QClipboard::Clipboard );
            clipS = cb->text( QClipboard::Selection );
            emit cbDataChanged( clip );
        }
        else if( clipS != cb->text( QClipboard::Selection ) )
        {
            clipS = cb->text( QClipboard::Selection );
            emit cbDataChanged( clipS );
        }
    }
    else
    {
        if( clip != cb->text( QClipboard::Clipboard ) )
        {
            clip == cb->text( QClipboard::Clipboard );
            emit cbDataChanged( clip );
        }
    }
}

void c2bClipboard::dataChanged()
{
    clip = cb->text( QClipboard::Clipboard );
    emit cbDataChanged( clip );
}

void c2bClipboard::selectionChanged()
{
    clipS = cb->text( QClipboard::Selection );
    emit cbDataChanged( clipS );
}

void c2bClipboard::setConnected( bool zconn )
{
    isConnected = zconn;
    if( isConnected )
    {
        clip = cb->text( QClipboard::Clipboard );
        connect( cb, SIGNAL( dataChanged() ), this, SLOT( dataChanged() ) );
        if ( supportsSelection )
        {
            clipS = cb->text( QClipboard::Selection );
            connect( cb, SIGNAL( selectionChanged() ),
                     this, SLOT( selectionChanged() ) );
        }
#ifdef CB_POLL
        poll->startT( interval );
#endif
        //         timer->start( interval );
    }
    else
    {
#ifdef CB_POLL
        poll->stopT();
#endif
        //         timer->stop();
        disconnect( cb, SIGNAL( dataChanged() ), this, SLOT( dataChanged() ) );
        if ( supportsSelection )
        {
            disconnect( cb, SIGNAL( selectionChanged() ),
                        this, SLOT( selectionChanged() ) );
        }
    }
}

const QString c2bClipboard::text()
{
    return cb->text( QClipboard::Clipboard );
}

void c2bClipboard::newClipboardData( bool selectionMode )
{
    if ( selectionMode )
        checkSelectionData();
    else
        checkClipboardData();
}

void c2bClipboard::checkSelectionData()
{
    if ( supportsSelection )
    {
        if( clipS != cb->text( QClipboard::Selection ) )
        {
            clipS = cb->text( QClipboard::Selection );
            emit cbDataChanged( clipS );
        }
    }
}

void c2bClipboard::checkClipboardData()
{
    if( clip != cb->text( QClipboard::Clipboard ) )
    {
        clip = cb->text( QClipboard::Clipboard );
        emit cbDataChanged( clip );
    }
}
