/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BCLIPBOARD_H
#define C2BCLIPBOARD_H

#include <qobject.h>

#include <qapplication.h>
#include <qclipboard.h>
#include <qstring.h>
#include <qtimer.h>


/**
cb2Bib Clipboard
Implements clipboard functionatility as required by cb2Bib
This should fix acrobat, mozilla, qt 3.3.3 issues
Using ClipboardPoll
 
@author Pere Constans
*/

#ifdef CB_POLL
class ClipboardPoll;
#endif

class c2bClipboard : public QObject
{
    Q_OBJECT
public:
    c2bClipboard(QObject *parent = 0, const char *name = 0);
    ~c2bClipboard();

    const QString text();


private:
    bool isConnected;
    bool supportsSelection;
    QClipboard* cb;
    QString clip;
    QString clipS;
    QTimer* timer;
    uint interval;
#ifdef CB_POLL
    ClipboardPoll* poll;
#endif


signals:
    void cbDataChanged( const QString& );


public slots:
    virtual void setConnected( bool );


private slots:
    virtual void checkClipboardData();
    virtual void checkData();
    virtual void checkSelectionData();
    virtual void dataChanged();
    virtual void newClipboardData( bool selectionMode );
    virtual void selectionChanged();

};

#endif
