/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2bclipedit.h"

#include <qpopupmenu.h>
#include <qaction.h>



c2bClipEdit::c2bClipEdit(QWidget *parent, const char *name)
        : QTextEdit(parent, name)
{
    cb2BibActions = 0;
}


c2bClipEdit::~c2bClipEdit()
{}


QPopupMenu* c2bClipEdit::createPopupMenu( const QPoint & pos )
{
    QPopupMenu* pm = QTextEdit::createPopupMenu( pos );
    if( !cb2BibActions )
        return pm;

    pm->insertSeparator();
    for( uint i = 0; i < cb2BibActions->count(); i++ )
    {
        QAction* a;
        a = *cb2BibActions->at(i);
        a->addTo( pm );
        if( i == 2 || i == 4 )
            pm->insertSeparator();
    }
    return pm;
}

void c2bClipEdit::setActions( QPtrList<QAction*>* aList )
{
    cb2BibActions = aList;
}
