/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2bcolors.h"
#include "cb2bib_par.h"

#include <qsettings.h>


c2bColors::c2bColors()
{
    loadColors();
    colorList.insert( "bib_delimiter_color", &bib_delimiter_color );
    colorList.insert( "bib_reference_field_color", &bib_reference_field_color );
    colorList.insert( "bib_reference_type_color", &bib_reference_type_color );
    colorList.insert( "cb2bib_digit_color", &cb2bib_digit_color );
    colorList.insert( "cb2bib_highly_relevant_color", &cb2bib_highly_relevant_color );
    colorList.insert( "cb2bib_relevant_color", &cb2bib_relevant_color );
    colorList.insert( "cb2bib_tag_color", &cb2bib_tag_color );
    colorList.insert( "cb2bib_unrelevant_color", &cb2bib_unrelevant_color );
    colorList.insert( "comment_color", &comment_color );
    colorList.insert( "netqinf_command_content_color", &netqinf_command_content_color );
    colorList.insert( "netqinf_command_key_color", &netqinf_command_key_color );
}

c2bColors::~c2bColors()
{}


void c2bColors::updateColor( const QColor &color, const QString &colorName )
{
    *colorList[colorName] = color;
}

void c2bColors::writeSettings()
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
    settings.writeEntry( APP_KEY + "bib_delimiter_color", (int)bib_delimiter_color.rgb() );
    settings.writeEntry( APP_KEY + "bib_reference_field_color", (int)bib_reference_field_color.rgb() );
    settings.writeEntry( APP_KEY + "bib_reference_type_color", (int)bib_reference_type_color.rgb() );
    settings.writeEntry( APP_KEY + "cb2bib_digit_color", (int)cb2bib_digit_color.rgb() );
    settings.writeEntry( APP_KEY + "cb2bib_highly_relevant_color", (int)cb2bib_highly_relevant_color.rgb() );
    settings.writeEntry( APP_KEY + "cb2bib_relevant_color", (int)cb2bib_relevant_color.rgb() );
    settings.writeEntry( APP_KEY + "cb2bib_tag_color", (int)cb2bib_tag_color.rgb() );
    settings.writeEntry( APP_KEY + "cb2bib_unrelevant_color", (int)cb2bib_unrelevant_color.rgb() );
    settings.writeEntry( APP_KEY + "comment_color", (int)comment_color.rgb() );
    settings.writeEntry( APP_KEY + "netqinf_command_content_color", (int)netqinf_command_content_color.rgb() );
    settings.writeEntry( APP_KEY + "netqinf_command_key_color", (int)netqinf_command_key_color.rgb() );
}

void c2bColors::loadColors()
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
    bib_delimiter_color = (QRgb)settings.readNumEntry( APP_KEY +
                          "bib_delimiter_color", -5658199 ); // darkgray
    bib_reference_field_color = (QRgb)settings.readNumEntry( APP_KEY +
                                "bib_reference_field_color", -5952982 ); // brown
    bib_reference_type_color = (QRgb)settings.readNumEntry( APP_KEY +
                               "bib_reference_type_color", -16776961 ); // blue
    cb2bib_digit_color = (QRgb)settings.readNumEntry( APP_KEY +
                         "cb2bib_digit_color", -5952982 ); // brown
    cb2bib_highly_relevant_color = (QRgb)settings.readNumEntry( APP_KEY +
                                   "cb2bib_highly_relevant_color", -16711936 ); // green
    cb2bib_relevant_color = (QRgb)settings.readNumEntry( APP_KEY +
                            "cb2bib_relevant_color", -16741493 ); // darkcyan
    cb2bib_tag_color = (QRgb)settings.readNumEntry( APP_KEY +
                       "cb2bib_tag_color", -16776961 ); // blue
    cb2bib_unrelevant_color = (QRgb)settings.readNumEntry( APP_KEY +
                              "cb2bib_unrelevant_color", -4276546 ); // gray
    comment_color = (QRgb)settings.readNumEntry( APP_KEY +
                    "comment_color", -5658199 ); // darkgray
    netqinf_command_content_color = (QRgb)settings.readNumEntry( APP_KEY +
                                    "netqinf_command_content_color", -16777077 ); // darkblue
    netqinf_command_key_color = (QRgb)settings.readNumEntry( APP_KEY +
                                "netqinf_command_key_color", -5952982 ); // brown
}
