/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BEDITOR_H
#define C2BEDITOR_H

#include "c2beditorbase.h"


class c2bBibParser;
class QDockWindow;
class QLabel;
class QSyntaxHighlighter;
class ReferenceList;



/**
@author Pere Constans
*/
class c2bEditor : public c2bEditorBase
{
    Q_OBJECT
public:
    c2bEditor( const QString& edtype, QWidget* main,
               QWidget* parent = 0, const char* name = 0, WFlags fl = WDestructiveClose );
    c2bEditor( const QString& file, const QString& edtype, c2bBibParser *p, QWidget* main,
               QWidget* parent = 0, const char* name = 0, WFlags fl = WDestructiveClose );
    ~c2bEditor();

    bool c2bEditorClose();
    const QString editFileName();
    QAction* setLyxPipeAction;


signals:
    void aboutToQuit();
    void Execute();
    void helpRequested( const QString& ln );
    void restartEngine();
    void restartQuery();


public slots:
    virtual void closeEvent( QCloseEvent *ce );
    virtual void newSetting();


protected slots:
    virtual void cursorPositionChanged( int row, int col );
    virtual void fileExit();
    virtual void fileSave();
    virtual void fileSaveAs();
    virtual void helpEditorHelp();
    virtual void isModified();
    virtual void journalsToAbbreviated();
    virtual void journalsToFull();
    virtual void load( const QString& = 0 );
    virtual void overwriteModeChanged();
    virtual void pasteCurrentBibTeX();
    virtual void postProcess();
    virtual void reload( const QString& f );
    virtual void saveAndExecute();
    virtual void statusMessage( const QString& ms );
    virtual void viewCb2Bib();
    virtual void viewReferenceList( bool stat );
    virtual void viewTools( bool stat );


private:
    c2bBibParser* bp;
    QDockWindow* dwRList;
    QLabel* lineLabel;
    QLabel* overwriteLabel;
    QString EditorType;
    QString EFile;
    QSyntaxHighlighter* sH;
    QWidget* c2bMain;
    ReferenceList* RList;
    void createReferenceList();
    void initEditor();
    void setIcons();

};

#endif
