/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BNETWORK_H
#define C2BNETWORK_H

#include <qfile.h>
#include <qhttp.h>
#include <qobject.h>
#include <qurloperator.h>


class QNetworkOperation;
class QProcess;
class QProgressDialog;
class QWidget;


/**
cb2Bib Network file copy/move
 
@author Pere Constans
*/
class c2bNetwork : public QObject
{

    Q_OBJECT

public:
    c2bNetwork(QObject *parent = 0, const char *name = 0);
    ~c2bNetwork();

    bool openFile( const QString& fn );
    const QString getDestFName();
    const QString getErrorString();
    const QString getOrigFName();
    const QString openErrorString();
    void getFile( const QString& orig, const QString& dest, const QString& action = "copy",
                  QObject* receiver = 0, const QString& callback = 0 );


signals:
    void done_private( bool status );
    void getFileDone( bool status, const QString& error );


public slots:
    virtual void readSettings();


private:
    bool checkDest();
    bool getFile_c2b( const QString& action );
    bool getFile_client( const QString& action );
    bool getFilePrivate( const QString& orig, const QString& dest, const QString& action );
    bool m_fetching;
    bool m_fmclient;
    bool postHttp_c2b();
    QFile *fDestFile;
    QHttp poster;
    QProcess *fmclient;
    QProgressDialog *pd;
    QString destFile;
    QString m_fmclient_copy_arg;
    QString m_fmclient_copy_bin;
    QString m_fmclient_move_arg;
    QString m_fmclient_move_bin;
    QString m_fmclient_open_arg;
    QString m_fmclient_open_bin;
    QString m_get_error;
    QString m_open_error;
    QString origFile;
    QUrlOperator fetcher;
    QWidget *pWidget;


private slots:
    virtual void clientEnded();
    virtual void fetcherCancel();
    virtual void fetcherEnded( QNetworkOperation* op );
    virtual void getFilePrivateDone( bool status );
    virtual void posterEnded( bool err );

};

#endif
