/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BNETWORKQUERY_H
#define C2BNETWORKQUERY_H

#include <qobject.h>


class c2bNetwork;
class QWidget;


/**
cb2Bib Network Queries
 
@author Pere Constans
*/

class c2bNetworkQuery : public QObject
{

    Q_OBJECT

public:
    c2bNetworkQuery(c2bNetwork* n, QObject *parent = 0, const char *name = 0);
    ~c2bNetworkQuery();

    const QString bookMarks();
    const QString errorString();
    void submitQ( const QString& jn, const QString& vol, const QString& fp );


signals:
    void message( const QString& );
    void queryEnded( bool stat, const QString& targetPDF, const QString& targetBib );


public slots:
    virtual void readSettings();


private:
    bool m_autopdf;
    bool m_endoffile;
    bool m_keeptmp;
    c2bNetwork* net;
    QString action;
    QString captionQ;
    QString error;
    QString FPage;
    QString jcode;
    QString JournalN;
    QString m_bookmarks;
    QString m_netqinffl;
    QString pdfurl_prefix;
    QString pdfurl_sufix;
    QString Queryfile1;
    QString Queryfile2;
    QString referenceurl_prefix;
    QString referenceurl_sufix;
    QString targetBib;
    QString targetPDF;
    QString targetQ;
    QString Volume;
    QWidget* pWidget;
    uint m_q_number;


private slots:
    virtual bool setQueryParams( const QString& jn );
    virtual void QueryDone( bool stat );
    virtual void submitQ1();
    virtual void submitQ2( bool stat );

};

#endif
