/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2bpreparserlogviewer.h"
#include "cb2bib_par.h"
#include "c2bsettings.h"

#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qprocess.h>
#include <qpushbutton.h>
#include <qtextedit.h>


c2bPreParserLogViewer::c2bPreParserLogViewer(c2bSettings *st, QWidget *parent, const char *name)
        : c2bPreParserLogViewerBase(parent, name)
{
    s = st;
    connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( Help() ) );
    buttonClose->setEnabled( FALSE );
    Logs->setTextFormat( Qt::LogText );
}

c2bPreParserLogViewer::~c2bPreParserLogViewer()
{}


void c2bPreParserLogViewer::append( const QString& ms )
{
    Logs->append( ms );
}

void c2bPreParserLogViewer::closeEvent( QCloseEvent* ce )
{
    Logs->clear();
    if( ClipboardPPShowLog->isChecked() )
    {
        s->m_preparser_show_log = FALSE;
        QSettings settings;
        settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
        settings.writeEntry( APP_KEY + "preparser_show_log", FALSE );
    }
    ClipboardPPShowLog->setChecked( FALSE );
    ce->accept();
}

void c2bPreParserLogViewer::readLog( QProcess *ep )
{
    QFileInfo fi( s->m_preparser_bin );
    QString command_name = "[" + fi.baseName() + "] ";
    while ( ep->canReadLineStdout() )
        Logs->append( command_name + ep->readLineStdout() );
    Logs->append( "\n" );
    while ( ep->canReadLineStderr() )
        Logs->append( command_name + ep->readLineStderr() );
    Logs->append( "\n" );
    buttonClose->setEnabled( TRUE );
    buttonClose->setFocus();
}

void c2bPreParserLogViewer::Help()
{
    emit helpRequested( "http://www.molspaces.com/d_cb2bib-overview.php#keyboard" );
}
