/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2bpreprocess.h"
#include "cb2bib_par.h"

#include <qsettings.h>


c2bPreProcess::c2bPreProcess(QObject *parent, const char *name)
        : QObject(parent, name)
{
    pObject = parent;
    readSettings();
    connect( pObject, SIGNAL( newSettingAvailable() ), this, SLOT( readSettings() ) );
}

c2bPreProcess::~c2bPreProcess()
{}


void c2bPreProcess::readSettings()
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
    m_replaceinput = settings.readBoolEntry( APP_KEY + "replaceinput", APP_FIND_REPLACE_INPUT );
    m_replaceinputList = settings.readListEntry( APP_KEY + "replaceinputList" );
    if ( m_replaceinputList.isEmpty() )
        m_replaceinputList = QStringList::split( "^e", APP_FIND_REPLACE_LIST );
}

QString &c2bPreProcess::preProcStream( QString& inp )
{
    if( !m_replaceinput )
        return inp;
    QStringList::Iterator i = m_replaceinputList.begin();
    while( i != m_replaceinputList.end() )
    {
        QStringList spLine = QStringList::split( "|", *i, TRUE );
        inp.replace( spLine[0], spLine[1] );
        ++i;
    }
    return inp;
}
