/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2bsettings.h"
#include "cb2bib_par.h"

#include <qapplication.h>
#include <qdir.h>
#include <qfileinfo.h>


c2bSettings::c2bSettings(QObject *parent, const char *name)
        : QObject(parent, name)
{
    readSettings();
    readCommandLine();
}


c2bSettings::~c2bSettings()
{}

void c2bSettings::readSettings()
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
    m_autonetquery = settings.readBoolEntry( APP_KEY + "autonetquery", APP_AUTO_NETQUERY );
    m_heuristic_guess = settings.readBoolEntry( APP_KEY + "heuristic_guess", APP_HEURISTIC_GUESS );
    m_bibfile = QDir::convertSeparators(settings.readEntry( APP_KEY + "bibf", APP_BIBF ));
    if( m_bibfile == APP_BIBF || m_bibfile.isEmpty() )
        m_bibfile = QDir::convertSeparators(QDir::homeDirPath() + "/" + APP_BIBF);
    m_font.setFamily( settings.readEntry( APP_KEY + "Font0", WINDOW_FF ) );
    m_font.setPointSize( settings.readNumEntry( APP_KEY + "FontSize0", WINDOW_FS ) );
    m_jdbfile = QDir::convertSeparators(settings.readEntry( APP_KEY + "jabfl", APP_JABF ));
    m_author_editor_name_full = settings.readBoolEntry( APP_KEY +
                                "author_editor_name_full", APP_AUTHOR_EDITOR_NAME_FULL );
    m_journal_name_full = settings.readBoolEntry( APP_KEY + "journal_name_full", APP_JOURNAL_NAME_FULL );
    m_movepdf = settings.readBoolEntry( APP_KEY + "movepdf", APP_MOVE_PDF );
    m_pdf_copymove = settings.readEntry( APP_KEY + "copymovepdf", APP_COPYMOVE_PDF );
    m_pdfdir = QDir::convertSeparators(settings.readEntry( APP_KEY + "pdfdir", APP_PDFDIR ));
    m_convert_entries_to_latex = settings.readBoolEntry( APP_KEY + "convert_entries_to_latex", APP_CONVERT_ENTRIES_TO_LATEX );
    m_pp_month = settings.readBoolEntry( APP_KEY + "pp_month", APP_PP_MONTH );
    m_preparser_automatic = settings.readBoolEntry( APP_KEY + "preparser_automatic", APP_PREPARSER_AUTOMATIC );
    m_preparser_show_log = settings.readBoolEntry( APP_KEY + "preparser_show_log", APP_PREPARSER_SHOW_LOG );
    m_preparser_bin = QDir::convertSeparators( settings.readEntry( APP_KEY + "preparser_bin", APP_PREPARSER_BIN ) );
    m_regexpfl = QDir::convertSeparators(settings.readEntry( APP_KEY + "regexpfl", APP_REGEXPF ));
    m_windowHeight = settings.readNumEntry( APP_KEY + "WindowHeight", WINDOW_H );
    m_windowWidth = settings.readNumEntry( APP_KEY + "WindowWidth", WINDOW_W );

    // PDFImport
    m_automatic_pdfimport = settings.readBoolEntry( APP_KEY + "automatic_pdfimport", APP_PDF2TXT_AUTOMATIC );
    PDF2TXT_BIN = QDir::convertSeparators( settings.readEntry( APP_KEY + "pdf2txtbin", APP_PDF2TXT_BIN ) );
    PDF2TXT_ARG = settings.readEntry( APP_KEY + "pdf2txtarg", APP_PDF2TXT_ARG );
    PDF2TXT_ARG = PDF2TXT_ARG.simplifyWhiteSpace();
}

void c2bSettings::readCommandLine()
{
    /*! \page commandline The cb2Bib Command Line

     Usage: <tt>cb2bib [[--bibedit] filename1.bib [filename2.bib ... ]]</tt>"

    */

    m_autostart_bibedit = FALSE;
    m_bibfile_list.clear();

    if ( qApp->argc() == 1 )
        return;
    else
    {
        if ( QString(qApp->argv()[1]) == "--bibedit" )
            m_autostart_bibedit = TRUE;
        else if ( QString(qApp->argv()[1]).startsWith( "-" ) )
            printUsage();
        else
        {
            QFileInfo f( qApp->argv()[1] );
            m_bibfile = f.absFilePath();
        }
    }
    if( m_autostart_bibedit )
    {
        for ( int i = 1; i < qApp->argc(); i++ )
        {
            if ( !QString(qApp->argv()[i]).startsWith( "-" ) )
            {
                QFileInfo f( qApp->argv()[i] );
                m_bibfile_list.append( f.absFilePath() );
            }
        }
        m_autostart_bibedit = !m_bibfile_list.count() == 0;
        if( m_bibfile_list.count() > 0 )
            m_bibfile = m_bibfile_list.first();
    }
}

void c2bSettings::printUsage()
{
    fprintf(stdout, "Usage: cb2bib [[--bibedit] filename1.bib [filename2.bib ... ]]\n");
}

void c2bSettings::writeSettings()
{
    // To be called by cb2BibConf
}

void c2bSettings::writeMainSettings()
{
    QSettings settings;
    settings.insertSearchPath( QSettings::Windows, WINDOWS_REGISTRY );
    settings.writeEntry( APP_KEY + "WindowWidth", m_windowWidth );
    settings.writeEntry( APP_KEY + "WindowHeight", m_windowHeight );
    settings.writeEntry( APP_KEY + "bibf", m_bibfile );
}
