/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2btextbrowser.h"

#include <qpopupmenu.h>
#include <qaction.h>



c2bTextBrowser::c2bTextBrowser(QWidget *parent, const char *name)
        : QTextBrowser(parent, name)
{
    cb2BibActions = 0;
}

c2bTextBrowser::~c2bTextBrowser()
{}


void c2bTextBrowser::setSource(const QString& dummy_name)
{}

QPopupMenu* c2bTextBrowser::createPopupMenu( const QPoint & pos )
{
    QPopupMenu* pm = QTextEdit::createPopupMenu( pos );
    if( !cb2BibActions )
        return pm;

    pm->insertSeparator();
    for( uint i = 0; i < cb2BibActions->count(); i++ )
    {
        QAction* a;
        a = *cb2BibActions->at(i);
        a->addTo( pm );
        if( i == 2 || i == 4 )
            pm->insertSeparator();
    }
    return pm;
}

void c2bTextBrowser::setActions( QPtrList<QAction*>* aList )
{
    cb2BibActions = aList;
}
