/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "c2btextedit.h"
#include "c2butils.h"
#include "finddialog.h"

#include <qaction.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpopupmenu.h>


c2bTextEdit::c2bTextEdit(QWidget *parent, const char *name)
        : QTextEdit(parent, name)
{
    findTextAction = new QAction( this, "findTextAction" );
    findTextAction->setAccel( tr( "Alt+F" ) );
    findTextAction->setMenuText( tr( "&Find in Text" ) );
    findTextAction->setText( tr( "Find in Text" ) );
    connect( findTextAction, SIGNAL( activated() ), this, SLOT( findText() ) );
    wordWrapAction = new QAction( this, "wordWrapAction" );
    wordWrapAction->setMenuText( tr( "Wrap Text" ) );
    wordWrapAction->setText( tr( "Wrap Text" ) );
    connect( wordWrapAction, SIGNAL( activated() ), this, SLOT( wordWrap() ) );
    wordUnWrapAction = new QAction( this, "wordUnWrapAction" );
    wordUnWrapAction->setMenuText( tr( "Unwrap Text" ) );
    wordUnWrapAction->setText( tr( "Unwrap Text" ) );
    connect( wordUnWrapAction, SIGNAL( activated() ), this, SLOT( wordUnWrap() ) );
    m_bibtex_actions = FALSE;
}

c2bTextEdit::~c2bTextEdit()
{}


void c2bTextEdit::setBibTeXActions()
{
    m_bibtex_actions = TRUE;
    convertSelection2LaTeXAction = new QAction( this, "convertSelection2LaTeXAction" );
    convertSelection2LaTeXAction->setMenuText( tr( "Selection to LaTeX" ) );
    convertSelection2LaTeXAction->setText( tr( "Selection to LaTeX" ) );
    connect( convertSelection2LaTeXAction, SIGNAL( activated() ),
             this, SLOT( convert2LaTeX() ) );
    convertSelection2LaTeXAction->setEnabled(FALSE);
    connect( this, SIGNAL(  copyAvailable(bool)  ),
             convertSelection2LaTeXAction, SLOT( setEnabled(bool) ) );
    convertSelection2UnicodeAction = new QAction( this, "convertSelection2UnicodeAction" );
    convertSelection2UnicodeAction->setMenuText( tr( "Selection to Unicode" ) );
    convertSelection2UnicodeAction->setText( tr( "Selection to Unicode" ) );
    connect( convertSelection2UnicodeAction, SIGNAL( activated() ),
             this, SLOT( convert2Unicode() ) );
    convertSelection2UnicodeAction->setEnabled(FALSE);
    connect( this, SIGNAL(  copyAvailable(bool)  ),
             convertSelection2UnicodeAction, SLOT( setEnabled(bool) ) );
    pasteCurrentBibTeXAction = new QAction( this, "pasteCurrentBibTeXAction" );
    pasteCurrentBibTeXAction->setAccel( tr( "Alt+T" ) );
    pasteCurrentBibTeXAction->setMenuText( tr( "Paste Current Bib&TeX" ) );
    pasteCurrentBibTeXAction->setText( tr( "Paste Current BibTeX" ) );
    connect( pasteCurrentBibTeXAction, SIGNAL( activated() ),
             this, SIGNAL( pasteCurrentBibTeX() ) );
    journalsToFullAction = new QAction( this, "journalsToFullAction" );
    journalsToFullAction->setMenuText( tr( "Journals to Full Name" ) );
    journalsToFullAction->setText( tr( "Set Journals to Full Name" ) );
    connect( journalsToFullAction, SIGNAL( activated() ),
             this, SIGNAL( journalsToFull() ) );
    journalsToAbbreviatedAction = new QAction( this, "journalsToAbbreviatedAction" );
    journalsToAbbreviatedAction->setMenuText( tr( "Journals to Abbreviated Name" ) );
    journalsToAbbreviatedAction->setText( tr( "Set Journals to Abbreviated Name" ) );
    connect( journalsToAbbreviatedAction, SIGNAL( activated() ),
             this, SIGNAL( journalsToAbbreviated() ) );
}

QPopupMenu* c2bTextEdit::createPopupMenu( const QPoint & pos )
{
    QPopupMenu* pm = QTextEdit::createPopupMenu( pos );
    pm->insertSeparator();
    findTextAction->addTo( pm );
    if( wordWrapAction->isEnabled() )
        wordWrapAction->addTo( pm );
    if( wordUnWrapAction->isEnabled() )
        wordUnWrapAction->addTo( pm );
    if( m_bibtex_actions )
    {
        pm->insertSeparator();
        if ( hasSelectedText() )
        {
            bool convert = FALSE;
            if( isc2btoBib( selectedText() ) )
            {
                convertSelection2LaTeXAction->addTo( pm );
                convert = TRUE;
            }
            if( isBibtoc2b( selectedText() ) )
            {
                convertSelection2UnicodeAction->addTo( pm );
                convert = TRUE;
            }
            if( convert )
                pm->insertSeparator();
        }
        journalsToFullAction->addTo( pm );
        journalsToAbbreviatedAction->addTo( pm );
        pm->insertSeparator();
        pasteCurrentBibTeXAction->addTo( pm );
    }
    return pm;
}

void c2bTextEdit::keyPressEvent( QKeyEvent * e )
{
    QTextEdit::keyPressEvent( e );
    if ( e->key() == Qt::Key_Insert )
        emit overwriteModeChanged();
}

void c2bTextEdit::findText()
{
    if ( !findDialog )
        findDialog = new FindDialog( this, 0, FALSE );
    findDialog->show();
    findDialog->raise();
    findDialog->comboFind->setFocus();
    findDialog->comboFind->setCurrentText( selectedText().stripWhiteSpace() );
    findDialog->comboFind->lineEdit()->selectAll();
}

void c2bTextEdit::wordWrap()
{
    setWordWrap( QTextEdit::WidgetWidth );
    wordWrapAction->setEnabled( FALSE );
    wordUnWrapAction->setEnabled( TRUE );
}

void c2bTextEdit::wordUnWrap()
{
    setWordWrap( QTextEdit::NoWrap );
    wordWrapAction->setEnabled( TRUE );
    wordUnWrapAction->setEnabled( FALSE );
}

void c2bTextEdit::convert2LaTeX()
{
    insert( c2btoBib( selectedText() ) );
}

void c2bTextEdit::convert2Unicode()
{
    insert( Bibtoc2b( selectedText() ) );
}
