/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BTEXTEDIT_H
#define C2BTEXTEDIT_H

#include <qguardedptr.h>
#include <qtextedit.h>


class FindDialog;
class QAction;
class QPopupMenu;

/**
@author Pere Constans
*/
class c2bTextEdit : public QTextEdit
{
    Q_OBJECT
public:
    c2bTextEdit(QWidget *parent = 0, const char *name = 0);
    ~c2bTextEdit();

    QAction* convertSelection2LaTeXAction;
    QAction* convertSelection2UnicodeAction;
    QAction* findTextAction;
    QAction* journalsToAbbreviatedAction;
    QAction* journalsToFullAction;
    QAction* pasteCurrentBibTeXAction;
    QAction* wordUnWrapAction;
    QAction* wordWrapAction;
    void setBibTeXActions();


signals:
    void journalsToAbbreviated();
    void journalsToFull();
    void overwriteModeChanged();
    void pasteCurrentBibTeX();


public slots:
    virtual void wordUnWrap();
    virtual void wordWrap();


protected slots:
    virtual void convert2LaTeX();
    virtual void convert2Unicode();
    virtual void findText();


protected:
    virtual QPopupMenu *createPopupMenu( const QPoint& pos );
    virtual void keyPressEvent( QKeyEvent * e );


private:
    bool m_bibtex_actions;
    QGuardedPtr<FindDialog> findDialog;

};

#endif
