/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef C2BUTILS_H
#define C2BUTILS_H

#include <qregexp.h>
#include <qstring.h>


/**
General cb2Bib Utils
 
@author Pere Constans
*/

extern bool isBibtoc2b( const QString& str );
extern bool isc2btoBib( const QString& str );
extern bool isUpperCaseString( const QString& );
extern QString Bibtoc2b( QString str );
extern QString c2btoAscii( QString str );
extern QString c2btoBib( QString str );
extern QString firstPage( QString pages );
extern void c2bDebug( QString debug_ms );
const QString PNAS_greek_letters = "[\\{\\[\\(](alpha|beta|gamma|delta|varepsilon|"
                                   "zeta|eta|theta|iota|kappa|lambda|mu|nu|xi|"
                                   "omicron|pi|rho|sigmaf|varsigma|sigma|tau|"
                                   "upsilon|phi|chi|psi|omega|vartheta|varphi|"
                                   "varpi|digamma|varkappa|varrho|epsilon)[\\}\\]\\)]";

#endif
