/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef CB2BIB_H
#define CB2BIB_H
#include "cb2bibbase.h"

#include <qguardedptr.h>


class bibSyntaxHighlighter;
class c2bBibParser;
class c2bClipboard;
class c2bEditor;
class c2bNetwork;
class c2bNetworkQuery;
class c2bSettings;
class cbSyntaxHighlighter;
class PDFImport;

class cb2Bib : public cb2bibbase
{
    Q_OBJECT

public:
    cb2Bib( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~cb2Bib();

    QPtrList<QAction*> aList;


signals:
    void addedBibtoFile( const QString& );
    void newSettingAvailable();


public slots:
    virtual void addAuthors();
    virtual void addEditor();
    virtual void anyPattern();
    virtual void clipbRC();
    virtual void closeEvent( QCloseEvent* ce );
    virtual void connectCB();
    virtual void dataChanged( const QString& );
    virtual void deleteTmpBib();
    virtual void getBF();
    virtual void guessFields();
    virtual void launchPDFImport();
    virtual void makeNetQuery();
    virtual void netQueryEnded( bool, const QString&, const QString& );
    virtual void readField( int );
    virtual void RegExpEditor();
    virtual void restartEngine();
    virtual void savePattern( const QString&, const QString& );
    virtual void setMessage( const QString& );
    virtual void settings();
    virtual void viewAbout();
    virtual void viewBib();


protected:
    bool m_connected;
    bool m_viewingabout;
    bool m_viewingbib;
    c2bBibParser *bp;
    c2bClipboard *cb;
    c2bEditor *bibe;
    c2bEditor *booke;
    c2bEditor *refe;
    c2bNetwork *net;
    c2bNetworkQuery *netQ;
    int m_viewingabout_x;
    int m_viewingabout_y;
    QGuardedPtr<PDFImport> pdfImport;
    QPopupMenu *pmenu;
    QPopupMenu *pomenu;
    void dragEnterEvent(QDragEnterEvent*);
    void dropEvent(QDropEvent*);
    void setButtonIcons();


private:
    bibSyntaxHighlighter *bibS;
    bool m_modified;
    c2bSettings *s;
    cbSyntaxHighlighter *cbS;
    QString encodeLink( const QString& ln );
    QString m_dropped_article_file;
    QString raw_input_data;
    void initBibTeXEditor();
    void setManualMenu();
    void switchViewButtons();


private slots:
    virtual void addToFile( bool ready );
    virtual void bibModified();
    virtual void BibTeXEditor();
    virtual void BibTeXEditorEnds();
    virtual void bookmarkEditor();
    virtual void bookmarkEditorEnds();
    virtual void c2bInit();
    virtual void displayHelp( const QString& ln );
    virtual void fileDropped( const QString& fn );
    virtual void linkClicked( const QString& ln );
    virtual void postProcessBibTeX();
    virtual void prepareAddToFile();
    virtual void preParseClipboard();
    virtual void preParserEnded( const QString& );
    virtual void processingEnded();
    virtual void REFileEditor();
    virtual void REFileEditorEnds();
    virtual void setArticleFileName();

};

#endif
