/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef CB2BIBCONF_H
#define CB2BIBCONF_H

#include "cb2bibconfbase.h"
#include "c2bcolors.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qfiledialog.h>
#include <qfontdatabase.h>
#include <qfont.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qsettings.h>
#include <qtoolbutton.h>


class cb2BibConf : public cb2bibconfbase
{
    Q_OBJECT

public:
    cb2BibConf(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~cb2BibConf();


signals:
    void helpRequested( const QString& ln );


private:
    bool m_author_editor_name_full;
    bool m_convert_entries_to_latex;
    bool m_journal_name_full;
    bool m_automatic_pdfimport;
    bool m_pp_month;
    c2bColors c;
    QFontDatabase db;
    QFont m_font;
    QPixmap pm;
    QString CopyMove;
    QStringList families;


protected slots:
    virtual void accept();
    virtual void changeContextColor(QListViewItem* item);
    virtual void comboFamilyChanged( const QString& family );
    virtual void comboSizeChanged( const QString& pt );
    virtual void FindReplaceDialog_Delete();
    virtual void FindReplaceDialog_Edit();
    virtual void FindReplaceDialog_New();
    virtual void FontSelection();
    virtual void getBibTeXPPBin();
    virtual void getClipboardPPBin();
    virtual void getFMClientCopyBin();
    virtual void getFMClientMoveBin();
    virtual void getFMClientOpenBin();
    virtual void getJAF();
    virtual void getNQF();
    virtual void getPDF2TBin();
    virtual void getPDFDir();
    virtual void getREF();
    virtual void Help();
    virtual void reject();
    virtual void updateFindReplaceButtons();

};

#endif
