/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "cbsyntaxhighlighter.h"

cbSyntaxHighlighter::cbSyntaxHighlighter( QTextEdit *textEdit )
        : QSyntaxHighlighter( textEdit )
{
    text_color = textEdit->color();
}

cbSyntaxHighlighter::~cbSyntaxHighlighter()
{}

int cbSyntaxHighlighter::highlightParagraph( const QString & text, int paraNo )
{
    paraNo = 0;
    int len = text.length();
    setFormat( 0, len - 1, text_color );

    QRegExp rx( "\\d+" );
    rx.setMinimal(TRUE);
    int pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_digit_color );
            pos  += rx.matchedLength();
        }
    }
    rx = QRegExp( "[^\\w\\d]+" );
    rx.setMinimal(TRUE);
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_unrelevant_color );
            pos  += rx.matchedLength();
        }
    }
    rx = QRegExp( "<(NewLine|Tab)\\d+>" );
    rx.setMinimal(TRUE);
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_unrelevant_color );
            pos  += rx.matchedLength();
        }
    }
    rx = QRegExp( "\\b(19|20)\\d\\d\\b" );
    rx.setMinimal(TRUE);
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_relevant_color );
            pos  += rx.matchedLength();
        }
    }
    rx = QRegExp( "\\b(abstract|authors{0,1}|introduction|issue|keywords|key words|title|volume|vol)\\b", FALSE );
    rx.setMinimal(TRUE);
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_highly_relevant_color );
            pos  += rx.matchedLength();
        }
    }
    rx = QRegExp( "<<(abstract|address|annote|author|booktitle|chapter|"
                  "doi|edition|editor|eprint|file|institution|isbn|issn|journal|"
                  "keywords|month|note|number|organization|pages|publisher|"
                  "school|series|title|url|volume|year)>>" );
    rx.setMinimal(TRUE);
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_tag_color );
            pos  += rx.matchedLength();
        }
    }
    rx = QRegExp( "<AnyPattern>" );
    rx.setMinimal(TRUE);
    pos = 0;
    while ( pos >= 0 )
    {
        pos = rx.search( text, pos );
        if ( pos > -1 )
        {
            setFormat( pos, rx.matchedLength(), c.cb2bib_unrelevant_color );
            pos  += rx.matchedLength();
        }
    }
    return paraNo;
}

void cbSyntaxHighlighter::reloadColors()
{
    c.loadColors();
    rehighlight();
}
