/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef CITEIDMAKER_H
#define CITEIDMAKER_H

#include <qobject.h>


class cb2bibbase;


/**
@author Pere Constans
*/
class citeIDMaker : public QObject
{
    Q_OBJECT
public:
    citeIDMaker(cb2bibbase *c2bMain, QObject *parent = 0, const char *name = 0);
    ~citeIDMaker();

    void makeCiteID();


protected slots:
    virtual void makeCiteID_author_all_initials();
    virtual void makeCiteID_author_first();
    virtual void makeCiteID_journal_initials();
    virtual void makeCiteID_pages_first();
    virtual void makeCiteID_volume();
    virtual void makeCiteID_year_abbreviated();
    virtual void makeCiteID_year_full();
    virtual void readSettings();


private:
    cb2bibbase* c2b;
    QString m_author;
    QString m_citeidpattern;
    QString m_journal;
    QString m_pages;
    QString m_volume;
    QString m_year;
    void setPatternConnections();

};

#endif
