/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "citeidmakerlineedit.h"
#include "cb2bib_par.h"

#include <qaction.h>
#include <qpopupmenu.h>


citeIDMakerLineEdit::citeIDMakerLineEdit(QWidget *parent, const char *name)
        : QLineEdit(parent, name)
{
    a_author_all_initials = new QAction( this, "author_all_initials" );
    a_author_first = new QAction( this, "author_first" );
    a_journal_initials = new QAction( this, "journal_initials" );
    a_pages_first = new QAction( this, "pages_first" );
    a_reset = new QAction( this, "reset" );
    a_volume = new QAction( this, "volume" );
    a_year_abbreviated = new QAction( this, "year_abbreviated" );
    a_year_full = new QAction( this, "year_full" );

    a_author_all_initials->setMenuText( tr( "Insert <<author_all_initials>>" ) );
    a_author_first->setMenuText( tr( "Insert <<author_first>>" ) );
    a_author_first->setMenuText( tr( "Insert <<author_first>>" ) );
    a_journal_initials->setMenuText( tr( "Insert <<journal_initials>>" ) );
    a_pages_first->setMenuText( tr( "Insert <<pages_first>>" ) );
    a_reset->setMenuText( tr( "Reset CiteID Pattern" ) );
    a_volume->setMenuText( tr( "Insert <<volume>>" ) );
    a_year_abbreviated->setMenuText( tr( "Insert <<year_abbreviated>>" ) );
    a_year_full->setMenuText( tr( "Insert <<year_full>>" ) );

    connect( a_author_all_initials, SIGNAL( activated() ), this, SLOT( author_all_initials() ) );
    connect( a_author_first, SIGNAL( activated() ), this, SLOT( author_first() ) );
    connect( a_journal_initials, SIGNAL( activated() ), this, SLOT( journal_initials() ) );
    connect( a_pages_first, SIGNAL( activated() ), this, SLOT( pages_first() ) );
    connect( a_reset, SIGNAL( activated() ), this, SLOT( reset() ) );
    connect( a_volume, SIGNAL( activated() ), this, SLOT( volume() ) );
    connect( a_year_abbreviated, SIGNAL( activated() ), this, SLOT( year_abbreviated() ) );
    connect( a_year_full, SIGNAL( activated() ), this, SLOT( year_full() ) );
}


citeIDMakerLineEdit::~citeIDMakerLineEdit()
{}


void citeIDMakerLineEdit::author_all_initials()
{
    insert("<<author_all_initials>>");
}

void citeIDMakerLineEdit::author_first()
{
    insert("<<author_first>>");
}

void citeIDMakerLineEdit::journal_initials()
{
    insert("<<journal_initials>>");
}

void citeIDMakerLineEdit::pages_first()
{
    insert("<<pages_first>>");
}

void citeIDMakerLineEdit::volume()
{
    insert("<<volume>>");
}

void citeIDMakerLineEdit::year_abbreviated()
{
    insert("<<year_abbreviated>>");
}

void citeIDMakerLineEdit::year_full()
{
    insert("<<year_full>>");
}

void citeIDMakerLineEdit::reset()
{
    setText( APP_CITE_ID_PATTERN );
}

QPopupMenu* citeIDMakerLineEdit::createPopupMenu()
{
    QPopupMenu* pm = QLineEdit::createPopupMenu();
    pm->insertSeparator();
    a_reset->addTo( pm );
    pm->insertSeparator();
    a_author_all_initials->addTo( pm );
    a_author_first->addTo( pm );
    a_journal_initials->addTo( pm );
    a_pages_first->addTo( pm );
    a_volume->addTo( pm );
    a_year_abbreviated->addTo( pm );
    a_year_full->addTo( pm );
    return pm;
}
