/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#include "colorlistviewitem.h"


ColorListViewItem::ColorListViewItem(QListView *parent, const QString &label, const QColor &textColor,
                                     const QString &colorName )
        : QListViewItem(parent, label)
{
    itemTextColor = textColor;
    itemTextColorName = colorName;
}

ColorListViewItem::~ColorListViewItem()
{}


void ColorListViewItem::paintCell(QPainter *painter, const QColorGroup &cg,
                                  int column, int width, int align)
{
    QColorGroup grp(cg);
    grp.setColor(QColorGroup::Text, itemTextColor);
    QListViewItem::paintCell(painter, grp, column, width, align);
}

void ColorListViewItem::setTextColor(const QColor &textColor)
{
    itemTextColor = textColor;
}

const QColor& ColorListViewItem::textColor()
{
    return(itemTextColor);
}

const QString& ColorListViewItem::textColorName()
{
    return(itemTextColorName);
}
