/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 ***************************************************************************/
#ifndef COLORLISTVIEWITEM_H
#define COLORLISTVIEWITEM_H

#include <qlistview.h>


/**
Text Colored List
 
*/
class ColorListViewItem : public QListViewItem
{

public:
    ColorListViewItem(QListView *parent, const QString &label, const QColor &textColor,
                      const QString &colorName);
    ~ColorListViewItem();

    void paintCell(QPainter *painter, const QColorGroup &cg,
                   int column, int width, int align);
    const QColor& textColor();
    const QString& textColorName();
    void setTextColor(const QColor &textColor);


private:
    QColor itemTextColor;
    QString itemTextColorName;

};

#endif
