/***************************************************************************
 *   Copyright (C) 2004-2006 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 0.6.1
 *   See LICENSE file that comes with this distribution
 *   FindDialog is adapted from Qt Designer
 *   Copyright (C) 2001 Trolltech AS.  All rights reserved.
 ***************************************************************************/
#include "finddialog.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qtextedit.h>


FindDialog::FindDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
        : FindDialogBase(parent,name, modal,fl)
{
    editor = (QTextEdit*) parent;
    connect( FindB, SIGNAL(clicked()), this, SLOT(doFind()) );
}

FindDialog::~FindDialog()
{}


void FindDialog::reject()
{
    QDialog::reject();
}

void FindDialog::doFind()
{
    if ( !editor )
        return;
    if ( checkBegin->isChecked() )
        editor->setCursorPosition( 1, 1 );
    if ( editor->find( comboFind->currentText(), checkCase->isChecked(),
                       checkWords->isChecked(), radioForward->isChecked() ) )
    {
        checkBegin->setChecked( FALSE );
        editor->scrollBy( 0, editor->visibleHeight()/2 );
        editor->ensureCursorVisible();
    }
    else
        checkBegin->setChecked( TRUE );
}
